/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.binary.builder;

import org.apache.ignite.binary.BinaryInvalidTypeException;
import org.apache.ignite.internal.binary.BinaryWriterExImpl;
import org.apache.ignite.internal.binary.builder.BinaryBuilderReader;
import org.apache.ignite.internal.binary.builder.BinaryBuilderSerializationAware;
import org.apache.ignite.internal.binary.builder.BinaryBuilderSerializer;
import org.apache.ignite.internal.util.typedef.internal.U;

public class BinaryBuilderEnum
implements BinaryBuilderSerializationAware {
    private final int ordinal;
    private final int typeId;
    private final String clsName;

    public BinaryBuilderEnum(int typeId, Enum anEnum) {
        this.ordinal = anEnum.ordinal();
        this.typeId = typeId;
        this.clsName = null;
    }

    public BinaryBuilderEnum(BinaryBuilderReader reader) {
        int typeId = reader.readInt();
        if (typeId == 0) {
            Class<?> cls;
            this.clsName = reader.readString();
            try {
                cls = U.forName(reader.readString(), reader.binaryContext().configuration().getClassLoader());
            }
            catch (ClassNotFoundException e) {
                throw new BinaryInvalidTypeException("Failed to load the class: " + this.clsName, e);
            }
            this.typeId = reader.binaryContext().descriptorForClass(cls, false, false).typeId();
        } else {
            this.typeId = typeId;
            this.clsName = null;
        }
        this.ordinal = reader.readInt();
    }

    public int getOrdinal() {
        return this.ordinal;
    }

    @Override
    public void writeTo(BinaryWriterExImpl writer, BinaryBuilderSerializer ctx) {
        writer.writeByte((byte)28);
        if (this.typeId == 0) {
            writer.writeInt(0);
            writer.writeString(this.clsName);
        } else {
            writer.writeInt(this.typeId);
        }
        writer.writeInt(this.ordinal);
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BinaryBuilderEnum that = (BinaryBuilderEnum)o;
        return this.ordinal == that.ordinal && this.typeId == that.typeId;
    }

    public int hashCode() {
        int result2 = this.ordinal;
        result2 = 31 * result2 + this.typeId;
        return result2;
    }
}

