/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal;

import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.IgniteSystemProperties;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.internal.S;

class LongJVMPauseDetector {
    private static final int PRECISION = IgniteSystemProperties.getInteger("IGNITE_JVM_PAUSE_DETECTOR_PRECISION", 50);
    private static final int THRESHOLD = IgniteSystemProperties.getInteger("IGNITE_JVM_PAUSE_DETECTOR_THRESHOLD", 500);
    private static final int EVT_CNT = IgniteSystemProperties.getInteger("IGNITE_JVM_PAUSE_DETECTOR_LAST_EVENTS_COUNT", 20);
    private final IgniteLogger log;
    private final AtomicReference<Thread> workerRef = new AtomicReference();
    private long longPausesCnt;
    private long longPausesTotalDuration;
    @GridToStringInclude
    private final long[] longPausesTimestamps = new long[EVT_CNT];
    @GridToStringInclude
    private final long[] longPausesDurations = new long[EVT_CNT];

    public LongJVMPauseDetector(IgniteLogger log2) {
        this.log = log2;
    }

    public void start() {
        if (IgniteSystemProperties.getBoolean("IGNITE_JVM_PAUSE_DETECTOR_DISABLED", false)) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("JVM Pause Detector is disabled.");
            }
            return;
        }
        Thread worker = new Thread("jvm-pause-detector-worker"){
            private long prev;
            {
                this.prev = System.currentTimeMillis();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (LongJVMPauseDetector.this.log.isDebugEnabled()) {
                    LongJVMPauseDetector.this.log.debug(this.getName() + " has been started.");
                }
                while (true) {
                    try {
                        long now;
                        long pause;
                        do {
                            Thread.sleep(PRECISION);
                            now = System.currentTimeMillis();
                            pause = now - (long)PRECISION - this.prev;
                            this.prev = now;
                        } while (pause < (long)THRESHOLD);
                        LongJVMPauseDetector.this.log.warning("Possible too long JVM pause: " + pause + " milliseconds.");
                        LongJVMPauseDetector longJVMPauseDetector = LongJVMPauseDetector.this;
                        synchronized (longJVMPauseDetector) {
                            int next2 = (int)(LongJVMPauseDetector.this.longPausesCnt % (long)EVT_CNT);
                            LongJVMPauseDetector.this.longPausesCnt++;
                            LongJVMPauseDetector.this.longPausesTotalDuration = LongJVMPauseDetector.this.longPausesTotalDuration + pause;
                            ((LongJVMPauseDetector)LongJVMPauseDetector.this).longPausesTimestamps[next2] = now;
                            ((LongJVMPauseDetector)LongJVMPauseDetector.this).longPausesDurations[next2] = pause;
                        }
                    }
                    catch (InterruptedException e) {
                        if (LongJVMPauseDetector.this.workerRef.compareAndSet(this, null)) {
                            LongJVMPauseDetector.this.log.error(this.getName() + " has been interrupted.", e);
                        } else if (LongJVMPauseDetector.this.log.isDebugEnabled()) {
                            LongJVMPauseDetector.this.log.debug(this.getName() + " has been stopped.");
                        }
                        return;
                    }
                }
            }
        };
        if (!this.workerRef.compareAndSet(null, worker)) {
            this.log.warning(LongJVMPauseDetector.class.getSimpleName() + " already started!");
            return;
        }
        worker.setDaemon(true);
        worker.start();
        if (this.log.isDebugEnabled()) {
            this.log.debug("LongJVMPauseDetector was successfully started");
        }
    }

    public void stop() {
        Thread worker = this.workerRef.getAndSet(null);
        if (worker != null && worker.isAlive() && !worker.isInterrupted()) {
            worker.interrupt();
        }
    }

    synchronized long longPausesCount() {
        return this.longPausesCnt;
    }

    synchronized long longPausesTotalDuration() {
        return this.longPausesTotalDuration;
    }

    synchronized Map<Long, Long> longPauseEvents() {
        TreeMap<Long, Long> evts = new TreeMap<Long, Long>();
        for (int i = 0; i < this.longPausesTimestamps.length && this.longPausesTimestamps[i] != 0L; ++i) {
            evts.put(this.longPausesTimestamps[i], this.longPausesDurations[i]);
        }
        return evts;
    }

    public String toString() {
        return S.toString(LongJVMPauseDetector.class, this);
    }
}

