/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.IgniteDiagnosticInfo;
import org.apache.ignite.internal.IgniteDiagnosticMessage;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.KeyCacheObject;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.util.typedef.CI1;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteClosure;
import org.apache.ignite.lang.IgniteInClosure;
import org.jetbrains.annotations.Nullable;

public class IgniteDiagnosticPrepareContext {
    private final UUID locNodeId;
    private final Map<UUID, CompoundInfoClosure> cls = new HashMap<UUID, CompoundInfoClosure>();

    public IgniteDiagnosticPrepareContext(UUID nodeId) {
        this.locNodeId = nodeId;
    }

    public void exchangeInfo(UUID nodeId, AffinityTopologyVersion topVer, String msg) {
        this.closure(nodeId).add(msg, new IgniteDiagnosticMessage.ExchangeInfoClosure(topVer));
    }

    public void txKeyInfo(UUID nodeId, int cacheId, Collection<KeyCacheObject> keys, String msg) {
        this.closure(nodeId).add(msg, new IgniteDiagnosticMessage.TxEntriesInfoClosure(cacheId, keys));
    }

    public void remoteTxInfo(UUID nodeId, GridCacheVersion dhtVer, GridCacheVersion nearVer, String msg) {
        this.closure(nodeId).add(msg, new IgniteDiagnosticMessage.TxInfoClosure(dhtVer, nearVer));
    }

    public void basicInfo(UUID nodeId, String msg) {
        this.closure(nodeId).add(msg, null);
    }

    private CompoundInfoClosure closure(UUID nodeId) {
        CompoundInfoClosure cl = this.cls.get(nodeId);
        if (cl == null) {
            cl = new CompoundInfoClosure(this.locNodeId);
            this.cls.put(nodeId, cl);
        }
        return cl;
    }

    public boolean empty() {
        return this.cls.isEmpty();
    }

    public void send(GridKernalContext ctx, @Nullable IgniteInClosure<IgniteInternalFuture<String>> lsnr) {
        for (Map.Entry<UUID, CompoundInfoClosure> entry2 : this.cls.entrySet()) {
            UUID rmtNodeId = entry2.getKey();
            CompoundInfoClosure c = entry2.getValue();
            IgniteInternalFuture<String> fut = ctx.cluster().requestDiagnosticInfo(rmtNodeId, c, c.message());
            if (lsnr != null) {
                fut.listen(lsnr);
            }
            this.listenAndLog(ctx.cluster().diagnosticLog(), fut);
        }
    }

    private void listenAndLog(final IgniteLogger log2, IgniteInternalFuture<String> fut) {
        fut.listen((IgniteInClosure<IgniteInternalFuture<String>>)new CI1<IgniteInternalFuture<String>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void apply(IgniteInternalFuture<String> fut) {
                Class<IgniteDiagnosticPrepareContext> clazz2 = IgniteDiagnosticPrepareContext.class;
                synchronized (IgniteDiagnosticPrepareContext.class) {
                    try {
                        if (log2.isInfoEnabled()) {
                            log2.info(fut.get());
                        }
                    }
                    catch (Exception e) {
                        U.error(log2, "Failed to dump diagnostic info: " + e, e);
                    }
                    return;
                }
            }
        });
    }

    private static final class CompoundInfoClosure
    implements IgniteClosure<GridKernalContext, IgniteDiagnosticInfo> {
        private static final long serialVersionUID = 0L;
        protected final UUID nodeId;
        private Map<Object, IgniteDiagnosticMessage.DiagnosticBaseClosure> cls = new LinkedHashMap<Object, IgniteDiagnosticMessage.DiagnosticBaseClosure>();
        private transient Map<Object, List<String>> msgs = new LinkedHashMap<Object, List<String>>();

        CompoundInfoClosure(UUID nodeId) {
            this.nodeId = nodeId;
        }

        @Override
        public final IgniteDiagnosticInfo apply(GridKernalContext ctx) {
            try {
                IgniteInternalFuture<String> commInfo = IgniteDiagnosticMessage.dumpCommunicationInfo(ctx, this.nodeId);
                StringBuilder sb = new StringBuilder();
                IgniteDiagnosticMessage.dumpNodeBasicInfo(sb, ctx);
                sb.append(U.nl());
                IgniteDiagnosticMessage.dumpExchangeInfo(sb, ctx);
                sb.append(U.nl());
                IgniteDiagnosticMessage.dumpPendingCacheMessages(sb, ctx);
                sb.append(commInfo.get(10000L));
                this.moreInfo(sb, ctx);
                return new IgniteDiagnosticInfo(sb.toString());
            }
            catch (Exception e) {
                ctx.cluster().diagnosticLog().error("Failed to execute diagnostic message closure: " + e, e);
                return new IgniteDiagnosticInfo("Failed to execute diagnostic message closure: " + e);
            }
        }

        private void moreInfo(StringBuilder sb, GridKernalContext ctx) {
            for (IgniteDiagnosticMessage.DiagnosticBaseClosure c : this.cls.values()) {
                try {
                    c.apply(sb, ctx);
                }
                catch (Exception e) {
                    ctx.cluster().diagnosticLog().error("Failed to populate diagnostic with additional information: " + e, e);
                    sb.append(U.nl()).append("Failed to populate diagnostic with additional information: ").append(e);
                }
            }
        }

        public UUID nodeId() {
            return this.nodeId;
        }

        public String message() {
            StringBuilder sb = new StringBuilder();
            for (List<String> msgs0 : this.msgs.values()) {
                for (String msg : msgs0) {
                    if (sb.length() > 0) {
                        sb.append('\n');
                    }
                    sb.append(msg);
                }
            }
            return sb.toString();
        }

        public void add(String msg, @Nullable IgniteDiagnosticMessage.DiagnosticBaseClosure c) {
            Class<?> key = c != null ? c.mergeKey() : this.getClass();
            List<String> msgs0 = this.msgs.get(key);
            if (msgs0 == null) {
                msgs0 = new ArrayList<String>();
                this.msgs.put(key, msgs0);
            }
            msgs0.add(msg);
            if (c != null) {
                IgniteDiagnosticMessage.DiagnosticBaseClosure c0 = this.cls.get(c.mergeKey());
                if (c0 == null) {
                    this.cls.put(c.mergeKey(), c);
                } else {
                    c0.merge(c);
                }
            }
        }
    }
}

