/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectStreamException;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.UUID;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteCompute;
import org.apache.ignite.IgniteDeploymentException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.cluster.ClusterGroup;
import org.apache.ignite.compute.ComputeTask;
import org.apache.ignite.compute.ComputeTaskFuture;
import org.apache.ignite.internal.AsyncSupportAdapter;
import org.apache.ignite.internal.ComputeTaskInternalFuture;
import org.apache.ignite.internal.GridClosureCallMode;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.cluster.ClusterGroupAdapter;
import org.apache.ignite.internal.managers.deployment.GridDeployment;
import org.apache.ignite.internal.processors.task.GridTaskThreadContextKey;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.A;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteCallable;
import org.apache.ignite.lang.IgniteClosure;
import org.apache.ignite.lang.IgniteFuture;
import org.apache.ignite.lang.IgnitePredicate;
import org.apache.ignite.lang.IgniteReducer;
import org.apache.ignite.lang.IgniteRunnable;
import org.apache.ignite.lang.IgniteUuid;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IgniteComputeImpl
extends AsyncSupportAdapter<IgniteCompute>
implements IgniteCompute,
Externalizable {
    private static final long serialVersionUID = 0L;
    private GridKernalContext ctx;
    private ClusterGroupAdapter prj;
    private UUID subjId;
    private String execName;

    public IgniteComputeImpl() {
    }

    public IgniteComputeImpl(GridKernalContext ctx, ClusterGroupAdapter prj, UUID subjId) {
        this(ctx, prj, subjId, false);
    }

    private IgniteComputeImpl(GridKernalContext ctx, ClusterGroupAdapter prj, UUID subjId, boolean async) {
        super(async);
        this.ctx = ctx;
        this.prj = prj;
        this.subjId = subjId;
    }

    private IgniteComputeImpl(GridKernalContext ctx, ClusterGroupAdapter prj, UUID subjId, boolean async, String execName) {
        super(async);
        this.ctx = ctx;
        this.prj = prj;
        this.subjId = subjId;
        this.execName = execName;
    }

    @Override
    protected IgniteCompute createAsyncInstance() {
        return new IgniteComputeImpl(this.ctx, this.prj, this.subjId, true);
    }

    @Override
    public ClusterGroup clusterGroup() {
        return this.prj;
    }

    @Override
    public void affinityRun(String cacheName, Object affKey, IgniteRunnable job) {
        CU.validateCacheName(cacheName);
        try {
            this.saveOrGet(this.affinityRunAsync0(cacheName, affKey, job));
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
    }

    @Override
    public IgniteFuture<Void> affinityRunAsync(String cacheName, Object affKey, IgniteRunnable job) throws IgniteException {
        CU.validateCacheName(cacheName);
        return this.createFuture(this.affinityRunAsync0(cacheName, affKey, job));
    }

    private IgniteInternalFuture<?> affinityRunAsync0(String cacheName, Object affKey, IgniteRunnable job) {
        A.notNull(affKey, "affKey");
        A.notNull(job, "job");
        this.guard();
        try {
            Object affKey0 = this.ctx.affinity().affinityKey(cacheName, affKey);
            int partId = this.ctx.affinity().partition(cacheName, affKey0);
            if (partId < 0) {
                throw new IgniteCheckedException("Failed map key to partition: [cache=" + cacheName + " key=" + affKey + ']');
            }
            ComputeTaskInternalFuture<?> computeTaskInternalFuture = this.ctx.closure().affinityRun(Collections.singletonList(cacheName), partId, job, this.prj.nodes(), this.execName);
            return computeTaskInternalFuture;
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
        finally {
            this.unguard();
        }
    }

    @Override
    public void affinityRun(@NotNull Collection<String> cacheNames, Object affKey, IgniteRunnable job) {
        CU.validateCacheNames(cacheNames);
        try {
            this.saveOrGet(this.affinityRunAsync0(cacheNames, affKey, job));
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
    }

    @Override
    public IgniteFuture<Void> affinityRunAsync(@NotNull Collection<String> cacheNames, Object affKey, IgniteRunnable job) throws IgniteException {
        CU.validateCacheNames(cacheNames);
        return this.createFuture(this.affinityRunAsync0(cacheNames, affKey, job));
    }

    private IgniteInternalFuture<?> affinityRunAsync0(@NotNull Collection<String> cacheNames, Object affKey, IgniteRunnable job) {
        A.notNull(affKey, "affKey");
        A.notNull(job, "job");
        A.ensure(!cacheNames.isEmpty(), "cachesNames mustn't be empty");
        this.guard();
        try {
            String cacheName = F.first(cacheNames);
            Object affKey0 = this.ctx.affinity().affinityKey(cacheName, affKey);
            int partId = this.ctx.affinity().partition(cacheName, affKey0);
            if (partId < 0) {
                throw new IgniteCheckedException("Failed map key to partition: [cache=" + cacheName + " key=" + affKey + ']');
            }
            ComputeTaskInternalFuture<?> computeTaskInternalFuture = this.ctx.closure().affinityRun(cacheNames, partId, job, this.prj.nodes(), this.execName);
            return computeTaskInternalFuture;
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
        finally {
            this.unguard();
        }
    }

    @Override
    public void affinityRun(@NotNull Collection<String> cacheNames, int partId, IgniteRunnable job) {
        CU.validateCacheNames(cacheNames);
        try {
            this.saveOrGet(this.affinityRunAsync0(cacheNames, partId, job));
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
    }

    @Override
    public IgniteFuture<Void> affinityRunAsync(@NotNull Collection<String> cacheNames, int partId, IgniteRunnable job) throws IgniteException {
        CU.validateCacheNames(cacheNames);
        return this.createFuture(this.affinityRunAsync0(cacheNames, partId, job));
    }

    private IgniteInternalFuture<?> affinityRunAsync0(@NotNull Collection<String> cacheNames, int partId, IgniteRunnable job) {
        A.ensure(partId >= 0, "partId = " + partId);
        A.notNull(job, "job");
        A.ensure(!cacheNames.isEmpty(), "cachesNames mustn't be empty");
        this.guard();
        try {
            ComputeTaskInternalFuture<?> computeTaskInternalFuture = this.ctx.closure().affinityRun(cacheNames, partId, job, this.prj.nodes(), this.execName);
            return computeTaskInternalFuture;
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
        finally {
            this.unguard();
        }
    }

    @Override
    public <R> R affinityCall(String cacheName, Object affKey, IgniteCallable<R> job) {
        CU.validateCacheName(cacheName);
        try {
            return this.saveOrGet(this.affinityCallAsync0(cacheName, affKey, job));
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
    }

    @Override
    public <R> IgniteFuture<R> affinityCallAsync(String cacheName, Object affKey, IgniteCallable<R> job) throws IgniteException {
        CU.validateCacheName(cacheName);
        return this.createFuture(this.affinityCallAsync0(cacheName, affKey, job));
    }

    private <R> IgniteInternalFuture<R> affinityCallAsync0(String cacheName, Object affKey, IgniteCallable<R> job) {
        A.notNull(affKey, "affKey");
        A.notNull(job, "job");
        this.guard();
        try {
            Object affKey0 = this.ctx.affinity().affinityKey(cacheName, affKey);
            int partId = this.ctx.affinity().partition(cacheName, affKey0);
            if (partId < 0) {
                throw new IgniteCheckedException("Failed map key to partition: [cache=" + cacheName + " key=" + affKey + ']');
            }
            ComputeTaskInternalFuture<R> computeTaskInternalFuture = this.ctx.closure().affinityCall(Collections.singletonList(cacheName), partId, job, this.prj.nodes(), this.execName);
            return computeTaskInternalFuture;
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
        finally {
            this.unguard();
        }
    }

    @Override
    public <R> R affinityCall(@NotNull Collection<String> cacheNames, Object affKey, IgniteCallable<R> job) {
        CU.validateCacheNames(cacheNames);
        try {
            return this.saveOrGet(this.affinityCallAsync0(cacheNames, affKey, job));
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
    }

    @Override
    public <R> IgniteFuture<R> affinityCallAsync(@NotNull Collection<String> cacheNames, Object affKey, IgniteCallable<R> job) throws IgniteException {
        CU.validateCacheNames(cacheNames);
        return this.createFuture(this.affinityCallAsync0(cacheNames, affKey, job));
    }

    private <R> IgniteInternalFuture<R> affinityCallAsync0(@NotNull Collection<String> cacheNames, Object affKey, IgniteCallable<R> job) {
        A.notNull(affKey, "affKey");
        A.notNull(job, "job");
        A.ensure(!cacheNames.isEmpty(), "cachesNames mustn't be empty");
        this.guard();
        try {
            String cacheName = F.first(cacheNames);
            Object affKey0 = this.ctx.affinity().affinityKey(cacheName, affKey);
            int partId = this.ctx.affinity().partition(cacheName, affKey0);
            if (partId < 0) {
                throw new IgniteCheckedException("Failed map key to partition: [cache=" + cacheName + " key=" + affKey + ']');
            }
            ComputeTaskInternalFuture<R> computeTaskInternalFuture = this.ctx.closure().affinityCall(cacheNames, partId, job, this.prj.nodes(), this.execName);
            return computeTaskInternalFuture;
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
        finally {
            this.unguard();
        }
    }

    @Override
    public <R> R affinityCall(@NotNull Collection<String> cacheNames, int partId, IgniteCallable<R> job) {
        CU.validateCacheNames(cacheNames);
        try {
            return this.saveOrGet(this.affinityCallAsync0(cacheNames, partId, job));
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
    }

    @Override
    public <R> IgniteFuture<R> affinityCallAsync(@NotNull Collection<String> cacheNames, int partId, IgniteCallable<R> job) throws IgniteException {
        CU.validateCacheNames(cacheNames);
        return this.createFuture(this.affinityCallAsync0(cacheNames, partId, job));
    }

    private <R> IgniteInternalFuture<R> affinityCallAsync0(@NotNull Collection<String> cacheNames, int partId, IgniteCallable<R> job) {
        A.ensure(partId >= 0, "partId = " + partId);
        A.notNull(job, "job");
        A.ensure(!cacheNames.isEmpty(), "cachesNames mustn't be empty");
        this.guard();
        try {
            ComputeTaskInternalFuture<R> computeTaskInternalFuture = this.ctx.closure().affinityCall(cacheNames, partId, job, this.prj.nodes(), this.execName);
            return computeTaskInternalFuture;
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
        finally {
            this.unguard();
        }
    }

    @Override
    public <T, R> R execute(String taskName, @Nullable T arg) {
        try {
            return this.saveOrGet(this.executeAsync0(taskName, arg));
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
    }

    @Override
    public <T, R> ComputeTaskFuture<R> executeAsync(String taskName, @Nullable T arg) throws IgniteException {
        return (ComputeTaskFuture)this.createFuture(this.executeAsync0(taskName, arg));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T, R> IgniteInternalFuture<R> executeAsync0(String taskName, @Nullable T arg) {
        A.notNull(taskName, "taskName");
        this.guard();
        try {
            this.ctx.task().setThreadContextIfNotNull(GridTaskThreadContextKey.TC_SUBGRID_PREDICATE, this.prj.predicate());
            this.ctx.task().setThreadContextIfNotNull(GridTaskThreadContextKey.TC_SUBJ_ID, this.subjId);
            ComputeTaskInternalFuture computeTaskInternalFuture = this.ctx.task().execute(taskName, arg, this.execName);
            return computeTaskInternalFuture;
        }
        finally {
            this.unguard();
        }
    }

    @Override
    public <T, R> R execute(Class<? extends ComputeTask<T, R>> taskCls, @Nullable T arg) {
        try {
            return this.saveOrGet(this.executeAsync0(taskCls, arg));
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
    }

    @Override
    public <T, R> ComputeTaskFuture<R> executeAsync(Class<? extends ComputeTask<T, R>> taskCls, @Nullable T arg) throws IgniteException {
        return (ComputeTaskFuture)this.createFuture(this.executeAsync0(taskCls, arg));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T, R> IgniteInternalFuture<R> executeAsync0(Class<? extends ComputeTask<T, R>> taskCls, @Nullable T arg) {
        A.notNull(taskCls, "taskCls");
        this.guard();
        try {
            this.ctx.task().setThreadContextIfNotNull(GridTaskThreadContextKey.TC_SUBGRID_PREDICATE, this.prj.predicate());
            this.ctx.task().setThreadContextIfNotNull(GridTaskThreadContextKey.TC_SUBJ_ID, this.subjId);
            ComputeTaskInternalFuture computeTaskInternalFuture = this.ctx.task().execute(taskCls, arg, this.execName);
            return computeTaskInternalFuture;
        }
        finally {
            this.unguard();
        }
    }

    @Override
    public <T, R> R execute(ComputeTask<T, R> task2, @Nullable T arg) {
        try {
            return this.saveOrGet(this.executeAsync0(task2, arg));
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
    }

    @Override
    public <T, R> ComputeTaskFuture<R> executeAsync(ComputeTask<T, R> task2, @Nullable T arg) throws IgniteException {
        return (ComputeTaskFuture)this.createFuture(this.executeAsync0(task2, arg));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T, R> ComputeTaskInternalFuture<R> executeAsync0(ComputeTask<T, R> task2, @Nullable T arg) {
        A.notNull(task2, "task");
        this.guard();
        try {
            this.ctx.task().setThreadContextIfNotNull(GridTaskThreadContextKey.TC_SUBGRID_PREDICATE, this.prj.predicate());
            this.ctx.task().setThreadContextIfNotNull(GridTaskThreadContextKey.TC_SUBJ_ID, this.subjId);
            ComputeTaskInternalFuture<R> computeTaskInternalFuture = this.ctx.task().execute(task2, arg, this.execName);
            return computeTaskInternalFuture;
        }
        finally {
            this.unguard();
        }
    }

    @Override
    public void broadcast(IgniteRunnable job) {
        try {
            this.saveOrGet(this.broadcastAsync0(job));
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
    }

    @Override
    public IgniteFuture<Void> broadcastAsync(IgniteRunnable job) throws IgniteException {
        return this.createFuture(this.broadcastAsync0(job));
    }

    private IgniteInternalFuture<?> broadcastAsync0(IgniteRunnable job) {
        A.notNull(job, "job");
        this.guard();
        try {
            ComputeTaskInternalFuture<?> computeTaskInternalFuture = this.ctx.closure().runAsync(GridClosureCallMode.BROADCAST, job, this.prj.nodes(), this.execName);
            return computeTaskInternalFuture;
        }
        finally {
            this.unguard();
        }
    }

    @Override
    public <R> Collection<R> broadcast(IgniteCallable<R> job) {
        try {
            return this.saveOrGet(this.broadcastAsync0(job));
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
    }

    @Override
    public <R> IgniteFuture<Collection<R>> broadcastAsync(IgniteCallable<R> job) throws IgniteException {
        return this.createFuture(this.broadcastAsync0(job));
    }

    private <R> IgniteInternalFuture<Collection<R>> broadcastAsync0(IgniteCallable<R> job) {
        A.notNull(job, "job");
        this.guard();
        try {
            ComputeTaskInternalFuture<Collection<R>> computeTaskInternalFuture = this.ctx.closure().callAsync(GridClosureCallMode.BROADCAST, Collections.singletonList(job), this.prj.nodes(), this.execName);
            return computeTaskInternalFuture;
        }
        finally {
            this.unguard();
        }
    }

    @Override
    public <R, T> Collection<R> broadcast(IgniteClosure<T, R> job, @Nullable T arg) {
        try {
            return this.saveOrGet(this.broadcastAsync0(job, arg));
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
    }

    @Override
    public <R, T> IgniteFuture<Collection<R>> broadcastAsync(IgniteClosure<T, R> job, @Nullable T arg) throws IgniteException {
        return this.createFuture(this.broadcastAsync0(job, arg));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <R, T> IgniteInternalFuture<Collection<R>> broadcastAsync0(IgniteClosure<T, R> job, @Nullable T arg) {
        A.notNull(job, "job");
        this.guard();
        try {
            IgniteInternalFuture<Collection<R>> igniteInternalFuture = this.ctx.closure().broadcast(job, arg, this.prj.nodes(), this.execName);
            return igniteInternalFuture;
        }
        finally {
            this.unguard();
        }
    }

    @Override
    public void run(IgniteRunnable job) {
        try {
            this.saveOrGet(this.runAsync0(job));
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
    }

    @Override
    public IgniteFuture<Void> runAsync(IgniteRunnable job) throws IgniteException {
        return this.createFuture(this.runAsync0(job));
    }

    private IgniteInternalFuture<?> runAsync0(IgniteRunnable job) {
        A.notNull(job, "job");
        this.guard();
        try {
            ComputeTaskInternalFuture<?> computeTaskInternalFuture = this.ctx.closure().runAsync(GridClosureCallMode.BALANCE, job, this.prj.nodes(), this.execName);
            return computeTaskInternalFuture;
        }
        finally {
            this.unguard();
        }
    }

    @Override
    public void run(Collection<? extends IgniteRunnable> jobs) {
        try {
            this.saveOrGet(this.runAsync0(jobs));
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
    }

    @Override
    public IgniteFuture<Void> runAsync(Collection<? extends IgniteRunnable> jobs) throws IgniteException {
        return this.createFuture(this.runAsync0(jobs));
    }

    private IgniteInternalFuture<?> runAsync0(Collection<? extends IgniteRunnable> jobs) {
        A.notEmpty(jobs, "jobs");
        this.guard();
        try {
            ComputeTaskInternalFuture<?> computeTaskInternalFuture = this.ctx.closure().runAsync(GridClosureCallMode.BALANCE, jobs, this.prj.nodes(), this.execName);
            return computeTaskInternalFuture;
        }
        finally {
            this.unguard();
        }
    }

    @Override
    public <R, T> R apply(IgniteClosure<T, R> job, @Nullable T arg) {
        try {
            return this.saveOrGet(this.applyAsync0(job, arg));
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
    }

    @Override
    public <R, T> IgniteFuture<R> applyAsync(IgniteClosure<T, R> job, @Nullable T arg) throws IgniteException {
        return this.createFuture(this.applyAsync0(job, arg));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <R, T> IgniteInternalFuture<R> applyAsync0(IgniteClosure<T, R> job, @Nullable T arg) {
        A.notNull(job, "job");
        this.guard();
        try {
            ComputeTaskInternalFuture<R> computeTaskInternalFuture = this.ctx.closure().callAsync(job, arg, this.prj.nodes(), this.execName);
            return computeTaskInternalFuture;
        }
        finally {
            this.unguard();
        }
    }

    @Override
    public <R> R call(IgniteCallable<R> job) {
        try {
            return this.saveOrGet(this.callAsync0(job));
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
    }

    @Override
    public <R> IgniteFuture<R> callAsync(IgniteCallable<R> job) throws IgniteException {
        return this.createFuture(this.callAsync0(job));
    }

    private <R> IgniteInternalFuture<R> callAsync0(IgniteCallable<R> job) {
        A.notNull(job, "job");
        this.guard();
        try {
            ComputeTaskInternalFuture<R> computeTaskInternalFuture = this.ctx.closure().callAsync(GridClosureCallMode.BALANCE, job, this.prj.nodes(), this.execName);
            return computeTaskInternalFuture;
        }
        finally {
            this.unguard();
        }
    }

    @Override
    public <R> Collection<R> call(Collection<? extends IgniteCallable<R>> jobs) {
        try {
            return this.saveOrGet(this.callAsync0(jobs));
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
    }

    @Override
    public <R> IgniteFuture<Collection<R>> callAsync(Collection<? extends IgniteCallable<R>> jobs) throws IgniteException {
        return this.createFuture(this.callAsync0(jobs));
    }

    private <R> IgniteInternalFuture<Collection<R>> callAsync0(Collection<? extends IgniteCallable<R>> jobs) {
        A.notEmpty(jobs, "jobs");
        this.guard();
        try {
            ComputeTaskInternalFuture computeTaskInternalFuture = this.ctx.closure().callAsync(GridClosureCallMode.BALANCE, jobs, this.prj.nodes(), this.execName);
            return computeTaskInternalFuture;
        }
        finally {
            this.unguard();
        }
    }

    @Override
    public <T, R> Collection<R> apply(IgniteClosure<T, R> job, @Nullable Collection<? extends T> args2) {
        try {
            return this.saveOrGet(this.applyAsync0(job, args2));
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
    }

    @Override
    public <T, R> IgniteFuture<Collection<R>> applyAsync(IgniteClosure<T, R> job, Collection<? extends T> args2) throws IgniteException {
        return this.createFuture(this.applyAsync0(job, args2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T, R> IgniteInternalFuture<Collection<R>> applyAsync0(IgniteClosure<T, R> job, @Nullable Collection<? extends T> args2) {
        A.notNull(job, "job");
        A.notNull(args2, "args");
        this.guard();
        try {
            ComputeTaskInternalFuture<Collection<R>> computeTaskInternalFuture = this.ctx.closure().callAsync(job, args2, this.prj.nodes(), this.execName);
            return computeTaskInternalFuture;
        }
        finally {
            this.unguard();
        }
    }

    @Override
    public <R1, R2> R2 call(Collection<? extends IgniteCallable<R1>> jobs, IgniteReducer<R1, R2> rdc) {
        try {
            return this.saveOrGet(this.callAsync0(jobs, rdc));
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
    }

    @Override
    public <R1, R2> IgniteFuture<R2> callAsync(Collection<? extends IgniteCallable<R1>> jobs, IgniteReducer<R1, R2> rdc) throws IgniteException {
        return this.createFuture(this.callAsync0(jobs, rdc));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <R1, R2> IgniteInternalFuture<R2> callAsync0(Collection<? extends IgniteCallable<R1>> jobs, IgniteReducer<R1, R2> rdc) {
        A.notEmpty(jobs, "jobs");
        A.notNull(rdc, "rdc");
        this.guard();
        try {
            ComputeTaskInternalFuture<R2> computeTaskInternalFuture = this.ctx.closure().forkjoinAsync(GridClosureCallMode.BALANCE, jobs, rdc, this.prj.nodes(), this.execName);
            return computeTaskInternalFuture;
        }
        finally {
            this.unguard();
        }
    }

    @Override
    public <R1, R2, T> R2 apply(IgniteClosure<T, R1> job, Collection<? extends T> args2, IgniteReducer<R1, R2> rdc) {
        try {
            return this.saveOrGet(this.applyAsync0(job, args2, rdc));
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
    }

    @Override
    public <R1, R2, T> IgniteFuture<R2> applyAsync(IgniteClosure<T, R1> job, Collection<? extends T> args2, IgniteReducer<R1, R2> rdc) throws IgniteException {
        return this.createFuture(this.applyAsync0(job, args2, rdc));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <R1, R2, T> IgniteInternalFuture<R2> applyAsync0(IgniteClosure<T, R1> job, Collection<? extends T> args2, IgniteReducer<R1, R2> rdc) {
        A.notNull(job, "job");
        A.notNull(rdc, "rdc");
        A.notNull(args2, "args");
        this.guard();
        try {
            ComputeTaskInternalFuture<R2> computeTaskInternalFuture = this.ctx.closure().callAsync(job, args2, rdc, this.prj.nodes(), this.execName);
            return computeTaskInternalFuture;
        }
        finally {
            this.unguard();
        }
    }

    @Override
    public <R> Map<IgniteUuid, ComputeTaskFuture<R>> activeTaskFutures() {
        this.guard();
        try {
            Map map2 = this.ctx.task().taskFutures();
            return map2;
        }
        finally {
            this.unguard();
        }
    }

    @Override
    public IgniteCompute withName(String taskName) {
        A.notNull(taskName, "taskName");
        this.guard();
        try {
            this.ctx.task().setThreadContext(GridTaskThreadContextKey.TC_TASK_NAME, taskName);
        }
        finally {
            this.unguard();
        }
        return this;
    }

    @Override
    public IgniteCompute withTimeout(long timeout) {
        A.ensure(timeout >= 0L, "timeout >= 0");
        this.guard();
        try {
            this.ctx.task().setThreadContext(GridTaskThreadContextKey.TC_TIMEOUT, timeout);
        }
        finally {
            this.unguard();
        }
        return this;
    }

    @Override
    public IgniteCompute withNoFailover() {
        this.guard();
        try {
            this.ctx.task().setThreadContext(GridTaskThreadContextKey.TC_NO_FAILOVER, true);
        }
        finally {
            this.unguard();
        }
        return this;
    }

    @Override
    public IgniteCompute withNoResultCache() {
        this.guard();
        try {
            this.ctx.task().setThreadContext(GridTaskThreadContextKey.TC_NO_RESULT_CACHE, true);
        }
        finally {
            this.unguard();
        }
        return this;
    }

    @Override
    public void localDeployTask(Class<? extends ComputeTask> taskCls, ClassLoader clsLdr) {
        A.notNull(taskCls, "taskCls", clsLdr, "clsLdr");
        this.guard();
        try {
            GridDeployment dep = this.ctx.deploy().deploy(taskCls, clsLdr);
            if (dep == null) {
                throw new IgniteDeploymentException("Failed to deploy task (was task (re|un)deployed?): " + taskCls);
            }
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
        finally {
            this.unguard();
        }
    }

    @Override
    public Map<String, Class<? extends ComputeTask<?, ?>>> localTasks() {
        this.guard();
        try {
            Map<String, Class<? extends ComputeTask<?, ?>>> map2 = this.ctx.deploy().findAllTasks(new IgnitePredicate[0]);
            return map2;
        }
        finally {
            this.unguard();
        }
    }

    @Override
    public void undeployTask(String taskName) {
        A.notNull(taskName, "taskName");
        this.guard();
        try {
            this.ctx.deploy().undeployTask(taskName, this.prj.node(this.ctx.localNodeId()) != null, this.prj.forRemotes().nodes());
        }
        finally {
            this.unguard();
        }
    }

    private void guard() {
        this.ctx.gateway().readLock();
    }

    private void unguard() {
        this.ctx.gateway().readUnlock();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.prj);
        out.writeObject(this.execName);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.prj = (ClusterGroupAdapter)in.readObject();
        this.execName = (String)in.readObject();
    }

    protected Object readResolve() throws ObjectStreamException {
        return this.execName == null ? this.prj.compute() : this.prj.compute().withExecutor(this.execName);
    }

    @Override
    protected <R> IgniteFuture<R> createFuture(IgniteInternalFuture<R> fut) {
        assert (fut instanceof ComputeTaskInternalFuture) : fut;
        return ((ComputeTaskInternalFuture)fut).publicFuture();
    }

    @Override
    public <R> ComputeTaskFuture<R> future() {
        return (ComputeTaskFuture)super.future();
    }

    @Override
    public IgniteCompute withExecutor(@NotNull String name) {
        return new IgniteComputeImpl(this.ctx, this.prj, this.subjId, this.isAsync(), name);
    }
}

