/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal;

import java.lang.reflect.Constructor;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.plugin.extensions.communication.MessageFactory;
import org.jetbrains.annotations.Nullable;

public enum IgniteComponentType {
    IGFS("org.apache.ignite.internal.processors.igfs.IgfsNoopProcessor", "org.apache.ignite.internal.processors.igfs.IgfsProcessor", "ignite-hadoop"),
    HADOOP("org.apache.ignite.internal.processors.hadoop.HadoopNoopProcessor", "org.apache.ignite.internal.processors.hadoop.HadoopProcessor", "ignite-hadoop"),
    HADOOP_HELPER("org.apache.ignite.internal.processors.hadoop.HadoopNoopHelper", "org.apache.ignite.internal.processors.hadoop.HadoopHelperImpl", "ignite-hadoop"),
    IGFS_HELPER("org.apache.ignite.internal.processors.igfs.IgfsNoopHelper", "org.apache.ignite.internal.processors.igfs.IgfsHelperImpl", "ignite-hadoop"),
    SPRING(null, "org.apache.ignite.internal.util.spring.IgniteSpringHelperImpl", "ignite-spring"),
    INDEXING(null, "org.apache.ignite.internal.processors.query.h2.IgniteH2Indexing", "ignite-indexing", "org.apache.ignite.internal.processors.query.h2.twostep.msg.GridH2ValueMessageFactory"),
    SSH(null, "org.apache.ignite.internal.util.nodestart.IgniteSshHelperImpl", "ignite-ssh"),
    JTA("org.apache.ignite.internal.processors.cache.jta.CacheNoopJtaManager", "org.apache.ignite.internal.processors.cache.jta.CacheJtaManager", "ignite-jta"),
    SCHEDULE("org.apache.ignite.internal.processors.schedule.IgniteNoopScheduleProcessor", "org.apache.ignite.internal.processors.schedule.IgniteScheduleProcessor", "ignite-schedule");

    private final String noOpClsName;
    private final String clsName;
    private final String module;
    private final String msgFactoryCls;

    private IgniteComponentType(String noOpClsName, String clsName, String module2) {
        this(noOpClsName, clsName, module2, null);
    }

    private IgniteComponentType(String noOpClsName, String clsName, String module2, String msgFactoryCls) {
        this.noOpClsName = noOpClsName;
        this.clsName = clsName;
        this.module = module2;
        this.msgFactoryCls = msgFactoryCls;
    }

    public String className() {
        return this.clsName;
    }

    public String module() {
        return this.module;
    }

    public boolean inClassPath() {
        try {
            Class.forName(this.clsName);
            return true;
        }
        catch (ClassNotFoundException ignore) {
            return false;
        }
    }

    public <T> T create(GridKernalContext ctx, boolean noOp) throws IgniteCheckedException {
        return this.create0(ctx, noOp ? this.noOpClsName : this.clsName);
    }

    public <T> T createIfInClassPath(GridKernalContext ctx, boolean mandatory) throws IgniteCheckedException {
        String cls = this.clsName;
        try {
            Class.forName(cls);
        }
        catch (ClassNotFoundException e) {
            if (mandatory) {
                throw this.componentException(e);
            }
            cls = this.noOpClsName;
        }
        return this.create0(ctx, cls);
    }

    public <T> T create(boolean noOp) throws IgniteCheckedException {
        return this.create0(null, noOp ? this.noOpClsName : this.clsName);
    }

    public <T> T createOptional(GridKernalContext ctx) throws IgniteCheckedException {
        return this.createOptional0(ctx);
    }

    public <T> T createOptional() throws IgniteCheckedException {
        return this.createOptional0(null);
    }

    private <T> T createOptional0(@Nullable GridKernalContext ctx) throws IgniteCheckedException {
        Class<?> cls;
        try {
            cls = Class.forName(this.clsName);
        }
        catch (ClassNotFoundException ignored) {
            try {
                cls = Class.forName(this.noOpClsName);
            }
            catch (ClassNotFoundException e) {
                throw new IgniteCheckedException("Failed to find both real component class and no-op class.", e);
            }
        }
        try {
            if (ctx == null) {
                Constructor<?> ctor = cls.getConstructor(new Class[0]);
                return (T)ctor.newInstance(new Object[0]);
            }
            Constructor<?> ctor = cls.getConstructor(GridKernalContext.class);
            return (T)ctor.newInstance(ctx);
        }
        catch (Exception e) {
            throw this.componentException(e);
        }
    }

    private <T> T create0(@Nullable GridKernalContext ctx, String clsName) throws IgniteCheckedException {
        try {
            Class<?> cls = Class.forName(clsName);
            if (ctx == null) {
                Constructor<?> ctor = cls.getConstructor(new Class[0]);
                return (T)ctor.newInstance(new Object[0]);
            }
            Constructor<?> ctor = cls.getConstructor(GridKernalContext.class);
            return (T)ctor.newInstance(ctx);
        }
        catch (Throwable e) {
            throw this.componentException(e);
        }
    }

    @Nullable
    public MessageFactory messageFactory() throws IgniteCheckedException {
        Class<?> cls;
        if (this.msgFactoryCls == null || null == (cls = U.classForName(this.msgFactoryCls, null))) {
            return null;
        }
        return (MessageFactory)U.newInstance(cls);
    }

    private IgniteCheckedException componentException(Throwable err2) {
        return new IgniteCheckedException("Failed to create Ignite component (consider adding " + this.module + " module to classpath) [component=" + (Object)((Object)this) + ", cls=" + this.clsName + ']', err2);
    }
}

