/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collection;
import java.util.UUID;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.compute.ComputeJobSibling;
import org.apache.ignite.internal.GridJobCancelRequest;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.GridTaskSessionImpl;
import org.apache.ignite.internal.GridTopic;
import org.apache.ignite.internal.cluster.ClusterTopologyCheckedException;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgnitePredicate;
import org.apache.ignite.lang.IgniteUuid;
import org.apache.ignite.plugin.extensions.communication.Message;

public class GridJobSiblingImpl
implements ComputeJobSibling,
Externalizable {
    private static final long serialVersionUID = 0L;
    private IgniteUuid sesId;
    private IgniteUuid jobId;
    private Object taskTopic;
    private Object jobTopic;
    private UUID nodeId;
    private boolean isJobDone;
    private transient GridKernalContext ctx;

    public GridJobSiblingImpl() {
    }

    public GridJobSiblingImpl(IgniteUuid sesId, IgniteUuid jobId, UUID nodeId, GridKernalContext ctx) {
        assert (sesId != null);
        assert (jobId != null);
        assert (nodeId != null);
        assert (ctx != null);
        this.sesId = sesId;
        this.jobId = jobId;
        this.nodeId = nodeId;
        this.ctx = ctx;
    }

    @Override
    public IgniteUuid getJobId() {
        return this.jobId;
    }

    public synchronized UUID nodeId() {
        return this.nodeId;
    }

    public synchronized void nodeId(UUID nodeId) {
        this.nodeId = nodeId;
        this.taskTopic = null;
        this.jobTopic = null;
    }

    public synchronized boolean isJobDone() {
        return this.isJobDone;
    }

    public synchronized void onJobDone() {
        this.isJobDone = true;
    }

    public synchronized Object taskTopic() {
        if (this.taskTopic == null) {
            this.taskTopic = GridTopic.TOPIC_TASK.topic(this.jobId, this.nodeId);
        }
        return this.taskTopic;
    }

    public synchronized Object jobTopic() {
        if (this.jobTopic == null) {
            this.jobTopic = GridTopic.TOPIC_JOB.topic(this.jobId, this.nodeId);
        }
        return this.jobTopic;
    }

    @Override
    public void cancel() {
        GridTaskSessionImpl ses = this.ctx.session().getSession(this.sesId);
        Collection<ClusterNode> nodes2 = ses == null ? this.ctx.discovery().remoteNodes() : this.ctx.discovery().nodes(ses.getTopology(), new IgnitePredicate[0]);
        for (ClusterNode node : nodes2) {
            if (this.ctx.localNodeId().equals(node.id())) continue;
            try {
                this.ctx.io().sendToGridTopic(node, GridTopic.TOPIC_JOB_CANCEL, (Message)new GridJobCancelRequest(this.sesId, this.jobId), (byte)2);
            }
            catch (ClusterTopologyCheckedException e) {
                IgniteLogger log2 = this.ctx.log(GridJobSiblingImpl.class);
                if (!log2.isDebugEnabled()) continue;
                log2.debug("Failed to send cancel request, node left [nodeId=" + node.id() + ", ses=" + ses + ']');
            }
            catch (IgniteCheckedException e) {
                if (this.ctx.discovery().node(node.id()) == null || !this.ctx.discovery().pingNodeNoError(node.id())) continue;
                U.error(this.ctx.log(GridJobSiblingImpl.class), "Failed to send cancel request to node [nodeId=" + node.id() + ", ses=" + ses + ']', e);
            }
        }
        this.ctx.job().cancelJob(this.sesId, this.jobId, false);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        U.writeGridUuid(out, this.sesId);
        U.writeGridUuid(out, this.jobId);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.sesId = U.readGridUuid(in);
        this.jobId = U.readGridUuid(in);
    }

    public String toString() {
        return S.toString(GridJobSiblingImpl.class, this);
    }
}

