/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.igfs.secondary.local;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileTime;
import java.nio.file.attribute.PosixFileAttributes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.igfs.IgfsBlockLocation;
import org.apache.ignite.igfs.IgfsException;
import org.apache.ignite.igfs.IgfsFile;
import org.apache.ignite.igfs.IgfsPath;
import org.apache.ignite.igfs.IgfsPathAlreadyExistsException;
import org.apache.ignite.igfs.IgfsPathIsNotDirectoryException;
import org.apache.ignite.igfs.IgfsPathNotFoundException;
import org.apache.ignite.igfs.secondary.IgfsSecondaryFileSystem;
import org.apache.ignite.igfs.secondary.IgfsSecondaryFileSystemPositionedReadable;
import org.apache.ignite.internal.processors.igfs.IgfsBlockLocationImpl;
import org.apache.ignite.internal.processors.igfs.IgfsDataManager;
import org.apache.ignite.internal.processors.igfs.IgfsImpl;
import org.apache.ignite.internal.processors.igfs.secondary.local.LocalFileSystemBlockKey;
import org.apache.ignite.internal.processors.igfs.secondary.local.LocalFileSystemIgfsFile;
import org.apache.ignite.internal.processors.igfs.secondary.local.LocalFileSystemPositionedReadable;
import org.apache.ignite.internal.processors.igfs.secondary.local.LocalFileSystemSizeVisitor;
import org.apache.ignite.internal.processors.igfs.secondary.local.LocalFileSystemUtils;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lifecycle.LifecycleAware;
import org.apache.ignite.resources.FileSystemResource;
import org.apache.ignite.resources.LoggerResource;
import org.jetbrains.annotations.Nullable;

public class LocalIgfsSecondaryFileSystem
implements IgfsSecondaryFileSystem,
LifecycleAware {
    private String workDir;
    @LoggerResource
    private IgniteLogger log;
    @FileSystemResource
    private IgfsImpl igfs;

    private IgfsException handleSecondaryFsError(IOException e, String msg) {
        if (e instanceof FileNotFoundException) {
            return new IgfsPathNotFoundException(e);
        }
        return new IgfsException(msg, e);
    }

    @Override
    public boolean exists(IgfsPath path2) {
        return this.fileForPath(path2).exists();
    }

    @Override
    @Nullable
    public IgfsFile update(IgfsPath path2, Map<String, String> props) {
        File f2 = this.fileForPath(path2);
        if (!f2.exists()) {
            return null;
        }
        this.updatePropertiesIfNeeded(path2, props);
        return this.info(path2);
    }

    @Override
    public void rename(IgfsPath src, IgfsPath dest) {
        File srcFile = this.fileForPath(src);
        File destFile = this.fileForPath(dest);
        if (!srcFile.exists()) {
            throw new IgfsPathNotFoundException("Failed to perform rename because source path not found: " + src);
        }
        if (srcFile.isDirectory() && destFile.isFile()) {
            throw new IgfsPathIsNotDirectoryException("Failed to perform rename because destination path is directory and source path is file [src=" + src + ", dest=" + dest + ']');
        }
        try {
            if (destFile.isDirectory()) {
                Files.move(srcFile.toPath(), destFile.toPath().resolve(srcFile.getName()), new CopyOption[0]);
            } else if (!srcFile.renameTo(destFile)) {
                throw new IgfsException("Failed to perform rename (underlying file system returned false) [src=" + src + ", dest=" + dest + ']');
            }
        }
        catch (IOException e) {
            throw this.handleSecondaryFsError(e, "Failed to rename [src=" + src + ", dest=" + dest + ']');
        }
    }

    @Override
    public boolean delete(IgfsPath path2, boolean recursive) {
        File f2 = this.fileForPath(path2);
        if (!recursive) {
            return f2.delete();
        }
        return this.deleteRecursive(f2, false);
    }

    private boolean deleteRecursive(File f2, boolean deleteIfExists) {
        BasicFileAttributes attrs;
        try {
            attrs = Files.readAttributes(f2.toPath(), BasicFileAttributes.class, LinkOption.NOFOLLOW_LINKS);
        }
        catch (IOException ignore) {
            return deleteIfExists && !f2.exists();
        }
        if (!attrs.isDirectory() || attrs.isSymbolicLink()) {
            return f2.delete() || deleteIfExists && !f2.exists();
        }
        File[] entries = f2.listFiles();
        if (entries != null) {
            for (File entry2 : entries) {
                boolean res = this.deleteRecursive(entry2, true);
                if (res) continue;
                return false;
            }
        }
        return f2.delete() || deleteIfExists && !f2.exists();
    }

    @Override
    public void mkdirs(IgfsPath path2) {
        if (!this.mkdirs0(this.fileForPath(path2))) {
            throw new IgniteException("Failed to make directories (underlying file system returned false): " + path2);
        }
    }

    @Override
    public void mkdirs(IgfsPath path2, @Nullable Map<String, String> props) {
        this.mkdirs(path2);
        this.updatePropertiesIfNeeded(path2, props);
    }

    private boolean mkdirs0(@Nullable File dir) {
        if (dir == null) {
            return true;
        }
        if (dir.exists()) {
            return dir.isDirectory();
        }
        File parentDir = dir.getParentFile();
        if (!this.mkdirs0(parentDir)) {
            return false;
        }
        boolean res = dir.mkdir();
        if (!res) {
            res = dir.exists();
        }
        return res;
    }

    @Override
    public Collection<IgfsPath> listPaths(IgfsPath path2) {
        File[] entries = this.listFiles0(path2);
        if (F.isEmpty(entries)) {
            return Collections.emptySet();
        }
        HashSet<IgfsPath> res = U.newHashSet(entries.length);
        for (File entry2 : entries) {
            res.add(this.igfsPath(entry2));
        }
        return res;
    }

    @Override
    public Collection<IgfsFile> listFiles(IgfsPath path2) {
        File[] entries = this.listFiles0(path2);
        if (F.isEmpty(entries)) {
            return Collections.emptySet();
        }
        HashSet<IgfsFile> res = U.newHashSet(entries.length);
        for (File entry2 : entries) {
            IgfsFile info2 = this.info(this.igfsPath(entry2));
            if (info2 == null) continue;
            res.add(info2);
        }
        return res;
    }

    @Nullable
    private File[] listFiles0(IgfsPath path2) {
        File f2 = this.fileForPath(path2);
        if (!f2.exists()) {
            throw new IgfsPathNotFoundException("Failed to list files (path not found): " + path2);
        }
        return f2.listFiles();
    }

    @Override
    public IgfsSecondaryFileSystemPositionedReadable open(IgfsPath path2, int bufSize) {
        try {
            FileInputStream in = new FileInputStream(this.fileForPath(path2));
            return new LocalFileSystemPositionedReadable(in, bufSize);
        }
        catch (IOException e) {
            throw this.handleSecondaryFsError(e, "Failed to open file for read: " + path2);
        }
    }

    @Override
    public OutputStream create(IgfsPath path2, boolean overwrite) {
        return this.create0(path2, overwrite);
    }

    @Override
    public OutputStream create(IgfsPath path2, int bufSize, boolean overwrite, int replication, long blockSize, @Nullable Map<String, String> props) {
        OutputStream os = this.create0(path2, overwrite);
        try {
            this.updatePropertiesIfNeeded(path2, props);
            return os;
        }
        catch (Exception err2) {
            try {
                os.close();
            }
            catch (IOException closeErr) {
                err2.addSuppressed(closeErr);
            }
            throw err2;
        }
    }

    @Override
    public OutputStream append(IgfsPath path2, int bufSize, boolean create, @Nullable Map<String, String> props) {
        try {
            File file = this.fileForPath(path2);
            boolean exists2 = file.exists();
            if (exists2) {
                FileOutputStream os = new FileOutputStream(file, true);
                try {
                    this.updatePropertiesIfNeeded(path2, props);
                    return os;
                }
                catch (Exception err2) {
                    try {
                        ((OutputStream)os).close();
                        throw err2;
                    }
                    catch (IOException closeErr) {
                        err2.addSuppressed(closeErr);
                        throw err2;
                    }
                }
            }
            if (create) {
                return this.create(path2, bufSize, false, 0, 0L, props);
            }
            throw new IgfsPathNotFoundException("Failed to append to file because it doesn't exist: " + path2);
        }
        catch (IOException e) {
            throw this.handleSecondaryFsError(e, "Failed to append to file because it doesn't exist: " + path2);
        }
    }

    @Override
    public IgfsFile info(IgfsPath path2) {
        File file = this.fileForPath(path2);
        if (!file.exists()) {
            return null;
        }
        boolean isDir = file.isDirectory();
        PosixFileAttributes attrs = LocalFileSystemUtils.posixAttributes(file);
        Map<String, String> props = LocalFileSystemUtils.posixAttributesToMap(attrs);
        BasicFileAttributes basicAttrs = LocalFileSystemUtils.basicAttributes(file);
        if (isDir) {
            return new LocalFileSystemIgfsFile(path2, false, true, 0, basicAttrs.lastAccessTime().toMillis(), basicAttrs.lastModifiedTime().toMillis(), 0L, props);
        }
        return new LocalFileSystemIgfsFile(path2, file.isFile(), false, 0, basicAttrs.lastAccessTime().toMillis(), basicAttrs.lastModifiedTime().toMillis(), file.length(), props);
    }

    @Override
    public long usedSpaceSize() {
        Path p = this.fileForPath(IgfsPath.ROOT).toPath();
        try {
            LocalFileSystemSizeVisitor visitor = new LocalFileSystemSizeVisitor();
            Files.walkFileTree(p, visitor);
            return visitor.size();
        }
        catch (IOException e) {
            throw new IgfsException("Failed to calculate used space size.", e);
        }
    }

    @Override
    public void setTimes(IgfsPath path2, long modificationTime, long accessTime) throws IgniteException {
        Path p = this.fileForPath(path2).toPath();
        if (!Files.exists(p, new LinkOption[0])) {
            throw new IgfsPathNotFoundException("Failed to set times (path not found): " + path2);
        }
        try {
            Files.getFileAttributeView(p, BasicFileAttributeView.class, new LinkOption[0]).setTimes(modificationTime >= 0L ? FileTime.from(modificationTime, TimeUnit.MILLISECONDS) : null, accessTime >= 0L ? FileTime.from(accessTime, TimeUnit.MILLISECONDS) : null, null);
        }
        catch (IOException e) {
            throw new IgniteException("Failed to set times for path: " + path2, e);
        }
    }

    @Override
    public void start() throws IgniteException {
        if (this.workDir != null) {
            this.workDir = new File(this.workDir).getAbsolutePath();
        }
    }

    @Override
    public void stop() throws IgniteException {
    }

    @Override
    public Collection<IgfsBlockLocation> affinity(IgfsPath path2, long start, long len, long maxLen) throws IgniteException {
        long lenStep;
        File f2 = this.fileForPath(path2);
        if (!f2.exists()) {
            throw new IgfsPathNotFoundException("File not found: " + path2);
        }
        long blockSize = this.igfs.configuration().getBlockSize();
        if (maxLen <= 0L) {
            maxLen = Long.MAX_VALUE;
        }
        assert (maxLen > 0L) : "maxLen : " + maxLen;
        long end = start + len;
        ArrayList<IgfsBlockLocation> blocks = new ArrayList<IgfsBlockLocation>((int)(len / maxLen));
        IgfsDataManager data = this.igfs.context().data();
        Collection<ClusterNode> lastNodes = null;
        long lastBlockIdx = -1L;
        IgfsBlockLocationImpl lastBlock = null;
        for (long offset = start; offset < end; offset += lenStep) {
            long blockIdx = offset / blockSize;
            lenStep = Math.min(maxLen - (lastBlock != null ? lastBlock.length() : 0L), (blockIdx + 1L) * blockSize - offset);
            lenStep = Math.min(lenStep, end - offset);
            LocalFileSystemBlockKey affKey = new LocalFileSystemBlockKey(path2, blockIdx);
            if (blockIdx != lastBlockIdx) {
                Collection<ClusterNode> nodes2 = data.affinityNodes(affKey);
                if (!nodes2.equals(lastNodes) && lastNodes != null && lastBlock != null) {
                    blocks.add(lastBlock);
                    lastBlock = null;
                }
                lastNodes = nodes2;
                lastBlockIdx = blockIdx;
            }
            if (lastBlock == null) {
                lastBlock = new IgfsBlockLocationImpl(offset, lenStep, lastNodes);
            } else {
                lastBlock.increaseLength(lenStep);
            }
            if (lastBlock.length() != maxLen && lastBlock.start() + lastBlock.length() != end) continue;
            blocks.add(lastBlock);
            lastBlock = null;
        }
        return blocks;
    }

    @Nullable
    public String getWorkDirectory() {
        return this.workDir;
    }

    public void setWorkDirectory(@Nullable String workDir) {
        this.workDir = workDir;
    }

    private File fileForPath(IgfsPath path2) {
        if (this.workDir == null) {
            return new File(path2.toString());
        }
        if ("/".equals(path2.toString())) {
            return new File(this.workDir);
        }
        return new File(this.workDir, path2.toString());
    }

    private IgfsPath igfsPath(File f2) throws IgfsException {
        String path2 = f2.getAbsolutePath();
        if (this.workDir != null) {
            if (!path2.startsWith(this.workDir)) {
                throw new IgfsException("Path is not located in the work directory [workDir=" + this.workDir + ", path=" + path2 + ']');
            }
            path2 = path2.substring(this.workDir.length(), path2.length());
        }
        return new IgfsPath(path2);
    }

    private OutputStream create0(IgfsPath path2, boolean overwrite) {
        File file = this.fileForPath(path2);
        boolean exists2 = file.exists();
        if (exists2) {
            if (!overwrite) {
                throw new IgfsPathAlreadyExistsException("Failed to create a file because it already exists: " + path2);
            }
        } else {
            File parent = file.getParentFile();
            if (!this.mkdirs0(parent)) {
                throw new IgfsException("Failed to create parent directory for file (underlying file system returned false): " + path2);
            }
        }
        try {
            return new FileOutputStream(file);
        }
        catch (IOException e) {
            throw this.handleSecondaryFsError(e, "Failed to create file [path=" + path2 + ", overwrite=" + overwrite + ']');
        }
    }

    private void updatePropertiesIfNeeded(IgfsPath path2, Map<String, String> props) {
        if (props == null || props.isEmpty()) {
            return;
        }
        File file = this.fileForPath(path2);
        if (!file.exists()) {
            throw new IgfsPathNotFoundException("Failed to update properties for path: " + path2);
        }
        LocalFileSystemUtils.updateProperties(file, props.get("grpName"), props.get("permission"));
    }
}

