/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.igfs;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.ignite.binary.BinaryObjectException;
import org.apache.ignite.binary.BinaryRawReader;
import org.apache.ignite.binary.BinaryRawWriter;
import org.apache.ignite.binary.BinaryReader;
import org.apache.ignite.binary.BinaryWriter;
import org.apache.ignite.binary.Binarylizable;
import org.apache.ignite.igfs.IgfsPath;
import org.apache.ignite.internal.processors.igfs.IgfsUtils;
import org.apache.ignite.internal.util.typedef.internal.S;

public class IgfsPathSummary
implements Externalizable,
Binarylizable {
    private static final long serialVersionUID = 0L;
    private IgfsPath path;
    private int filesCnt;
    private int dirCnt;
    private long totalLen;

    public IgfsPathSummary() {
    }

    public IgfsPathSummary(IgfsPath path2) {
        this.path = path2;
    }

    public int filesCount() {
        return this.filesCnt;
    }

    public void filesCount(int filesCnt) {
        this.filesCnt = filesCnt;
    }

    public int directoriesCount() {
        return this.dirCnt;
    }

    public void directoriesCount(int dirCnt) {
        this.dirCnt = dirCnt;
    }

    public long totalLength() {
        return this.totalLen;
    }

    public void totalLength(long totalLen) {
        this.totalLen = totalLen;
    }

    public IgfsPath path() {
        return this.path;
    }

    public void path(IgfsPath path2) {
        this.path = path2;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.filesCnt);
        out.writeInt(this.dirCnt);
        out.writeLong(this.totalLen);
        this.path.writeExternal(out);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.filesCnt = in.readInt();
        this.dirCnt = in.readInt();
        this.totalLen = in.readLong();
        this.path = IgfsUtils.readPath(in);
    }

    @Override
    public void writeBinary(BinaryWriter writer) throws BinaryObjectException {
        BinaryRawWriter rawWriter = writer.rawWriter();
        rawWriter.writeInt(this.filesCnt);
        rawWriter.writeInt(this.dirCnt);
        rawWriter.writeLong(this.totalLen);
        IgfsUtils.writePath(rawWriter, this.path);
    }

    @Override
    public void readBinary(BinaryReader reader) throws BinaryObjectException {
        BinaryRawReader rawReader = reader.rawReader();
        this.filesCnt = rawReader.readInt();
        this.dirCnt = rawReader.readInt();
        this.totalLen = rawReader.readLong();
        this.path = IgfsUtils.readPath(rawReader);
    }

    public String toString() {
        return S.toString(IgfsPathSummary.class, this);
    }
}

