/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.igfs;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.ignite.binary.BinaryObjectException;
import org.apache.ignite.binary.BinaryRawReader;
import org.apache.ignite.binary.BinaryRawWriter;
import org.apache.ignite.binary.BinaryReader;
import org.apache.ignite.binary.BinaryWriter;
import org.apache.ignite.binary.Binarylizable;
import org.apache.ignite.internal.util.io.GridFilenameUtils;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.A;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.jetbrains.annotations.Nullable;

public final class IgfsPath
implements Comparable<IgfsPath>,
Externalizable,
Binarylizable {
    private static final long serialVersionUID = 0L;
    private static final char SLASH_CHAR = '/';
    public static final String SLASH = "/";
    private String path;
    public static final IgfsPath ROOT = new IgfsPath("/");

    public IgfsPath() {
        this.path = SLASH;
    }

    public IgfsPath(URI uri) {
        A.notNull(uri, "uri");
        this.path = IgfsPath.normalizePath(uri.getPath());
    }

    public IgfsPath(String path2) {
        A.ensure(!F.isEmpty(path2), "'path' is null or empty");
        this.path = IgfsPath.normalizePath(path2);
    }

    public IgfsPath(IgfsPath parentPath, String childPath) {
        A.notNull(parentPath, "parentPath");
        String path2 = GridFilenameUtils.concat(parentPath.path, childPath);
        if (F.isEmpty(path2)) {
            throw new IllegalArgumentException("Failed to parse path [parent=" + parentPath + ", childPath=" + childPath + ']');
        }
        this.path = IgfsPath.normalizePath(path2);
    }

    private static String normalizePath(String path2) {
        assert (path2 != null);
        String normalizedPath = GridFilenameUtils.normalizeNoEndSeparator(path2, true);
        if (F.isEmpty(normalizedPath)) {
            throw new IllegalArgumentException("Failed to normalize path: " + path2);
        }
        if (!SLASH.equals(GridFilenameUtils.getPrefix(normalizedPath))) {
            throw new IllegalArgumentException("Path should be absolute: " + path2);
        }
        assert (!normalizedPath.isEmpty()) : "Expects normalized path is not empty.";
        assert (normalizedPath.length() == 1 || !normalizedPath.endsWith(SLASH)) : "Expects normalized path is root or don't ends with '/' symbol.";
        return normalizedPath;
    }

    public String name() {
        return GridFilenameUtils.getName(this.path);
    }

    public List<String> components() {
        String path2 = this.path;
        assert (path2.length() >= 1) : "Path expected to be absolute: " + path2;
        return path2.length() == 1 ? Collections.emptyList() : Arrays.asList(path2.substring(1).split(SLASH));
    }

    public String[] componentsArray() {
        return this.path.length() == 1 ? new String[]{} : this.path.substring(1).split(SLASH);
    }

    @Nullable
    public IgfsPath parent() {
        String path2 = this.path;
        if (path2.length() == 1) {
            return null;
        }
        path2 = GridFilenameUtils.getFullPathNoEndSeparator(path2);
        return new IgfsPath(path2);
    }

    public IgfsPath suffix(String suffix) {
        A.ensure(!F.isEmpty(suffix), "'suffix' is null or empty.");
        A.ensure(!suffix.contains(SLASH), "'suffix' contains file's separator '/'");
        return new IgfsPath(this.path + suffix);
    }

    public int depth() {
        String path2 = this.path;
        int size2 = path2.length();
        assert (size2 >= 1 && path2.charAt(0) == '/') : "Expects absolute path: " + path2;
        if (size2 == 1) {
            return 0;
        }
        int depth = 1;
        for (int i = 1; i < size2; ++i) {
            if (path2.charAt(i) != '/') continue;
            ++depth;
        }
        return depth;
    }

    public boolean isSubDirectoryOf(IgfsPath path2) {
        A.notNull(path2, "path");
        return this.path.startsWith(path2.path.endsWith(SLASH) ? path2.path : path2.path + SLASH);
    }

    @Override
    public int compareTo(IgfsPath o) {
        return this.path.compareTo(o.path);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        U.writeString(out, this.path);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException {
        this.path = U.readString(in);
    }

    @Override
    public void writeBinary(BinaryWriter writer) throws BinaryObjectException {
        this.writeRawBinary(writer.rawWriter());
    }

    @Override
    public void readBinary(BinaryReader reader) throws BinaryObjectException {
        this.readRawBinary(reader.rawReader());
    }

    public void writeRawBinary(BinaryRawWriter writer) throws BinaryObjectException {
        writer.writeString(this.path);
    }

    public void readRawBinary(BinaryRawReader reader) throws BinaryObjectException {
        this.path = reader.readString();
    }

    public int hashCode() {
        return this.path.hashCode();
    }

    public boolean equals(Object o) {
        return o == this || o != null && this.getClass() == o.getClass() && this.path.equals(((IgfsPath)o).path);
    }

    public String toString() {
        return this.path;
    }
}

