/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.compute.gridify.aop;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.LinkedList;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteCompute;
import org.apache.ignite.compute.gridify.GridifyInput;
import org.apache.ignite.compute.gridify.GridifyNodeFilter;
import org.apache.ignite.compute.gridify.GridifySetToValue;
import org.apache.ignite.compute.gridify.aop.GridifyDefaultRangeTask;
import org.apache.ignite.internal.compute.ComputeTaskTimeoutCheckedException;
import org.apache.ignite.internal.util.gridify.GridifyArgumentBuilder;
import org.apache.ignite.internal.util.gridify.GridifyRangeArgument;
import org.apache.ignite.internal.util.gridify.GridifyUtils;
import org.apache.ignite.internal.util.typedef.internal.U;

public class GridifySetToValueAbstractAspect {
    protected void checkMethodSignature(Method mtd) throws IgniteCheckedException {
        Class<?>[] paramTypes2 = mtd.getParameterTypes();
        LinkedList<Integer> allowedParamIdxs = new LinkedList<Integer>();
        for (int i = 0; i < paramTypes2.length; ++i) {
            Class<?> paramType = paramTypes2[i];
            if (!GridifyUtils.isMethodParameterTypeAllowed(paramType)) continue;
            allowedParamIdxs.add(i);
        }
        if (allowedParamIdxs.isEmpty()) {
            throw new IgniteCheckedException("Invalid method signature. Failed to get valid method parameter types [mtdName=" + mtd.getName() + ", allowedTypes=" + GridifyUtils.getAllowedMethodParameterTypes() + ']');
        }
        LinkedList<Integer> annParamIdxs = new LinkedList<Integer>();
        for (int i = 0; i < paramTypes2.length; ++i) {
            Class<?> paramType = paramTypes2[i];
            if (!GridifyUtils.isMethodParameterTypeAnnotated(paramType.getDeclaredAnnotations())) continue;
            annParamIdxs.add(i);
        }
        if (annParamIdxs.size() > 1) {
            throw new IgniteCheckedException("Invalid method signature. Only one method parameter can may annotated with @" + GridifyInput.class.getSimpleName() + "[mtdName=" + mtd.getName() + ", allowedTypes=" + GridifyUtils.getAllowedMethodParameterTypes() + ", annParamIdxs=" + annParamIdxs + ']');
        }
        if (allowedParamIdxs.size() > 1 && annParamIdxs.isEmpty()) {
            throw new IgniteCheckedException("Invalid method signature. Method parameter must be annotated with @" + GridifyInput.class.getSimpleName() + "[mtdName=" + mtd.getName() + ", allowedTypes=" + GridifyUtils.getAllowedMethodParameterTypes() + ", allowedParamIdxs=" + allowedParamIdxs + ']');
        }
        if (!annParamIdxs.isEmpty() && !allowedParamIdxs.contains(annParamIdxs.get(0))) {
            throw new IgniteCheckedException("Invalid method signature. Invalid annotated parameter [mtdName=" + mtd.getName() + ", allowedTypes=" + GridifyUtils.getAllowedMethodParameterTypes() + ", allowedParamIdxs=" + allowedParamIdxs + ", annParamIdxs=" + annParamIdxs + ']');
        }
    }

    protected void checkIsSplitToJobsAllowed(GridifyRangeArgument arg, GridifySetToValue ann) throws IgniteCheckedException {
        if (arg.getInputSize() == -1 && ann.threshold() <= 0 && ann.splitSize() <= 0) {
            throw new IgniteCheckedException("Failed to split input method argument to jobs with unknown input size and invalid annotation parameter 'splitSize' [mtdName=" + arg.getMethodName() + ", inputTypeCls=" + arg.getMethodParameterTypes()[arg.getParamIndex()].getName() + ", threshold=" + ann.threshold() + ", splitSize=" + ann.splitSize() + ']');
        }
    }

    protected Object execute(Method mtd, IgniteCompute compute2, Class<?> cls, GridifyRangeArgument arg, GridifyNodeFilter nodeFilter, int threshold, int splitSize, long timeout) throws IgniteCheckedException {
        long end;
        long now = U.currentTimeMillis();
        long l = end = timeout == 0L ? Long.MAX_VALUE : timeout + now;
        if (end < 0L) {
            end = Long.MAX_VALUE;
        }
        Collection res = null;
        while (true) {
            if (now > end) {
                throw new ComputeTaskTimeoutCheckedException("Timeout occurred while waiting for completion.");
            }
            GridifyRangeArgument taskArg = this.createGridifyArgument(arg, res);
            if (taskArg == null) {
                return this.result(res);
            }
            if (taskArg.getInputSize() != -1 && taskArg.getInputSize() <= threshold) {
                try {
                    mtd.setAccessible(true);
                    return mtd.invoke(arg.getTarget(), taskArg.getMethodParameters());
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    throw new IgniteCheckedException("Failed to execute method locally.", e);
                }
            }
            res = (Collection)compute2.withTimeout(timeout == 0L ? 0L : end - now).execute(new GridifyDefaultRangeTask(cls, nodeFilter, threshold, splitSize, true), taskArg);
            now = U.currentTimeMillis();
        }
    }

    private GridifyRangeArgument createGridifyArgument(GridifyRangeArgument arg, Collection<?> taskRes) throws IgniteCheckedException {
        if (taskRes == null) {
            return arg;
        }
        if (taskRes.size() == 1) {
            return null;
        }
        return new GridifyArgumentBuilder().createTaskArgument(arg, taskRes);
    }

    private Object result(Collection<?> res) {
        assert (res != null);
        assert (res.size() == 1);
        return res.iterator().next();
    }
}

