/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.cache.store.jdbc.dialect;

import java.util.Collection;
import org.apache.ignite.cache.store.jdbc.dialect.JdbcDialect;
import org.apache.ignite.internal.util.typedef.C1;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.SB;

public class BasicJdbcDialect
implements JdbcDialect {
    private static final long serialVersionUID = 0L;
    protected static final int DFLT_MAX_PARAMS_CNT = 2000;
    protected int maxParamsCnt = 2000;

    protected static <T> String mkString(Iterable<T> elems, C1<T, String> f2, String start, String sep, String end) {
        SB sb = new SB(start);
        boolean first = true;
        for (T elem2 : elems) {
            if (!first) {
                sb.a(sep);
            }
            sb.a((String)f2.apply(elem2));
            first = false;
        }
        return sb.a(end).toString();
    }

    protected static String mkString(Iterable<String> strs, String start, String sep, String end) {
        return BasicJdbcDialect.mkString(strs, new C1<String, String>(){

            @Override
            public String apply(String s2) {
                return s2;
            }
        }, start, sep, end);
    }

    protected static String mkString(Iterable<String> strs, String sep) {
        return BasicJdbcDialect.mkString(strs, new C1<String, String>(){

            @Override
            public String apply(String s2) {
                return s2;
            }
        }, "", sep, "");
    }

    protected static String repeat(String str, int cnt, String start, String sep, String end) {
        SB sb = new SB(str.length() * cnt + sep.length() * (cnt - 1) + start.length() + end.length());
        sb.a(start);
        for (int i = 0; i < cnt; ++i) {
            if (i > 0) {
                sb.a(sep);
            }
            sb.a(str);
        }
        return sb.a(end).toString();
    }

    private static String where(Collection<String> keyCols, int keyCnt) {
        SB sb = new SB();
        if (keyCols.size() == 1) {
            String keyCol = keyCols.iterator().next();
            if (keyCnt == 1) {
                sb.a(keyCol + "=?");
            } else {
                sb.a(BasicJdbcDialect.repeat("?", keyCnt, keyCol + " IN (", ",", ")"));
            }
        } else {
            String keyParams = BasicJdbcDialect.mkString(keyCols, new C1<String, String>(){

                @Override
                public String apply(String s2) {
                    return s2 + "=?";
                }
            }, "(", " AND ", ")");
            sb.a(BasicJdbcDialect.repeat(keyParams, keyCnt, "", " OR ", ""));
        }
        return sb.toString();
    }

    @Override
    public String escape(String ident2) {
        return '\"' + ident2 + '\"';
    }

    @Override
    public String loadCacheSelectRangeQuery(String fullTblName, Collection<String> keyCols) {
        String cols = BasicJdbcDialect.mkString(keyCols, ",");
        return String.format("SELECT %1$s FROM (SELECT %1$s, ROW_NUMBER() OVER() AS rn FROM (SELECT %1$s FROM %2$s ORDER BY %1$s) AS tbl) AS tbl WHERE mod(rn, ?) = 0", cols, fullTblName);
    }

    @Override
    public String loadCacheRangeQuery(String fullTblName, Collection<String> keyCols, Iterable<String> uniqCols, boolean appendLowerBound, boolean appendUpperBound) {
        int idx;
        int keyCnt;
        assert (appendLowerBound || appendUpperBound);
        SB sb = new SB();
        String[] cols = keyCols.toArray(new String[keyCols.size()]);
        if (appendLowerBound) {
            sb.a("(");
            for (keyCnt = keyCols.size(); keyCnt > 0; --keyCnt) {
                for (idx = 0; idx < keyCnt; ++idx) {
                    if (idx == keyCnt - 1) {
                        sb.a(cols[idx]).a(" > ? ");
                        continue;
                    }
                    sb.a(cols[idx]).a(" = ? AND ");
                }
                if (keyCnt == 1) continue;
                sb.a("OR ");
            }
            sb.a(")");
        }
        if (appendLowerBound && appendUpperBound) {
            sb.a(" AND ");
        }
        if (appendUpperBound) {
            sb.a("(");
            for (keyCnt = keyCols.size(); keyCnt > 0; --keyCnt) {
                int lastIdx = keyCnt - 1;
                for (idx = 0; idx < keyCnt; ++idx) {
                    sb.a(cols[idx]);
                    if (idx == lastIdx) {
                        sb.a(keyCnt == keyCols.size() ? " <= ? " : " < ? ");
                        continue;
                    }
                    sb.a(" = ? AND ");
                }
                if (keyCnt == 1) continue;
                sb.a(" OR ");
            }
            sb.a(")");
        }
        return String.format("SELECT %s FROM %s WHERE %s", BasicJdbcDialect.mkString(uniqCols, ","), fullTblName, sb.toString());
    }

    @Override
    public String loadCacheQuery(String fullTblName, Iterable<String> uniqCols) {
        return String.format("SELECT %s FROM %s", BasicJdbcDialect.mkString(uniqCols, ","), fullTblName);
    }

    @Override
    public String loadQuery(String fullTblName, Collection<String> keyCols, Iterable<String> cols, int keyCnt) {
        assert (!keyCols.isEmpty());
        String params2 = BasicJdbcDialect.where(keyCols, keyCnt);
        return String.format("SELECT %s FROM %s WHERE %s", BasicJdbcDialect.mkString(cols, ","), fullTblName, params2);
    }

    @Override
    public String insertQuery(String fullTblName, Collection<String> keyCols, Collection<String> valCols) {
        Collection<String> cols = F.concat(false, keyCols, valCols);
        return String.format("INSERT INTO %s(%s) VALUES(%s)", fullTblName, BasicJdbcDialect.mkString(cols, ","), BasicJdbcDialect.repeat("?", cols.size(), "", ",", ""));
    }

    @Override
    public String updateQuery(String fullTblName, Collection<String> keyCols, Iterable<String> valCols) {
        String params2 = BasicJdbcDialect.mkString(valCols, new C1<String, String>(){

            @Override
            public String apply(String s2) {
                return s2 + "=?";
            }
        }, "", ",", "");
        return String.format("UPDATE %s SET %s WHERE %s", fullTblName, params2, BasicJdbcDialect.where(keyCols, 1));
    }

    @Override
    public boolean hasMerge() {
        return false;
    }

    @Override
    public String mergeQuery(String fullTblName, Collection<String> keyCols, Collection<String> uniqCols) {
        return "";
    }

    @Override
    public String removeQuery(String fullTblName, Iterable<String> keyCols) {
        String whereParams = BasicJdbcDialect.mkString(keyCols, new C1<String, String>(){

            @Override
            public String apply(String s2) {
                return s2 + "=?";
            }
        }, "", " AND ", "");
        return String.format("DELETE FROM %s WHERE %s", fullTblName, whereParams);
    }

    @Override
    public int getMaxParameterCount() {
        return this.maxParamsCnt;
    }

    public void setMaxParameterCount(int maxParamsCnt) {
        this.maxParamsCnt = maxParamsCnt;
    }

    @Override
    public int getFetchSize() {
        return 0;
    }
}

