/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.cache.store.jdbc;

import java.sql.Connection;
import java.sql.SQLException;
import javax.cache.integration.CacheWriterException;
import javax.sql.DataSource;
import org.apache.ignite.IgniteException;
import org.apache.ignite.cache.store.CacheStoreSession;
import org.apache.ignite.cache.store.CacheStoreSessionListener;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lifecycle.LifecycleAware;

public class CacheJdbcStoreSessionListener
implements CacheStoreSessionListener,
LifecycleAware {
    private DataSource dataSrc;

    public void setDataSource(DataSource dataSrc) {
        this.dataSrc = dataSrc;
    }

    public DataSource getDataSource() {
        return this.dataSrc;
    }

    @Override
    public void start() throws IgniteException {
        if (this.dataSrc == null) {
            throw new IgniteException("Data source is required by " + this.getClass().getSimpleName() + '.');
        }
    }

    @Override
    public void stop() throws IgniteException {
    }

    @Override
    public void onSessionStart(CacheStoreSession ses) {
        if (ses.attachment() == null) {
            try {
                Connection conn = this.dataSrc.getConnection();
                conn.setAutoCommit(false);
                ses.attach(conn);
            }
            catch (SQLException e) {
                throw new CacheWriterException("Failed to start store session [tx=" + ses.transaction() + ']', e);
            }
        }
    }

    @Override
    public void onSessionEnd(CacheStoreSession ses, boolean commit2) {
        Connection conn = (Connection)ses.attach(null);
        if (conn != null) {
            try {
                if (commit2) {
                    conn.commit();
                } else {
                    conn.rollback();
                }
            }
            catch (SQLException e) {
                throw new CacheWriterException("Failed to end store session [tx=" + ses.transaction() + ']', e);
            }
            finally {
                U.closeQuiet(conn);
            }
        }
    }
}

