/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.cache.store.jdbc;

import javax.cache.configuration.Factory;
import javax.sql.DataSource;
import org.apache.ignite.IgniteException;
import org.apache.ignite.cache.store.jdbc.CacheAbstractJdbcStore;
import org.apache.ignite.cache.store.jdbc.CacheJdbcPojoStore;
import org.apache.ignite.cache.store.jdbc.JdbcType;
import org.apache.ignite.cache.store.jdbc.JdbcTypeDefaultHasher;
import org.apache.ignite.cache.store.jdbc.JdbcTypeHasher;
import org.apache.ignite.cache.store.jdbc.JdbcTypesDefaultTransformer;
import org.apache.ignite.cache.store.jdbc.JdbcTypesTransformer;
import org.apache.ignite.cache.store.jdbc.dialect.JdbcDialect;
import org.apache.ignite.internal.IgniteComponentType;
import org.apache.ignite.internal.util.spring.IgniteSpringHelper;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.resources.SpringApplicationContextResource;

public class CacheJdbcPojoStoreFactory<K, V>
implements Factory<CacheAbstractJdbcStore<K, V>> {
    private static final long serialVersionUID = 0L;
    public static final int DFLT_WRITE_ATTEMPTS = 2;
    public static final int DFLT_BATCH_SIZE = 512;
    public static final int DFLT_PARALLEL_LOAD_CACHE_MINIMUM_THRESHOLD = 512;
    private int batchSize = 512;
    private String dataSrcBean;
    private JdbcDialect dialect;
    private int maxPoolSize = Runtime.getRuntime().availableProcessors();
    private int maxWrtAttempts = 2;
    private int parallelLoadCacheMinThreshold = 512;
    private JdbcTypeHasher hasher = JdbcTypeDefaultHasher.INSTANCE;
    private JdbcTypesTransformer transformer = JdbcTypesDefaultTransformer.INSTANCE;
    private JdbcType[] types;
    private transient DataSource dataSrc;
    private Factory<DataSource> dataSrcFactory;
    private boolean sqlEscapeAll;
    @SpringApplicationContextResource
    private transient Object appCtx;

    @Override
    public CacheJdbcPojoStore<K, V> create() {
        CacheJdbcPojoStore store = new CacheJdbcPojoStore();
        store.setBatchSize(this.batchSize);
        store.setDialect(this.dialect);
        store.setMaximumPoolSize(this.maxPoolSize);
        store.setMaximumWriteAttempts(this.maxWrtAttempts);
        store.setParallelLoadCacheMinimumThreshold(this.parallelLoadCacheMinThreshold);
        store.setTypes(this.types);
        store.setHasher(this.hasher);
        store.setTransformer(this.transformer);
        store.setSqlEscapeAll(this.sqlEscapeAll);
        if (this.dataSrc != null) {
            store.setDataSource(this.dataSrc);
        } else if (this.dataSrcBean != null) {
            if (this.appCtx == null) {
                throw new IgniteException("Spring application context resource is not injected.");
            }
            try {
                IgniteSpringHelper spring = (IgniteSpringHelper)IgniteComponentType.SPRING.create(false);
                DataSource data = (DataSource)spring.loadBeanFromAppContext(this.appCtx, this.dataSrcBean);
                store.setDataSource(data);
            }
            catch (Exception e) {
                throw new IgniteException("Failed to load bean in application context [beanName=" + this.dataSrcBean + ", igniteConfig=" + this.appCtx + ']', e);
            }
        } else if (this.dataSrcFactory != null) {
            store.setDataSource(this.dataSrcFactory.create());
        }
        return store;
    }

    @Deprecated
    public CacheJdbcPojoStoreFactory<K, V> setDataSource(DataSource dataSrc) {
        this.dataSrc = dataSrc;
        return this;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public CacheJdbcPojoStoreFactory setBatchSize(int batchSize) {
        this.batchSize = batchSize;
        return this;
    }

    public String getDataSourceBean() {
        return this.dataSrcBean;
    }

    public CacheJdbcPojoStoreFactory setDataSourceBean(String dataSrcBean) {
        this.dataSrcBean = dataSrcBean;
        return this;
    }

    public JdbcDialect getDialect() {
        return this.dialect;
    }

    public CacheJdbcPojoStoreFactory setDialect(JdbcDialect dialect) {
        this.dialect = dialect;
        return this;
    }

    public int getMaximumPoolSize() {
        return this.maxPoolSize;
    }

    public CacheJdbcPojoStoreFactory setMaximumPoolSize(int maxPoolSize) {
        this.maxPoolSize = maxPoolSize;
        return this;
    }

    public int getMaximumWriteAttempts() {
        return this.maxWrtAttempts;
    }

    public CacheJdbcPojoStoreFactory setMaximumWriteAttempts(int maxWrtAttempts) {
        this.maxWrtAttempts = maxWrtAttempts;
        return this;
    }

    public int getParallelLoadCacheMinimumThreshold() {
        return this.parallelLoadCacheMinThreshold;
    }

    public CacheJdbcPojoStoreFactory setParallelLoadCacheMinimumThreshold(int parallelLoadCacheMinThreshold) {
        this.parallelLoadCacheMinThreshold = parallelLoadCacheMinThreshold;
        return this;
    }

    public JdbcType[] getTypes() {
        return this.types;
    }

    public CacheJdbcPojoStoreFactory setTypes(JdbcType ... types2) {
        this.types = types2;
        return this;
    }

    public JdbcTypeHasher getHasher() {
        return this.hasher;
    }

    public CacheJdbcPojoStoreFactory setHasher(JdbcTypeHasher hasher) {
        this.hasher = hasher;
        return this;
    }

    public JdbcTypesTransformer getTransformer() {
        return this.transformer;
    }

    public CacheJdbcPojoStoreFactory setTransformer(JdbcTypesTransformer transformer) {
        this.transformer = transformer;
        return this;
    }

    public Factory<DataSource> getDataSourceFactory() {
        return this.dataSrcFactory;
    }

    public CacheJdbcPojoStoreFactory<K, V> setDataSourceFactory(Factory<DataSource> dataSrcFactory) {
        this.dataSrcFactory = dataSrcFactory;
        return this;
    }

    public boolean isSqlEscapeAll() {
        return this.sqlEscapeAll;
    }

    public CacheJdbcPojoStoreFactory<K, V> setSqlEscapeAll(boolean sqlEscapeAll) {
        this.sqlEscapeAll = sqlEscapeAll;
        return this;
    }

    public String toString() {
        return S.toString(CacheJdbcPojoStoreFactory.class, this);
    }
}

