/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.cache.store;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.cache.Cache;
import javax.cache.integration.CacheLoaderException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cache.store.CacheStore;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteBiInClosure;
import org.apache.ignite.lang.IgniteBiTuple;
import org.apache.ignite.resources.LoggerResource;
import org.jetbrains.annotations.Nullable;

public abstract class CacheLoadOnlyStoreAdapter<K, V, I>
implements CacheStore<K, V> {
    public static final int DFLT_BATCH_SIZE = 100;
    public static final int DFLT_BATCH_QUEUE_SIZE = 100;
    public static final int DFLT_THREADS_COUNT = Runtime.getRuntime().availableProcessors();
    @LoggerResource
    private IgniteLogger log;
    private int batchSize = 100;
    private int batchQueueSize = 100;
    private int threadsCnt = DFLT_THREADS_COUNT;

    protected abstract Iterator<I> inputIterator(Object ... var1) throws CacheLoaderException;

    @Nullable
    protected abstract IgniteBiTuple<K, V> parse(I var1, Object ... var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loadCache(IgniteBiInClosure<K, V> c, Object ... args2) {
        ThreadPoolExecutor exec2 = new ThreadPoolExecutor(this.threadsCnt, this.threadsCnt, 0L, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(this.batchQueueSize), new BlockingRejectedExecutionHandler());
        Iterator<I> iter2 = this.inputIterator(args2);
        ArrayList<I> buf = new ArrayList<I>(this.batchSize);
        try {
            while (iter2.hasNext()) {
                if (Thread.currentThread().isInterrupted()) {
                    U.warn(this.log, "Working thread was interrupted while loading data.");
                    break;
                }
                buf.add(iter2.next());
                if (buf.size() != this.batchSize) continue;
                exec2.execute(new Worker(c, buf, args2));
                buf = new ArrayList(this.batchSize);
            }
            if (!buf.isEmpty()) {
                exec2.execute(new Worker(c, buf, args2));
            }
        }
        catch (RejectedExecutionException ignored) {
            assert (false) : "RejectedExecutionException was thrown while it shouldn't.";
        }
        finally {
            exec2.shutdown();
            try {
                exec2.awaitTermination(Long.MAX_VALUE, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException ignored) {
                U.warn(this.log, "Working thread was interrupted while waiting for put operations to complete.");
                Thread.currentThread().interrupt();
            }
        }
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    public int getBatchQueueSize() {
        return this.batchQueueSize;
    }

    public void setBatchQueueSize(int batchQueueSize) {
        this.batchQueueSize = batchQueueSize;
    }

    public int getThreadsCount() {
        return this.threadsCnt;
    }

    public void setThreadsCount(int threadsCnt) {
        this.threadsCnt = threadsCnt;
    }

    @Override
    public V load(K key) {
        return null;
    }

    @Override
    public Map<K, V> loadAll(Iterable<? extends K> keys) {
        return Collections.emptyMap();
    }

    @Override
    public void write(Cache.Entry<? extends K, ? extends V> entry2) {
    }

    @Override
    public void writeAll(Collection<Cache.Entry<? extends K, ? extends V>> entries) {
    }

    @Override
    public void delete(Object key) {
    }

    @Override
    public void deleteAll(Collection<?> keys) {
    }

    @Override
    public void sessionEnd(boolean commit2) {
    }

    private class BlockingRejectedExecutionHandler
    implements RejectedExecutionHandler {
        private BlockingRejectedExecutionHandler() {
        }

        @Override
        public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
            try {
                if (executor.isShutdown()) {
                    throw new RejectedExecutionException();
                }
                executor.getQueue().put(r);
            }
            catch (InterruptedException ignored) {
                U.warn(CacheLoadOnlyStoreAdapter.this.log, "Working thread was interrupted while loading data.");
                Thread.currentThread().interrupt();
            }
        }
    }

    private class Worker
    implements Runnable {
        private final IgniteBiInClosure<K, V> c;
        private final Collection<I> buf;
        private final Object[] args;

        Worker(IgniteBiInClosure<K, V> c, Collection<I> buf, Object[] args2) {
            this.c = c;
            this.buf = buf;
            this.args = args2;
        }

        @Override
        public void run() {
            for (Object rec : this.buf) {
                IgniteBiTuple entry2 = CacheLoadOnlyStoreAdapter.this.parse(rec, this.args);
                if (entry2 == null) continue;
                this.c.apply(entry2.getKey(), entry2.getValue());
            }
        }
    }
}

