/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.cache.query;

import java.util.concurrent.TimeUnit;
import javax.cache.Cache;
import org.apache.ignite.cache.query.Query;
import org.apache.ignite.internal.processors.query.QueryUtils;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.internal.A;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.jetbrains.annotations.Nullable;

public final class SqlQuery<K, V>
extends Query<Cache.Entry<K, V>> {
    private static final long serialVersionUID = 0L;
    private String type;
    private String alias;
    private String sql;
    @GridToStringInclude
    private Object[] args;
    private int timeout;
    private boolean distributedJoins;
    private boolean replicatedOnly;
    private int[] parts;

    public SqlQuery(String type, String sql2) {
        this.setType(type);
        this.setSql(sql2);
    }

    public SqlQuery(Class<?> type, String sql2) {
        this.setType(type);
        this.setSql(sql2);
    }

    public String getSql() {
        return this.sql;
    }

    public SqlQuery<K, V> setSql(String sql2) {
        A.notNull(sql2, "sql");
        this.sql = sql2;
        return this;
    }

    public Object[] getArgs() {
        return this.args;
    }

    public SqlQuery<K, V> setArgs(Object ... args2) {
        this.args = args2;
        return this;
    }

    public String getType() {
        return this.type;
    }

    public SqlQuery<K, V> setType(String type) {
        this.type = type;
        return this;
    }

    public String getAlias() {
        return this.alias;
    }

    public SqlQuery<K, V> setAlias(String alias) {
        this.alias = alias;
        return this;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public SqlQuery<K, V> setTimeout(int timeout, TimeUnit timeUnit) {
        this.timeout = QueryUtils.validateTimeout(timeout, timeUnit);
        return this;
    }

    public SqlQuery<K, V> setPageSize(int pageSize) {
        return (SqlQuery)super.setPageSize(pageSize);
    }

    public SqlQuery<K, V> setLocal(boolean loc) {
        return (SqlQuery)super.setLocal(loc);
    }

    public SqlQuery<K, V> setType(Class<?> type) {
        return this.setType(QueryUtils.typeName(type));
    }

    public SqlQuery<K, V> setDistributedJoins(boolean distributedJoins) {
        this.distributedJoins = distributedJoins;
        return this;
    }

    public boolean isDistributedJoins() {
        return this.distributedJoins;
    }

    public SqlQuery<K, V> setReplicatedOnly(boolean replicatedOnly) {
        this.replicatedOnly = replicatedOnly;
        return this;
    }

    public boolean isReplicatedOnly() {
        return this.replicatedOnly;
    }

    @Nullable
    public int[] getPartitions() {
        return this.parts;
    }

    public SqlQuery setPartitions(int ... parts) {
        this.parts = this.prepare(parts);
        return this;
    }

    @Override
    public String toString() {
        return S.toString(SqlQuery.class, this);
    }
}

