/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.cache.query;

import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.ignite.cache.query.Query;
import org.apache.ignite.internal.processors.query.QueryUtils;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.internal.A;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.jetbrains.annotations.Nullable;

public class SqlFieldsQuery
extends Query<List<?>> {
    private static final long serialVersionUID = 0L;
    private String sql;
    @GridToStringInclude
    private Object[] args;
    private boolean collocated;
    private int timeout;
    private boolean enforceJoinOrder;
    private boolean distributedJoins;
    private boolean replicatedOnly;
    private boolean lazy;
    private int[] parts;
    private String schema;

    public SqlFieldsQuery(SqlFieldsQuery qry) {
        this.sql = qry.sql;
        this.args = qry.args;
        this.collocated = qry.collocated;
        this.timeout = qry.timeout;
        this.enforceJoinOrder = qry.enforceJoinOrder;
        this.distributedJoins = qry.distributedJoins;
        this.replicatedOnly = qry.replicatedOnly;
        this.lazy = qry.lazy;
        this.parts = qry.parts;
        this.schema = qry.schema;
    }

    public SqlFieldsQuery(String sql2) {
        this.setSql(sql2);
    }

    public SqlFieldsQuery(String sql2, boolean collocated) {
        this.sql = sql2;
        this.collocated = collocated;
    }

    public String getSql() {
        return this.sql;
    }

    public SqlFieldsQuery setSql(String sql2) {
        A.notNull(sql2, "sql");
        this.sql = sql2;
        return this;
    }

    public Object[] getArgs() {
        return this.args;
    }

    public SqlFieldsQuery setArgs(Object ... args2) {
        this.args = args2;
        return this;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public SqlFieldsQuery setTimeout(int timeout, TimeUnit timeUnit) {
        this.timeout = QueryUtils.validateTimeout(timeout, timeUnit);
        return this;
    }

    public boolean isCollocated() {
        return this.collocated;
    }

    public SqlFieldsQuery setCollocated(boolean collocated) {
        this.collocated = collocated;
        return this;
    }

    public boolean isEnforceJoinOrder() {
        return this.enforceJoinOrder;
    }

    public SqlFieldsQuery setEnforceJoinOrder(boolean enforceJoinOrder) {
        this.enforceJoinOrder = enforceJoinOrder;
        return this;
    }

    public SqlFieldsQuery setDistributedJoins(boolean distributedJoins) {
        this.distributedJoins = distributedJoins;
        return this;
    }

    public boolean isDistributedJoins() {
        return this.distributedJoins;
    }

    public SqlFieldsQuery setPageSize(int pageSize) {
        return (SqlFieldsQuery)super.setPageSize(pageSize);
    }

    public SqlFieldsQuery setLocal(boolean loc) {
        return (SqlFieldsQuery)super.setLocal(loc);
    }

    public SqlFieldsQuery setReplicatedOnly(boolean replicatedOnly) {
        this.replicatedOnly = replicatedOnly;
        return this;
    }

    public boolean isReplicatedOnly() {
        return this.replicatedOnly;
    }

    public SqlFieldsQuery setLazy(boolean lazy) {
        this.lazy = lazy;
        return this;
    }

    public boolean isLazy() {
        return this.lazy;
    }

    @Nullable
    public int[] getPartitions() {
        return this.parts;
    }

    public SqlFieldsQuery setPartitions(int ... parts) {
        this.parts = this.prepare(parts);
        return this;
    }

    @Nullable
    public String getSchema() {
        return this.schema;
    }

    public SqlFieldsQuery setSchema(@Nullable String schema) {
        this.schema = schema;
        return this;
    }

    public SqlFieldsQuery copy() {
        return new SqlFieldsQuery(this);
    }

    @Override
    public String toString() {
        return S.toString(SqlFieldsQuery.class, this);
    }
}

