/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.cache.eviction.lru;

import java.util.Collection;
import java.util.Collections;
import org.apache.ignite.cache.eviction.AbstractEvictionPolicy;
import org.apache.ignite.cache.eviction.EvictableEntry;
import org.apache.ignite.cache.eviction.lru.LruEvictionPolicyMBean;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.mxbean.IgniteMBeanAware;
import org.jsr166.ConcurrentLinkedDeque8;

public class LruEvictionPolicy<K, V>
extends AbstractEvictionPolicy<K, V>
implements IgniteMBeanAware {
    private static final long serialVersionUID = 0L;
    private final ConcurrentLinkedDeque8<EvictableEntry<K, V>> queue = new ConcurrentLinkedDeque8();

    public LruEvictionPolicy() {
    }

    public LruEvictionPolicy(int max2) {
        this.setMaxSize(max2);
    }

    @Override
    public int getCurrentSize() {
        return this.queue.sizex();
    }

    @Override
    public LruEvictionPolicy<K, V> setMaxMemorySize(long maxMemSize) {
        super.setMaxMemorySize(maxMemSize);
        return this;
    }

    @Override
    public LruEvictionPolicy<K, V> setMaxSize(int max2) {
        super.setMaxSize(max2);
        return this;
    }

    @Override
    public LruEvictionPolicy<K, V> setBatchSize(int batchSize) {
        super.setBatchSize(batchSize);
        return this;
    }

    public Collection<EvictableEntry<K, V>> queue() {
        return Collections.unmodifiableCollection(this.queue);
    }

    @Override
    protected boolean removeMeta(Object meta) {
        return this.queue.unlinkx((ConcurrentLinkedDeque8.Node)meta);
    }

    @Override
    protected boolean touch(EvictableEntry<K, V> entry2) {
        ConcurrentLinkedDeque8.Node<EvictableEntry<K, V>> newNode;
        ConcurrentLinkedDeque8.Node<EvictableEntry<K, V>> node = (ConcurrentLinkedDeque8.Node<EvictableEntry<K, V>>)entry2.meta();
        if (node == null) {
            do {
                if (entry2.putMetaIfAbsent(node = this.queue.offerLastx(entry2)) != null) {
                    this.removeMeta(node);
                    return false;
                }
                if (node.item() == null) continue;
                if (!entry2.isCached()) {
                    this.removeMeta(node);
                    return false;
                }
                this.memSize.add(entry2.size());
                return true;
            } while (entry2.removeMeta(node));
            return false;
        }
        if (this.removeMeta(node) && !entry2.replaceMeta(node, newNode = this.queue.offerLastx(entry2))) {
            this.removeMeta(newNode);
        }
        return false;
    }

    @Override
    protected int shrink0() {
        EvictableEntry<K, V> entry2 = this.queue.poll();
        if (entry2 == null) {
            return -1;
        }
        int size2 = 0;
        ConcurrentLinkedDeque8.Node meta = (ConcurrentLinkedDeque8.Node)entry2.removeMeta();
        if (meta != null) {
            size2 = entry2.size();
            this.memSize.add(-size2);
            if (!entry2.evict()) {
                this.touch(entry2);
            }
        }
        return size2;
    }

    @Override
    public Object getMBean() {
        return new LruEvictionPolicyMBeanImpl();
    }

    public String toString() {
        return S.toString(LruEvictionPolicy.class, this, "size", this.getCurrentSize());
    }

    private class LruEvictionPolicyMBeanImpl
    implements LruEvictionPolicyMBean {
        private LruEvictionPolicyMBeanImpl() {
        }

        @Override
        public long getCurrentMemorySize() {
            return LruEvictionPolicy.this.getCurrentMemorySize();
        }

        @Override
        public int getCurrentSize() {
            return LruEvictionPolicy.this.getCurrentSize();
        }

        @Override
        public int getMaxSize() {
            return LruEvictionPolicy.this.getMaxSize();
        }

        @Override
        public void setMaxSize(int max2) {
            LruEvictionPolicy.this.setMaxSize(max2);
        }

        @Override
        public int getBatchSize() {
            return LruEvictionPolicy.this.getBatchSize();
        }

        @Override
        public void setBatchSize(int batchSize) {
            LruEvictionPolicy.this.setBatchSize(batchSize);
        }

        @Override
        public long getMaxMemorySize() {
            return LruEvictionPolicy.this.getMaxMemorySize();
        }

        @Override
        public void setMaxMemorySize(long maxMemSize) {
            LruEvictionPolicy.this.setMaxMemorySize(maxMemSize);
        }
    }
}

