/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.cache.eviction.igfs;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.LongAdder;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.cache.eviction.EvictableEntry;
import org.apache.ignite.cache.eviction.EvictionPolicy;
import org.apache.ignite.cache.eviction.igfs.IgfsPerBlockLruEvictionPolicyMXBean;
import org.apache.ignite.igfs.IgfsPath;
import org.apache.ignite.internal.processors.cache.CacheEvictableEntryImpl;
import org.apache.ignite.internal.processors.igfs.IgfsBlockKey;
import org.apache.ignite.mxbean.IgniteMBeanAware;
import org.jetbrains.annotations.Nullable;
import org.jsr166.ConcurrentLinkedDeque8;

public class IgfsPerBlockLruEvictionPolicy
implements EvictionPolicy<IgfsBlockKey, byte[]>,
IgniteMBeanAware,
Externalizable {
    private static final long serialVersionUID = 0L;
    private volatile long maxSize;
    private volatile int maxBlocks;
    private volatile Collection<String> excludePaths;
    private volatile Collection<Pattern> excludePatterns;
    private final AtomicBoolean excludeRecompile = new AtomicBoolean(true);
    private final ConcurrentLinkedDeque8<EvictableEntry<IgfsBlockKey, byte[]>> queue = new ConcurrentLinkedDeque8();
    private final LongAdder curSize = new LongAdder();

    public IgfsPerBlockLruEvictionPolicy() {
    }

    public IgfsPerBlockLruEvictionPolicy(long maxSize, int maxBlocks) {
        this(maxSize, maxBlocks, null);
    }

    public IgfsPerBlockLruEvictionPolicy(long maxSize, int maxBlocks, @Nullable Collection<String> excludePaths) {
        this.maxSize = maxSize;
        this.maxBlocks = maxBlocks;
        this.excludePaths = excludePaths;
    }

    @Override
    public void onEntryAccessed(boolean rmv, EvictableEntry<IgfsBlockKey, byte[]> entry2) {
        if (!rmv) {
            if (!entry2.isCached()) {
                return;
            }
            if (this.touch(entry2)) {
                this.shrink();
            }
        } else {
            MetaEntry meta = (MetaEntry)entry2.removeMeta();
            if (meta != null && this.queue.unlinkx(meta.node())) {
                this.changeSize(-meta.size());
            }
        }
    }

    private boolean touch(EvictableEntry<IgfsBlockKey, byte[]> entry2) {
        byte[] val = this.peek(entry2);
        int blockSize = val != null ? val.length : 0;
        MetaEntry meta = (MetaEntry)entry2.meta();
        if (meta == null) {
            ConcurrentLinkedDeque8.Node<EvictableEntry<IgfsBlockKey, byte[]>> node;
            do {
                if (entry2.putMetaIfAbsent(meta = new MetaEntry(node = this.queue.offerLastx(entry2), blockSize)) != null) {
                    this.queue.unlinkx(node);
                    return false;
                }
                if (node.item() == null) continue;
                if (!entry2.isCached()) {
                    this.queue.unlinkx(node);
                    return false;
                }
                this.changeSize(blockSize);
                return true;
            } while (entry2.removeMeta(node));
            return false;
        }
        int oldBlockSize = meta.size();
        ConcurrentLinkedDeque8.Node node = meta.node();
        if (this.queue.unlinkx(node)) {
            ConcurrentLinkedDeque8.Node<EvictableEntry<IgfsBlockKey, byte[]>> newNode = this.queue.offerLastx(entry2);
            int delta = blockSize - oldBlockSize;
            if (!entry2.replaceMeta(meta, new MetaEntry(newNode, blockSize)) && this.queue.unlinkx(newNode)) {
                delta -= blockSize;
            }
            if (delta != 0) {
                this.changeSize(delta);
                if (delta > 0) {
                    return true;
                }
            }
        }
        return false;
    }

    @Nullable
    private byte[] peek(EvictableEntry<IgfsBlockKey, byte[]> entry2) {
        return (byte[])((CacheEvictableEntryImpl)entry2).peek();
    }

    private void shrink() {
        EvictableEntry<IgfsBlockKey, byte[]> entry2;
        long maxSize = this.maxSize;
        int maxBlocks = this.maxBlocks;
        int cnt = this.queue.sizex();
        for (int i = 0; i < cnt && (maxBlocks > 0 && this.queue.sizex() > maxBlocks || maxSize > 0L && this.curSize.longValue() > maxSize) && (entry2 = this.queue.poll()) != null; ++i) {
            byte[] val = this.peek(entry2);
            if (val != null) {
                this.changeSize(-val.length);
            }
            if (entry2.evict()) continue;
            entry2.removeMeta();
            this.touch(entry2);
        }
    }

    private void changeSize(int delta) {
        if (delta != 0) {
            this.curSize.add(delta);
        }
    }

    public long getMaxSize() {
        return this.maxSize;
    }

    public IgfsPerBlockLruEvictionPolicy setMaxSize(long maxSize) {
        this.maxSize = maxSize;
        return this;
    }

    public int getMaxBlocks() {
        return this.maxBlocks;
    }

    public IgfsPerBlockLruEvictionPolicy setMaxBlocks(int maxBlocks) {
        this.maxBlocks = maxBlocks;
        return this;
    }

    public Collection<String> getExcludePaths() {
        return Collections.unmodifiableCollection(this.excludePaths);
    }

    public IgfsPerBlockLruEvictionPolicy setExcludePaths(@Nullable Collection<String> excludePaths) {
        this.excludePaths = excludePaths;
        this.excludeRecompile.set(true);
        return this;
    }

    public long getCurrentSize() {
        return this.curSize.longValue();
    }

    public int getCurrentBlocks() {
        return this.queue.size();
    }

    @Override
    public Object getMBean() {
        return new IgfsPerBlockLruEvictionPolicyMXBeanImpl();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeLong(this.maxSize);
        out.writeInt(this.maxBlocks);
        out.writeObject(this.excludePaths);
        out.writeObject(this.excludePatterns);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.maxSize = in.readLong();
        this.maxBlocks = in.readInt();
        this.excludePaths = (Collection)in.readObject();
        this.excludePatterns = (Collection)in.readObject();
    }

    public boolean exclude(IgfsPath path2) throws IgniteCheckedException {
        Collection<Pattern> excludePatterns0;
        assert (path2 != null);
        if (this.excludeRecompile.compareAndSet(true, false)) {
            Collection<String> excludePaths0 = this.excludePaths;
            if (excludePaths0 != null) {
                excludePatterns0 = new HashSet<Pattern>(excludePaths0.size(), 1.0f);
                for (String excludePath : excludePaths0) {
                    try {
                        excludePatterns0.add(Pattern.compile(excludePath));
                    }
                    catch (PatternSyntaxException ignore) {
                        throw new IgniteCheckedException("Invalid regex pattern: " + excludePath);
                    }
                }
                this.excludePatterns = excludePatterns0;
            } else {
                this.excludePatterns = null;
                excludePatterns0 = null;
            }
        } else {
            excludePatterns0 = this.excludePatterns;
        }
        if (excludePatterns0 != null) {
            String pathStr = path2.toString();
            for (Pattern pattern : excludePatterns0) {
                if (!pattern.matcher(pathStr).matches()) continue;
                return true;
            }
        }
        return false;
    }

    private class IgfsPerBlockLruEvictionPolicyMXBeanImpl
    implements IgfsPerBlockLruEvictionPolicyMXBean {
        private IgfsPerBlockLruEvictionPolicyMXBeanImpl() {
        }

        @Override
        public long getMaxSize() {
            return IgfsPerBlockLruEvictionPolicy.this.getMaxSize();
        }

        @Override
        public void setMaxSize(long maxSize) {
            IgfsPerBlockLruEvictionPolicy.this.setMaxSize(maxSize);
        }

        @Override
        public int getMaxBlocks() {
            return IgfsPerBlockLruEvictionPolicy.this.getMaxBlocks();
        }

        @Override
        public void setMaxBlocks(int maxBlocks) {
            IgfsPerBlockLruEvictionPolicy.this.setMaxBlocks(maxBlocks);
        }

        @Override
        @Nullable
        public Collection<String> getExcludePaths() {
            return IgfsPerBlockLruEvictionPolicy.this.getExcludePaths();
        }

        @Override
        public void setExcludePaths(@Nullable Collection<String> excludePaths) {
            IgfsPerBlockLruEvictionPolicy.this.setExcludePaths(excludePaths);
        }

        @Override
        public long getCurrentSize() {
            return IgfsPerBlockLruEvictionPolicy.this.getCurrentSize();
        }

        @Override
        public int getCurrentBlocks() {
            return IgfsPerBlockLruEvictionPolicy.this.getCurrentBlocks();
        }
    }

    private static class MetaEntry {
        private final ConcurrentLinkedDeque8.Node<EvictableEntry<IgfsBlockKey, byte[]>> node;
        private final int size;

        private MetaEntry(ConcurrentLinkedDeque8.Node<EvictableEntry<IgfsBlockKey, byte[]>> node, int size2) {
            assert (node != null);
            assert (size2 >= 0);
            this.node = node;
            this.size = size2;
        }

        private ConcurrentLinkedDeque8.Node<EvictableEntry<IgfsBlockKey, byte[]>> node() {
            return this.node;
        }

        private int size() {
            return this.size;
        }
    }
}

