/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.cache.eviction.fifo;

import java.util.Collection;
import java.util.Collections;
import org.apache.ignite.cache.eviction.AbstractEvictionPolicy;
import org.apache.ignite.cache.eviction.EvictableEntry;
import org.apache.ignite.cache.eviction.fifo.FifoEvictionPolicyMBean;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.mxbean.IgniteMBeanAware;
import org.jsr166.ConcurrentLinkedDeque8;

public class FifoEvictionPolicy<K, V>
extends AbstractEvictionPolicy<K, V>
implements IgniteMBeanAware {
    private static final long serialVersionUID = 0L;
    private final ConcurrentLinkedDeque8<EvictableEntry<K, V>> queue = new ConcurrentLinkedDeque8();

    public FifoEvictionPolicy() {
    }

    public FifoEvictionPolicy(int max2) {
        this.setMaxSize(max2);
    }

    public FifoEvictionPolicy(int max2, int batchSize) {
        this.setMaxSize(max2);
        this.setBatchSize(batchSize);
    }

    @Override
    public int getCurrentSize() {
        return this.queue.sizex();
    }

    @Override
    public FifoEvictionPolicy<K, V> setMaxMemorySize(long maxMemSize) {
        super.setMaxMemorySize(maxMemSize);
        return this;
    }

    @Override
    public FifoEvictionPolicy<K, V> setMaxSize(int max2) {
        super.setMaxSize(max2);
        return this;
    }

    @Override
    public FifoEvictionPolicy<K, V> setBatchSize(int batchSize) {
        super.setBatchSize(batchSize);
        return this;
    }

    public Collection<EvictableEntry<K, V>> queue() {
        return Collections.unmodifiableCollection(this.queue);
    }

    @Override
    protected boolean removeMeta(Object meta) {
        return this.queue.unlinkx((ConcurrentLinkedDeque8.Node)meta);
    }

    @Override
    protected boolean touch(EvictableEntry<K, V> entry2) {
        ConcurrentLinkedDeque8.Node<EvictableEntry<K, V>> node = (ConcurrentLinkedDeque8.Node<EvictableEntry<K, V>>)entry2.meta();
        if (node == null) {
            do {
                if (entry2.putMetaIfAbsent(node = this.queue.offerLastx(entry2)) != null) {
                    this.queue.unlinkx(node);
                    return false;
                }
                if (node.item() == null) continue;
                if (!entry2.isCached()) {
                    this.queue.unlinkx(node);
                    return false;
                }
                this.memSize.add(entry2.size());
                return true;
            } while (entry2.removeMeta(node));
            return false;
        }
        return false;
    }

    @Override
    protected int shrink0() {
        EvictableEntry<K, V> entry2 = this.queue.poll();
        if (entry2 == null) {
            return -1;
        }
        int size2 = 0;
        ConcurrentLinkedDeque8.Node meta = (ConcurrentLinkedDeque8.Node)entry2.removeMeta();
        if (meta != null) {
            size2 = entry2.size();
            this.memSize.add(-size2);
            if (!entry2.evict()) {
                this.touch(entry2);
            }
        }
        return size2;
    }

    @Override
    public Object getMBean() {
        return new FifoEvictionPolicyMBeanImpl();
    }

    public String toString() {
        return S.toString(FifoEvictionPolicy.class, this);
    }

    private class FifoEvictionPolicyMBeanImpl
    implements FifoEvictionPolicyMBean {
        private FifoEvictionPolicyMBeanImpl() {
        }

        @Override
        public long getCurrentMemorySize() {
            return FifoEvictionPolicy.this.getCurrentMemorySize();
        }

        @Override
        public int getCurrentSize() {
            return FifoEvictionPolicy.this.getCurrentSize();
        }

        @Override
        public int getMaxSize() {
            return FifoEvictionPolicy.this.getMaxSize();
        }

        @Override
        public void setMaxSize(int max2) {
            FifoEvictionPolicy.this.setMaxSize(max2);
        }

        @Override
        public int getBatchSize() {
            return FifoEvictionPolicy.this.getBatchSize();
        }

        @Override
        public void setBatchSize(int batchSize) {
            FifoEvictionPolicy.this.setBatchSize(batchSize);
        }

        @Override
        public long getMaxMemorySize() {
            return FifoEvictionPolicy.this.getMaxMemorySize();
        }

        @Override
        public void setMaxMemorySize(long maxMemSize) {
            FifoEvictionPolicy.this.setMaxMemorySize(maxMemSize);
        }
    }
}

