/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.cache.eviction;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.concurrent.atomic.LongAdder;
import org.apache.ignite.cache.eviction.EvictableEntry;
import org.apache.ignite.cache.eviction.EvictionPolicy;
import org.apache.ignite.internal.util.typedef.internal.A;

public abstract class AbstractEvictionPolicy<K, V>
implements EvictionPolicy<K, V>,
Externalizable {
    private static final long serialVersionUID = 4358725333474509598L;
    private volatile long maxMemSize;
    private volatile int max;
    private volatile int batchSize = 1;
    protected final LongAdder memSize = new LongAdder();

    protected void shrink() {
        int startSize;
        int max2;
        long startMemSize;
        long maxMem = this.maxMemSize;
        if (maxMem > 0L && (startMemSize = this.memSize.longValue()) >= maxMem) {
            int size2;
            for (long i = maxMem; i < startMemSize && this.memSize.longValue() > maxMem && (size2 = this.shrink0()) != -1; i += (long)size2) {
            }
        }
        if ((max2 = this.max) > 0 && (startSize = this.getCurrentSize()) >= max2 + (maxMem > 0L ? 1 : this.batchSize)) {
            for (int i = max2; i < startSize && this.getCurrentSize() > max2 && this.shrink0() != -1; ++i) {
            }
        }
    }

    @Override
    public void onEntryAccessed(boolean rmv, EvictableEntry<K, V> entry2) {
        if (!rmv) {
            if (!entry2.isCached()) {
                return;
            }
            if (this.touch(entry2)) {
                this.shrink();
            }
        } else {
            Object node = entry2.removeMeta();
            if (node != null) {
                this.removeMeta(node);
                this.memSize.add(-entry2.size());
            }
        }
    }

    protected abstract int getCurrentSize();

    protected abstract int shrink0();

    protected abstract boolean removeMeta(Object var1);

    protected abstract boolean touch(EvictableEntry<K, V> var1);

    public AbstractEvictionPolicy<K, V> setMaxMemorySize(long maxMemSize) {
        A.ensure(maxMemSize >= 0L, "maxMemSize >= 0");
        this.maxMemSize = maxMemSize;
        return this;
    }

    public long getMaxMemorySize() {
        return this.maxMemSize;
    }

    public long getCurrentMemorySize() {
        return this.memSize.longValue();
    }

    public AbstractEvictionPolicy<K, V> setMaxSize(int max2) {
        A.ensure(max2 >= 0, "max >= 0");
        this.max = max2;
        return this;
    }

    public int getMaxSize() {
        return this.max;
    }

    public AbstractEvictionPolicy<K, V> setBatchSize(int batchSize) {
        A.ensure(batchSize > 0, "batchSize > 0");
        this.batchSize = batchSize;
        return this;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.max);
        out.writeInt(this.batchSize);
        out.writeLong(this.maxMemSize);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.max = in.readInt();
        this.batchSize = in.readInt();
        this.maxMemSize = in.readLong();
    }
}

