/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.cache.affinity.rendezvous;

import java.util.List;
import java.util.Objects;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.internal.util.typedef.internal.A;
import org.apache.ignite.lang.IgniteBiPredicate;

public class ClusterNodeAttributeAffinityBackupFilter
implements IgniteBiPredicate<ClusterNode, List<ClusterNode>> {
    private static final long serialVersionUID = 1L;
    private final String[] attributeNames;

    ClusterNodeAttributeAffinityBackupFilter(String ... attributeNames) {
        A.ensure(attributeNames.length > 0, "attributeNames.length > 0");
        this.attributeNames = attributeNames;
    }

    @Override
    public boolean apply(ClusterNode candidate, List<ClusterNode> previouslySelected) {
        for (ClusterNode node : previouslySelected) {
            boolean match = true;
            for (String attribute : this.attributeNames) {
                if (Objects.equals(candidate.attribute(attribute), node.attribute(attribute))) continue;
                match = false;
                break;
            }
            if (!match) continue;
            return false;
        }
        return true;
    }
}

