/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collection;
import java.util.concurrent.ExecutorService;
import org.apache.ignite.DataRegionMetrics;
import org.apache.ignite.DataRegionMetricsAdapter;
import org.apache.ignite.DataStorageMetrics;
import org.apache.ignite.DataStorageMetricsAdapter;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteAtomicLong;
import org.apache.ignite.IgniteAtomicReference;
import org.apache.ignite.IgniteAtomicSequence;
import org.apache.ignite.IgniteAtomicStamped;
import org.apache.ignite.IgniteBinary;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteCluster;
import org.apache.ignite.IgniteCompute;
import org.apache.ignite.IgniteCountDownLatch;
import org.apache.ignite.IgniteDataStreamer;
import org.apache.ignite.IgniteEvents;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteFileSystem;
import org.apache.ignite.IgniteLock;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.IgniteMessaging;
import org.apache.ignite.IgniteQueue;
import org.apache.ignite.IgniteScheduler;
import org.apache.ignite.IgniteSemaphore;
import org.apache.ignite.IgniteServices;
import org.apache.ignite.IgniteSet;
import org.apache.ignite.IgniteSpring;
import org.apache.ignite.IgniteTransactions;
import org.apache.ignite.MemoryMetrics;
import org.apache.ignite.PersistenceMetrics;
import org.apache.ignite.cache.affinity.Affinity;
import org.apache.ignite.cluster.ClusterGroup;
import org.apache.ignite.configuration.AtomicConfiguration;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.CollectionConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.configuration.NearCacheConfiguration;
import org.apache.ignite.internal.util.typedef.G;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.lang.IgniteProductVersion;
import org.apache.ignite.plugin.IgnitePlugin;
import org.apache.ignite.plugin.PluginNotFoundException;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.SmartInitializingSingleton;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class IgniteSpringBean
implements Ignite,
DisposableBean,
SmartInitializingSingleton,
ApplicationContextAware,
Externalizable {
    private static final long serialVersionUID = 0L;
    private Ignite g;
    private IgniteConfiguration cfg;
    private ApplicationContext appCtx;

    @Override
    public IgniteConfiguration configuration() {
        return this.cfg;
    }

    public IgniteConfiguration getConfiguration() {
        return this.cfg;
    }

    public void setConfiguration(IgniteConfiguration cfg) {
        this.cfg = cfg;
    }

    public ApplicationContext getApplicationContext() throws BeansException {
        return this.appCtx;
    }

    @Override
    public void setApplicationContext(ApplicationContext ctx) throws BeansException {
        this.appCtx = ctx;
    }

    @Override
    public void destroy() throws Exception {
        if (this.g != null) {
            G.stop(this.g.name(), false);
        }
    }

    @Override
    public void afterSingletonsInstantiated() {
        if (this.cfg == null) {
            this.cfg = new IgniteConfiguration();
        }
        try {
            this.g = IgniteSpring.start(this.cfg, this.appCtx);
        }
        catch (IgniteCheckedException e) {
            throw new IgniteException("Failed to start IgniteSpringBean", e);
        }
    }

    @Override
    public IgniteLogger log() {
        this.checkIgnite();
        return this.cfg.getGridLogger();
    }

    @Override
    public IgniteProductVersion version() {
        this.checkIgnite();
        return this.g.version();
    }

    @Override
    public IgniteCompute compute() {
        this.checkIgnite();
        return this.g.compute();
    }

    @Override
    public IgniteServices services() {
        this.checkIgnite();
        return this.g.services();
    }

    @Override
    public IgniteMessaging message() {
        this.checkIgnite();
        return this.g.message();
    }

    @Override
    public IgniteEvents events() {
        this.checkIgnite();
        return this.g.events();
    }

    @Override
    public ExecutorService executorService() {
        this.checkIgnite();
        return this.g.executorService();
    }

    @Override
    public IgniteCluster cluster() {
        this.checkIgnite();
        return this.g.cluster();
    }

    @Override
    public IgniteCompute compute(ClusterGroup grp) {
        this.checkIgnite();
        return this.g.compute(grp);
    }

    @Override
    public IgniteMessaging message(ClusterGroup prj) {
        this.checkIgnite();
        return this.g.message(prj);
    }

    @Override
    public IgniteEvents events(ClusterGroup grp) {
        this.checkIgnite();
        return this.g.events(grp);
    }

    @Override
    public IgniteServices services(ClusterGroup grp) {
        this.checkIgnite();
        return this.g.services(grp);
    }

    @Override
    public ExecutorService executorService(ClusterGroup grp) {
        this.checkIgnite();
        return this.g.executorService(grp);
    }

    @Override
    public IgniteScheduler scheduler() {
        this.checkIgnite();
        return this.g.scheduler();
    }

    @Override
    public String name() {
        this.checkIgnite();
        return this.g.name();
    }

    @Override
    public void resetLostPartitions(Collection<String> cacheNames) {
        this.checkIgnite();
        this.g.resetLostPartitions(cacheNames);
    }

    @Override
    public Collection<DataRegionMetrics> dataRegionMetrics() {
        this.checkIgnite();
        return this.g.dataRegionMetrics();
    }

    @Override
    @Nullable
    public DataRegionMetrics dataRegionMetrics(String memPlcName) {
        this.checkIgnite();
        return this.g.dataRegionMetrics(memPlcName);
    }

    @Override
    public DataStorageMetrics dataStorageMetrics() {
        this.checkIgnite();
        return this.g.dataStorageMetrics();
    }

    @Override
    public Collection<MemoryMetrics> memoryMetrics() {
        return DataRegionMetricsAdapter.collectionOf(this.dataRegionMetrics());
    }

    @Override
    @Nullable
    public MemoryMetrics memoryMetrics(String memPlcName) {
        return DataRegionMetricsAdapter.valueOf(this.dataRegionMetrics(memPlcName));
    }

    @Override
    public PersistenceMetrics persistentStoreMetrics() {
        return DataStorageMetricsAdapter.valueOf(this.dataStorageMetrics());
    }

    @Override
    public <K, V> IgniteCache<K, V> cache(@Nullable String name) {
        this.checkIgnite();
        return this.g.cache(name);
    }

    @Override
    public Collection<String> cacheNames() {
        this.checkIgnite();
        return this.g.cacheNames();
    }

    @Override
    public <K, V> IgniteCache<K, V> createCache(CacheConfiguration<K, V> cacheCfg) {
        this.checkIgnite();
        return this.g.createCache(cacheCfg);
    }

    @Override
    public <K, V> IgniteCache<K, V> getOrCreateCache(CacheConfiguration<K, V> cacheCfg) {
        this.checkIgnite();
        return this.g.getOrCreateCache(cacheCfg);
    }

    @Override
    public <K, V> IgniteCache<K, V> createCache(CacheConfiguration<K, V> cacheCfg, NearCacheConfiguration<K, V> nearCfg) {
        this.checkIgnite();
        return this.g.createCache(cacheCfg, nearCfg);
    }

    @Override
    public Collection<IgniteCache> createCaches(Collection<CacheConfiguration> cacheCfgs) {
        this.checkIgnite();
        return this.g.createCaches(cacheCfgs);
    }

    @Override
    public <K, V> IgniteCache<K, V> getOrCreateCache(CacheConfiguration<K, V> cacheCfg, NearCacheConfiguration<K, V> nearCfg) {
        this.checkIgnite();
        return this.g.getOrCreateCache(cacheCfg, nearCfg);
    }

    @Override
    public <K, V> IgniteCache<K, V> createNearCache(String cacheName, NearCacheConfiguration<K, V> nearCfg) {
        this.checkIgnite();
        return this.g.createNearCache(cacheName, nearCfg);
    }

    @Override
    public <K, V> IgniteCache<K, V> getOrCreateNearCache(@Nullable String cacheName, NearCacheConfiguration<K, V> nearCfg) {
        this.checkIgnite();
        return this.g.getOrCreateNearCache(cacheName, nearCfg);
    }

    @Override
    public <K, V> IgniteCache<K, V> getOrCreateCache(String cacheName) {
        this.checkIgnite();
        return this.g.getOrCreateCache(cacheName);
    }

    @Override
    public Collection<IgniteCache> getOrCreateCaches(Collection<CacheConfiguration> cacheCfgs) {
        this.checkIgnite();
        return this.g.getOrCreateCaches(cacheCfgs);
    }

    @Override
    public <K, V> IgniteCache<K, V> createCache(String cacheName) {
        this.checkIgnite();
        return this.g.createCache(cacheName);
    }

    @Override
    public <K, V> void addCacheConfiguration(CacheConfiguration<K, V> cacheCfg) {
        this.checkIgnite();
        this.g.addCacheConfiguration(cacheCfg);
    }

    @Override
    public void destroyCache(String cacheName) {
        this.checkIgnite();
        this.g.destroyCache(cacheName);
    }

    @Override
    public void destroyCaches(Collection<String> cacheNames) {
        this.checkIgnite();
        this.g.destroyCaches(cacheNames);
    }

    @Override
    public IgniteTransactions transactions() {
        this.checkIgnite();
        return this.g.transactions();
    }

    @Override
    public <K, V> IgniteDataStreamer<K, V> dataStreamer(@Nullable String cacheName) {
        this.checkIgnite();
        return this.g.dataStreamer(cacheName);
    }

    @Override
    public IgniteFileSystem fileSystem(String name) {
        this.checkIgnite();
        return this.g.fileSystem(name);
    }

    @Override
    public Collection<IgniteFileSystem> fileSystems() {
        this.checkIgnite();
        return this.g.fileSystems();
    }

    @Override
    public <T extends IgnitePlugin> T plugin(String name) throws PluginNotFoundException {
        this.checkIgnite();
        return this.g.plugin(name);
    }

    @Override
    public IgniteBinary binary() {
        this.checkIgnite();
        return this.g.binary();
    }

    @Override
    public void close() throws IgniteException {
        this.g.close();
    }

    @Override
    @Nullable
    public IgniteAtomicSequence atomicSequence(String name, long initVal, boolean create) {
        this.checkIgnite();
        return this.g.atomicSequence(name, initVal, create);
    }

    @Override
    public IgniteAtomicSequence atomicSequence(String name, AtomicConfiguration cfg, long initVal, boolean create) throws IgniteException {
        this.checkIgnite();
        return this.g.atomicSequence(name, cfg, initVal, create);
    }

    @Override
    @Nullable
    public IgniteAtomicLong atomicLong(String name, long initVal, boolean create) {
        this.checkIgnite();
        return this.g.atomicLong(name, initVal, create);
    }

    @Override
    public IgniteAtomicLong atomicLong(String name, AtomicConfiguration cfg, long initVal, boolean create) throws IgniteException {
        this.checkIgnite();
        return this.g.atomicLong(name, cfg, initVal, create);
    }

    @Override
    @Nullable
    public <T> IgniteAtomicReference<T> atomicReference(String name, @Nullable T initVal, boolean create) {
        this.checkIgnite();
        return this.g.atomicReference(name, initVal, create);
    }

    @Override
    public <T> IgniteAtomicReference<T> atomicReference(String name, AtomicConfiguration cfg, @Nullable T initVal, boolean create) throws IgniteException {
        this.checkIgnite();
        return this.g.atomicReference(name, cfg, initVal, create);
    }

    @Override
    @Nullable
    public <T, S> IgniteAtomicStamped<T, S> atomicStamped(String name, @Nullable T initVal, @Nullable S initStamp, boolean create) {
        this.checkIgnite();
        return this.g.atomicStamped(name, initVal, initStamp, create);
    }

    @Override
    public <T, S> IgniteAtomicStamped<T, S> atomicStamped(String name, AtomicConfiguration cfg, @Nullable T initVal, @Nullable S initStamp, boolean create) throws IgniteException {
        this.checkIgnite();
        return this.g.atomicStamped(name, cfg, initVal, initStamp, create);
    }

    @Override
    @Nullable
    public IgniteCountDownLatch countDownLatch(String name, int cnt, boolean autoDel, boolean create) {
        this.checkIgnite();
        return this.g.countDownLatch(name, cnt, autoDel, create);
    }

    @Override
    @Nullable
    public IgniteSemaphore semaphore(String name, int cnt, boolean failoverSafe, boolean create) {
        this.checkIgnite();
        return this.g.semaphore(name, cnt, failoverSafe, create);
    }

    @Override
    @Nullable
    public IgniteLock reentrantLock(String name, boolean failoverSafe, boolean fair, boolean create) {
        this.checkIgnite();
        return this.g.reentrantLock(name, failoverSafe, fair, create);
    }

    @Override
    @Nullable
    public <T> IgniteQueue<T> queue(String name, int cap, CollectionConfiguration cfg) {
        this.checkIgnite();
        return this.g.queue(name, cap, cfg);
    }

    @Override
    @Nullable
    public <T> IgniteSet<T> set(String name, CollectionConfiguration cfg) {
        this.checkIgnite();
        return this.g.set(name, cfg);
    }

    @Override
    public <K> Affinity<K> affinity(String cacheName) {
        return this.g.affinity(cacheName);
    }

    @Override
    public boolean active() {
        this.checkIgnite();
        return this.g.active();
    }

    @Override
    public void active(boolean active) {
        this.checkIgnite();
        this.g.active(active);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.g);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.g = (Ignite)in.readObject();
        this.cfg = this.g.configuration();
    }

    protected void checkIgnite() throws IllegalStateException {
        if (this.g == null) {
            throw new IllegalStateException("Ignite is in invalid state to perform this operation. It either not started yet or has already being or have stopped.\nMake sure that IgniteSpringBean is not referenced from any kind of Spring bean init methods like @PostConstruct}.\n[ignite=" + this.g + ", cfg=" + this.cfg + ']');
        }
    }

    public String toString() {
        return S.toString(IgniteSpringBean.class, this);
    }
}

