/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi.stubs.elements;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.psi.stubs.IndexSink;
import org.jetbrains.kotlin.com.intellij.psi.stubs.StubElement;
import org.jetbrains.kotlin.com.intellij.psi.stubs.StubInputStream;
import org.jetbrains.kotlin.com.intellij.psi.stubs.StubOutputStream;
import org.jetbrains.kotlin.com.intellij.util.io.StringRef;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtTypeAlias;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.psi.stubs.KotlinTypeAliasStub;
import org.jetbrains.kotlin.psi.stubs.elements.KtStubElementType;
import org.jetbrains.kotlin.psi.stubs.elements.StubIndexService;
import org.jetbrains.kotlin.psi.stubs.impl.KotlinTypeAliasStubImpl;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001e\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\u00032\f\u0010\t\u001a\b\u0012\u0002\b\u0003\u0018\u00010\nH\u0016J\u001e\u0010\u000b\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\r2\f\u0010\t\u001a\b\u0012\u0002\b\u0003\u0018\u00010\nH\u0016J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0018\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\u0014H\u0016\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/psi/stubs/elements/KtTypeAliasElementType;", "Lorg/jetbrains/kotlin/psi/stubs/elements/KtStubElementType;", "Lorg/jetbrains/kotlin/psi/stubs/KotlinTypeAliasStub;", "Lorg/jetbrains/kotlin/psi/KtTypeAlias;", "debugName", "", "(Ljava/lang/String;)V", "createStub", "psi", "parentStub", "Lorg/jetbrains/kotlin/com/intellij/psi/stubs/StubElement;", "deserialize", "dataStream", "Lorg/jetbrains/kotlin/com/intellij/psi/stubs/StubInputStream;", "indexStub", "", "stub", "sink", "Lorg/jetbrains/kotlin/com/intellij/psi/stubs/IndexSink;", "serialize", "Lorg/jetbrains/kotlin/com/intellij/psi/stubs/StubOutputStream;"})
public final class KtTypeAliasElementType
extends KtStubElementType<KotlinTypeAliasStub, KtTypeAlias> {
    @Override
    @NotNull
    public KotlinTypeAliasStub createStub(@NotNull KtTypeAlias psi, @Nullable StubElement<?> parentStub) {
        Intrinsics.checkParameterIsNotNull(psi, "psi");
        StringRef name2 = StringRef.fromString(psi.getName());
        FqName fqName2 = KtPsiUtilKt.safeFqNameForLazyResolve(psi);
        StringRef fqName3 = StringRef.fromString(fqName2 != null ? fqName2.asString() : null);
        boolean isTopLevel = psi.isTopLevel();
        return new KotlinTypeAliasStubImpl(parentStub, name2, fqName3, isTopLevel);
    }

    @Override
    public void serialize(@NotNull KotlinTypeAliasStub stub, @NotNull StubOutputStream dataStream) {
        Intrinsics.checkParameterIsNotNull(stub, "stub");
        Intrinsics.checkParameterIsNotNull(dataStream, "dataStream");
        dataStream.writeName(stub.getName());
        FqName fqName2 = stub.getFqName();
        dataStream.writeName(fqName2 != null ? fqName2.asString() : null);
        dataStream.writeBoolean(stub.isTopLevel());
    }

    @Override
    @NotNull
    public KotlinTypeAliasStub deserialize(@NotNull StubInputStream dataStream, @Nullable StubElement<?> parentStub) {
        Intrinsics.checkParameterIsNotNull(dataStream, "dataStream");
        StringRef name2 = dataStream.readName();
        StringRef fqName2 = dataStream.readName();
        boolean isTopLevel = dataStream.readBoolean();
        return new KotlinTypeAliasStubImpl(parentStub, name2, fqName2, isTopLevel);
    }

    @Override
    public void indexStub(@NotNull KotlinTypeAliasStub stub, @NotNull IndexSink sink) {
        Intrinsics.checkParameterIsNotNull(stub, "stub");
        Intrinsics.checkParameterIsNotNull(sink, "sink");
        StubIndexService.Companion.getInstance().indexTypeAlias(stub, sink);
    }

    public KtTypeAliasElementType(@NotNull String debugName) {
        Intrinsics.checkParameterIsNotNull(debugName, "debugName");
        super(debugName, KtTypeAlias.class, KotlinTypeAliasStub.class);
    }
}

