/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi;

import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.navigation.ItemPresentation;
import org.jetbrains.kotlin.com.intellij.navigation.ItemPresentationProviders;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiModifiableCodeBlock;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.IfNotParsed;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtClassBody;
import org.jetbrains.kotlin.psi.KtDeclarationWithInitializer;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtParameterList;
import org.jetbrains.kotlin.psi.KtTypeParameterList;
import org.jetbrains.kotlin.psi.KtTypeParameterListOwnerStub;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.KtVisitor;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.psi.stubs.KotlinFunctionStub;
import org.jetbrains.kotlin.psi.stubs.elements.KtStubElementTypes;
import org.jetbrains.kotlin.psi.typeRefHelpers.TypeRefHelpersKt;
import org.jetbrains.kotlin.util.AstLoadingFilter;

public class KtNamedFunction
extends KtTypeParameterListOwnerStub<KotlinFunctionStub>
implements PsiModifiableCodeBlock,
KtDeclarationWithInitializer,
KtFunction {
    public KtNamedFunction(@NotNull ASTNode node) {
        if (node == null) {
            KtNamedFunction.$$$reportNull$$$0(0);
        }
        super(node);
    }

    public KtNamedFunction(@NotNull KotlinFunctionStub stub) {
        if (stub == null) {
            KtNamedFunction.$$$reportNull$$$0(1);
        }
        super(stub, KtStubElementTypes.FUNCTION);
    }

    @Override
    public <R, D> R accept(@NotNull KtVisitor<R, D> visitor2, D data2) {
        if (visitor2 == null) {
            KtNamedFunction.$$$reportNull$$$0(2);
        }
        return visitor2.visitNamedFunction(this, data2);
    }

    public boolean hasTypeParameterListBeforeFunctionName() {
        KotlinFunctionStub stub = (KotlinFunctionStub)this.getStub();
        if (stub != null) {
            return stub.hasTypeParameterListBeforeFunctionName();
        }
        return this.hasTypeParameterListBeforeFunctionNameByTree();
    }

    private boolean hasTypeParameterListBeforeFunctionNameByTree() {
        KtTypeParameterList typeParameterList = this.getTypeParameterList();
        if (typeParameterList == null) {
            return false;
        }
        PsiElement nameIdentifier = this.getNameIdentifier();
        if (nameIdentifier == null) {
            return true;
        }
        return nameIdentifier.getTextOffset() > typeParameterList.getTextOffset();
    }

    @Override
    public boolean hasBlockBody() {
        KotlinFunctionStub stub = (KotlinFunctionStub)this.getStub();
        if (stub != null) {
            return stub.hasBlockBody();
        }
        return this.getEqualsToken() == null;
    }

    @IfNotParsed
    @Nullable
    public PsiElement getFunKeyword() {
        return this.findChildByType(KtTokens.FUN_KEYWORD);
    }

    @Override
    @Nullable
    public PsiElement getEqualsToken() {
        return this.findChildByType(KtTokens.EQ);
    }

    @Override
    @Nullable
    public KtExpression getInitializer() {
        return PsiTreeUtil.getNextSiblingOfType(this.getEqualsToken(), KtExpression.class);
    }

    @Override
    public boolean hasInitializer() {
        return this.getInitializer() != null;
    }

    @Override
    public ItemPresentation getPresentation() {
        return ItemPresentationProviders.getItemPresentation(this);
    }

    @Override
    @Nullable
    public KtParameterList getValueParameterList() {
        return (KtParameterList)this.getStubOrPsiChild(KtStubElementTypes.VALUE_PARAMETER_LIST);
    }

    @Override
    @NotNull
    public List<KtParameter> getValueParameters() {
        KtParameterList list2 = this.getValueParameterList();
        List<KtParameter> list3 = list2 != null ? list2.getParameters() : Collections.emptyList();
        if (list3 == null) {
            KtNamedFunction.$$$reportNull$$$0(3);
        }
        return list3;
    }

    @Override
    @Nullable
    public KtExpression getBodyExpression() {
        KotlinFunctionStub stub = (KotlinFunctionStub)this.getStub();
        if (stub != null && !stub.hasBody()) {
            return null;
        }
        return AstLoadingFilter.forceAllowTreeLoading(this.getContainingFile(), () -> this.findChildByClass(KtExpression.class));
    }

    @Override
    @Nullable
    public KtBlockExpression getBodyBlockExpression() {
        KotlinFunctionStub stub = (KotlinFunctionStub)this.getStub();
        if (!(stub == null || stub.hasBlockBody() && stub.hasBody())) {
            return null;
        }
        KtExpression bodyExpression = this.findChildByClass(KtExpression.class);
        if (bodyExpression instanceof KtBlockExpression) {
            return (KtBlockExpression)bodyExpression;
        }
        return null;
    }

    @Override
    public boolean hasBody() {
        KotlinFunctionStub stub = (KotlinFunctionStub)this.getStub();
        if (stub != null) {
            return stub.hasBody();
        }
        return this.getBodyExpression() != null;
    }

    @Override
    public boolean hasDeclaredReturnType() {
        return this.getTypeReference() != null;
    }

    @Override
    @Nullable
    public KtTypeReference getReceiverTypeReference() {
        KotlinFunctionStub stub = (KotlinFunctionStub)this.getStub();
        if (stub != null) {
            if (!stub.isExtension()) {
                return null;
            }
            List childTypeReferences = this.getStubOrPsiChildrenAsList(KtStubElementTypes.TYPE_REFERENCE);
            if (!childTypeReferences.isEmpty()) {
                return (KtTypeReference)childTypeReferences.get(0);
            }
            return null;
        }
        return this.getReceiverTypeRefByTree();
    }

    @Nullable
    private KtTypeReference getReceiverTypeRefByTree() {
        IElementType tt;
        for (PsiElement child = this.getFirstChild(); child != null && (tt = child.getNode().getElementType()) != KtTokens.LPAR && tt != KtTokens.COLON; child = child.getNextSibling()) {
            if (!(child instanceof KtTypeReference)) continue;
            return (KtTypeReference)child;
        }
        return null;
    }

    @Override
    @Nullable
    public KtTypeReference getTypeReference() {
        KotlinFunctionStub stub = (KotlinFunctionStub)this.getStub();
        if (stub != null) {
            int returnTypeIndex;
            List typeReferences = this.getStubOrPsiChildrenAsList(KtStubElementTypes.TYPE_REFERENCE);
            int n = returnTypeIndex = stub.isExtension() ? 1 : 0;
            if (returnTypeIndex >= typeReferences.size()) {
                return null;
            }
            return (KtTypeReference)typeReferences.get(returnTypeIndex);
        }
        return TypeRefHelpersKt.getTypeReference(this);
    }

    @Override
    @Nullable
    public KtTypeReference setTypeReference(@Nullable KtTypeReference typeRef) {
        return TypeRefHelpersKt.setTypeReference(this, this.getValueParameterList(), typeRef);
    }

    @Override
    @Nullable
    public PsiElement getColon() {
        return this.findChildByType(KtTokens.COLON);
    }

    @Override
    public boolean isLocal() {
        PsiElement parent2 = this.getParent();
        return !(parent2 instanceof KtFile) && !(parent2 instanceof KtClassBody);
    }

    public boolean isTopLevel() {
        KotlinFunctionStub stub = (KotlinFunctionStub)this.getStub();
        if (stub != null) {
            return stub.isTopLevel();
        }
        return this.getParent() instanceof KtFile;
    }

    @Override
    public boolean shouldChangeModificationCount(PsiElement place) {
        return false;
    }

    public boolean mayHaveContract() {
        KotlinFunctionStub stub = (KotlinFunctionStub)this.getStub();
        if (stub != null) {
            return stub.mayHaveContract();
        }
        return KtPsiUtilKt.isContractPresentPsiCheck(this);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stub";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/psi/KtNamedFunction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/psi/KtNamedFunction";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getValueParameters";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

