/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.jdom;

import gnu.trove.TObjectHashingStrategy;
import java.util.List;
import org.jetbrains.kotlin.com.intellij.openapi.util.Comparing;
import org.jetbrains.kotlin.com.intellij.openapi.util.Condition;
import org.jetbrains.kotlin.com.intellij.openapi.util.Conditions;
import org.jetbrains.kotlin.com.intellij.openapi.util.JDOMUtil;
import org.jetbrains.kotlin.com.intellij.util.containers.OpenTHashSet;
import org.jetbrains.kotlin.com.intellij.util.containers.StringInterner;
import org.jetbrains.kotlin.org.jdom.Attribute;
import org.jetbrains.kotlin.org.jdom.Content;
import org.jetbrains.kotlin.org.jdom.Element;
import org.jetbrains.kotlin.org.jdom.ImmutableElement;
import org.jetbrains.kotlin.org.jdom.ImmutableSameTypeAttributeList;
import org.jetbrains.kotlin.org.jdom.Text;

public class JDOMInterner {
    private static final Condition<Object> IS_ELEMENT = Conditions.instanceOf(Element.class);
    private final StringInterner myStrings = new StringInterner();
    private final OpenTHashSet<Element> myElements = new OpenTHashSet<Element>(new TObjectHashingStrategy<Element>(){

        @Override
        public int computeHashCode(Element e) {
            int result2 = e.getName().hashCode() * 31;
            result2 += JDOMInterner.computeAttributesHashCode(e);
            List<Content> content = e.getContent();
            result2 = result2 * 31 + content.size();
            for (Content child : content) {
                if (child instanceof Text) {
                    result2 = result2 * 31 + JDOMInterner.computeTextHashCode((Text)child);
                    continue;
                }
                if (!(child instanceof Element)) continue;
                result2 = result2 * 31 + this.computeHashCode((Element)child);
                break;
            }
            return result2;
        }

        @Override
        public boolean equals(Element o1, Element o2) {
            if (!Comparing.strEqual(o1.getName(), o2.getName())) {
                return false;
            }
            if (!JDOMInterner.attributesEqual(o1, o2)) {
                return false;
            }
            List<Content> content1 = o1.getContent();
            List<Content> content2 = o2.getContent();
            if (content1.size() != content2.size()) {
                return false;
            }
            for (int i = 0; i < content1.size(); ++i) {
                Content c1 = content1.get(i);
                Content c2 = content2.get(i);
                if (c1 instanceof Text) {
                    if (!(c2 instanceof Text)) {
                        return false;
                    }
                    if (Comparing.strEqual(c1.getValue(), c2.getValue())) continue;
                    return false;
                }
                if (c1 instanceof Element) {
                    if (!(c2 instanceof Element)) {
                        return false;
                    }
                    if (this.equals((Element)c1, (Element)c2)) continue;
                    return false;
                }
                throw new RuntimeException(c1.toString());
            }
            return true;
        }
    });
    private final OpenTHashSet<Text> myTexts = new OpenTHashSet<Text>(new TObjectHashingStrategy<Text>(){

        @Override
        public int computeHashCode(Text object) {
            return JDOMInterner.computeTextHashCode(object);
        }

        @Override
        public boolean equals(Text o1, Text o2) {
            return Comparing.strEqual(o1.getValue(), o2.getValue());
        }
    });

    private static int computeAttributesHashCode(Element e) {
        List<Attribute> attributes = JDOMUtil.getAttributes(e);
        if (attributes instanceof ImmutableSameTypeAttributeList) {
            return attributes.hashCode();
        }
        int result2 = 1;
        for (Attribute attribute : attributes) {
            result2 = result2 * 31 + JDOMInterner.computeAttributeHashCode(attribute.getName(), attribute.getValue());
        }
        return result2;
    }

    private static boolean attributesEqual(Element o1, Element o2) {
        if (o1 instanceof ImmutableElement) {
            return ((ImmutableElement)o1).attributesEqual(o2);
        }
        if (o2 instanceof ImmutableElement) {
            return ((ImmutableElement)o2).attributesEqual(o1);
        }
        List<Attribute> a1 = JDOMUtil.getAttributes(o1);
        List<Attribute> a2 = JDOMUtil.getAttributes(o2);
        if (a1.size() != a2.size()) {
            return false;
        }
        for (int i = 0; i < a1.size(); ++i) {
            Attribute attr2;
            Attribute attr1 = a1.get(i);
            if (ImmutableElement.attributesEqual(attr1, attr2 = a2.get(i))) continue;
            return false;
        }
        return true;
    }

    static int computeAttributeHashCode(String name2, String value) {
        return name2.hashCode() * 31 + (value == null ? 0 : value.hashCode());
    }

    private static int computeTextHashCode(Text object) {
        return object.getValue().hashCode();
    }
}

