/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.library.impl;

import java.io.RandomAccessFile;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.konan.file.File;
import org.jetbrains.kotlin.konan.file.FileKt;
import org.jetbrains.kotlin.library.impl.DeclarationId;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012J\u0006\u0010\u0013\u001a\u00020\nJ\u0006\u0010\u0014\u001a\u00020\u000eR\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/library/impl/CombinedIrFileWriter;", "", "declarationCount", "", "(I)V", "currentDeclaration", "currentPosition", "getDeclarationCount", "()I", "file", "Lorg/jetbrains/kotlin/konan/file/File;", "randomAccessFile", "Ljava/io/RandomAccessFile;", "addDeclaration", "", "id", "Lorg/jetbrains/kotlin/library/impl/DeclarationId;", "bytes", "", "finishWriting", "skipDeclaration", "kotlin-util-klib"})
public final class CombinedIrFileWriter {
    private int currentDeclaration;
    private int currentPosition;
    private final File file;
    private final RandomAccessFile randomAccessFile;
    private final int declarationCount;

    public final void skipDeclaration() {
        int n = this.currentDeclaration;
        this.currentDeclaration = n + 1;
    }

    public final void addDeclaration(@NotNull DeclarationId id, @NotNull byte[] bytes2) {
        Intrinsics.checkParameterIsNotNull(id, "id");
        Intrinsics.checkParameterIsNotNull(bytes2, "bytes");
        this.randomAccessFile.seek(this.currentDeclaration * 20 + 4);
        this.randomAccessFile.writeLong(id.getId());
        this.randomAccessFile.writeInt(id.isLocal() ? 1 : 0);
        this.randomAccessFile.writeInt(this.currentPosition);
        this.randomAccessFile.writeInt(bytes2.length);
        this.randomAccessFile.seek(this.currentPosition);
        this.randomAccessFile.write(bytes2);
        int n = this.randomAccessFile.getFilePointer() < (long)Integer.MAX_VALUE ? 1 : 0;
        boolean bl = false;
        boolean bl2 = false;
        if (_Assertions.ENABLED && n == 0) {
            boolean bl3 = false;
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        this.currentPosition = (int)this.randomAccessFile.getFilePointer();
        n = this.currentDeclaration;
        this.currentDeclaration = n + 1;
    }

    @NotNull
    public final File finishWriting() {
        boolean bl = this.currentDeclaration == this.declarationCount;
        boolean bl2 = false;
        boolean bl3 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl4 = false;
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        this.randomAccessFile.close();
        return this.file;
    }

    public final int getDeclarationCount() {
        return this.declarationCount;
    }

    /*
     * WARNING - void declaration
     */
    public CombinedIrFileWriter(int declarationCount) {
        this.declarationCount = declarationCount;
        this.file = FileKt.createTempFile$default("ir", null, 2, null).deleteOnExit();
        this.randomAccessFile = new RandomAccessFile(this.file.getPath(), "rw");
        this.randomAccessFile.writeInt(this.declarationCount);
        int n = (int)this.randomAccessFile.getFilePointer() == 4 ? 1 : 0;
        int n2 = 0;
        boolean bl = false;
        if (_Assertions.ENABLED && n == 0) {
            boolean bl2 = false;
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        n = 0;
        n2 = this.declarationCount;
        while (n < n2) {
            void i;
            this.randomAccessFile.writeLong(-1L);
            this.randomAccessFile.writeInt(-1);
            this.randomAccessFile.writeInt(-1);
            this.randomAccessFile.writeInt(-1);
            ++i;
        }
        this.currentPosition = (int)this.randomAccessFile.getFilePointer();
        n = this.currentPosition == 4 + 20 * this.declarationCount ? 1 : 0;
        n2 = 0;
        bl = false;
        if (_Assertions.ENABLED && n == 0) {
            boolean bl3 = false;
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
    }
}

