/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.context;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.js.backend.ast.JsBlock;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsScope;
import org.jetbrains.kotlin.js.backend.ast.JsVars;
import org.jetbrains.kotlin.js.backend.ast.metadata.MetadataProperties;
import org.jetbrains.kotlin.js.translate.context.TemporaryVariable;

public final class DynamicContext {
    @NotNull
    private final JsScope currentScope;
    @NotNull
    private final JsBlock currentBlock;
    @Nullable
    private JsVars vars;

    @NotNull
    public static DynamicContext rootContext(@NotNull JsScope rootScope2, @NotNull JsBlock globalBlock) {
        if (rootScope2 == null) {
            DynamicContext.$$$reportNull$$$1(0);
        }
        if (globalBlock == null) {
            DynamicContext.$$$reportNull$$$1(1);
        }
        if (rootScope2 == null) {
            DynamicContext.$$$reportNull$$$0(0);
        }
        if (globalBlock == null) {
            DynamicContext.$$$reportNull$$$0(1);
        }
        return new DynamicContext(rootScope2, globalBlock);
    }

    @NotNull
    public static DynamicContext newContext(@NotNull JsScope scope2, @NotNull JsBlock block) {
        if (scope2 == null) {
            DynamicContext.$$$reportNull$$$1(2);
        }
        if (block == null) {
            DynamicContext.$$$reportNull$$$1(3);
        }
        if (scope2 == null) {
            DynamicContext.$$$reportNull$$$0(2);
        }
        if (block == null) {
            DynamicContext.$$$reportNull$$$0(3);
        }
        return new DynamicContext(scope2, block);
    }

    private DynamicContext(@NotNull JsScope scope2, @NotNull JsBlock block) {
        if (scope2 == null) {
            DynamicContext.$$$reportNull$$$1(4);
        }
        if (block == null) {
            DynamicContext.$$$reportNull$$$1(5);
        }
        if (scope2 == null) {
            DynamicContext.$$$reportNull$$$0(4);
        }
        if (block == null) {
            DynamicContext.$$$reportNull$$$0(5);
        }
        this.currentScope = scope2;
        this.currentBlock = block;
    }

    @NotNull
    public DynamicContext innerBlock(@NotNull JsBlock block) {
        if (block == null) {
            DynamicContext.$$$reportNull$$$1(6);
        }
        if (block == null) {
            DynamicContext.$$$reportNull$$$0(6);
        }
        return new DynamicContext(this.currentScope, block);
    }

    @NotNull
    public TemporaryVariable declareTemporary(@Nullable JsExpression initExpression, @Nullable Object sourceInfo) {
        if (this.vars == null) {
            this.vars = new JsVars();
            MetadataProperties.setSynthetic(this.vars, true);
            this.currentBlock.getStatements().add(this.vars);
            this.vars.setSource(sourceInfo);
        }
        JsName temporaryName = JsScope.declareTemporary();
        JsVars.JsVar var = new JsVars.JsVar(temporaryName, null);
        var.setSource(sourceInfo);
        MetadataProperties.setSynthetic(var, true);
        this.vars.add(var);
        if (initExpression != null) {
            var.source(initExpression.getSource());
        }
        TemporaryVariable temporaryVariable = TemporaryVariable.create(temporaryName, initExpression);
        if (temporaryVariable == null) {
            DynamicContext.$$$reportNull$$$0(7);
        }
        if (temporaryVariable == null) {
            DynamicContext.$$$reportNull$$$1(7);
        }
        return temporaryVariable;
    }

    void moveVarsFrom(@NotNull DynamicContext dynamicContext) {
        if (dynamicContext == null) {
            DynamicContext.$$$reportNull$$$1(8);
        }
        if (dynamicContext == null) {
            DynamicContext.$$$reportNull$$$0(8);
        }
        if (dynamicContext.vars != null) {
            if (this.vars == null) {
                this.vars = dynamicContext.vars;
                this.currentBlock.getStatements().add(this.vars);
            } else {
                this.vars.addAll(dynamicContext.vars);
            }
            dynamicContext.currentBlock.getStatements().remove(dynamicContext.vars);
            dynamicContext.vars = null;
        }
    }

    @NotNull
    public JsScope getScope() {
        JsScope jsScope = this.currentScope;
        if (jsScope == null) {
            DynamicContext.$$$reportNull$$$0(9);
        }
        if (jsScope == null) {
            DynamicContext.$$$reportNull$$$1(9);
        }
        return jsScope;
    }

    @NotNull
    public JsBlock jsBlock() {
        JsBlock jsBlock = this.currentBlock;
        if (jsBlock == null) {
            DynamicContext.$$$reportNull$$$0(10);
        }
        if (jsBlock == null) {
            DynamicContext.$$$reportNull$$$1(10);
        }
        return jsBlock;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 9: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootScope";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "globalBlock";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 3: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "block";
                break;
            }
            case 7: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/js/translate/context/DynamicContext";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dynamicContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/js/translate/context/DynamicContext";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "declareTemporary";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getScope";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "jsBlock";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "rootContext";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "newContext";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "innerBlock";
                break;
            }
            case 7: 
            case 9: 
            case 10: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "moveVarsFrom";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static /* synthetic */ void $$$reportNull$$$1(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 9: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootScope";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "globalBlock";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 3: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "block";
                break;
            }
            case 7: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/js/translate/context/DynamicContext";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dynamicContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/js/translate/context/DynamicContext";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "declareTemporary";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getScope";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "jsBlock";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "rootContext";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "newContext";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "innerBlock";
                break;
            }
            case 7: 
            case 9: 
            case 10: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "moveVarsFrom";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

