/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.compiler.plugin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.compiler.plugin.AbstractCliOption;
import org.jetbrains.kotlin.compiler.plugin.CliOptionValue;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=2, d1={"\u0000\u001e\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u001c\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u001a\u001e\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\u00012\u0006\u0010\b\u001a\u00020\u0001\u001a\u0010\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\u0001\u00a8\u0006\f"}, d2={"cliPluginUsageString", "", "pluginId", "options", "", "Lorg/jetbrains/kotlin/compiler/plugin/AbstractCliOption;", "getPluginOptionString", "key", "value", "parsePluginOption", "Lorg/jetbrains/kotlin/compiler/plugin/CliOptionValue;", "argumentValue", "plugin-api"})
public final class CliOptionsKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String cliPluginUsageString(@NotNull String pluginId, @NotNull Collection<? extends AbstractCliOption> options) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkParameterIsNotNull(pluginId, "pluginId");
        Intrinsics.checkParameterIsNotNull(options, "options");
        int LEFT_INDENT = 2;
        int MAX_OPTION_WIDTH = 26;
        Iterable $this$map$iv = options;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            AbstractCliOption abstractCliOption = (AbstractCliOption)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String name2 = it.getOptionName() + ' ' + it.getValueDescription();
            String margin = name2.length() > MAX_OPTION_WIDTH ? "\n" + StringsKt.repeat(" ", MAX_OPTION_WIDTH + LEFT_INDENT + 1) : StringsKt.repeat(" ", 1 + MAX_OPTION_WIDTH - name2.length());
            List<String> modifiers2 = CollectionsKt.listOfNotNull(it.getRequired() ? "required" : null, it.getAllowMultipleOccurrences() ? "multiple" : null);
            String modifiersEnclosed = modifiers2.isEmpty() ? "" : " (" + CollectionsKt.joinToString$default(modifiers2, null, null, null, 0, null, null, 63, null) + ')';
            String string = StringsKt.repeat(" ", LEFT_INDENT) + name2 + margin + it.getDescription() + modifiersEnclosed;
            collection.add(string);
        }
        List renderedOptions = (List)destination$iv$iv;
        return "Plugin \"" + pluginId + "\" usage:\n" + CollectionsKt.joinToString$default(renderedOptions, "\n", null, "\n", 0, null, null, 58, null);
    }

    @Nullable
    public static final CliOptionValue parsePluginOption(@NotNull String argumentValue) {
        Intrinsics.checkParameterIsNotNull(argumentValue, "argumentValue");
        Pattern pattern = Pattern.compile("^plugin:([^:]*):([^=]*)=(.*)$");
        Matcher matcher2 = pattern.matcher(argumentValue);
        if (matcher2.matches()) {
            String string = matcher2.group(1);
            Intrinsics.checkExpressionValueIsNotNull(string, "matcher.group(1)");
            String string2 = matcher2.group(2);
            Intrinsics.checkExpressionValueIsNotNull(string2, "matcher.group(2)");
            String string3 = matcher2.group(3);
            Intrinsics.checkExpressionValueIsNotNull(string3, "matcher.group(3)");
            return new CliOptionValue(string, string2, string3);
        }
        return null;
    }

    @NotNull
    public static final String getPluginOptionString(@NotNull String pluginId, @NotNull String key, @NotNull String value) {
        Intrinsics.checkParameterIsNotNull(pluginId, "pluginId");
        Intrinsics.checkParameterIsNotNull(key, "key");
        Intrinsics.checkParameterIsNotNull(value, "value");
        return "plugin:" + pluginId + ':' + key + '=' + value;
    }
}

