/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.presentation.java;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.extapi.psi.StubBasedPsiElementBase;
import org.jetbrains.kotlin.com.intellij.psi.PsiAnonymousClass;
import org.jetbrains.kotlin.com.intellij.psi.PsiBundle;
import org.jetbrains.kotlin.com.intellij.psi.PsiClass;
import org.jetbrains.kotlin.com.intellij.psi.PsiClassOwner;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiEnumConstant;
import org.jetbrains.kotlin.com.intellij.psi.PsiEnumConstantInitializer;
import org.jetbrains.kotlin.com.intellij.psi.PsiField;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.com.intellij.psi.PsiFunctionalExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiMember;
import org.jetbrains.kotlin.com.intellij.psi.PsiMethod;
import org.jetbrains.kotlin.com.intellij.psi.impl.java.stubs.FunctionalExpressionStub;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiExpressionTrimRenderer;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiTreeUtil;

public class ClassPresentationUtil {
    private ClassPresentationUtil() {
    }

    public static String getNameForClass(@NotNull PsiClass aClass2, boolean qualified) {
        String qName;
        if (aClass2 == null) {
            ClassPresentationUtil.$$$reportNull$$$0(0);
        }
        if (aClass2 instanceof PsiAnonymousClass) {
            if (aClass2 instanceof PsiEnumConstantInitializer) {
                PsiEnumConstant enumConstant = ((PsiEnumConstantInitializer)aClass2).getEnumConstant();
                String name2 = enumConstant.getName();
                return PsiBundle.message("enum.constant.context", name2, ClassPresentationUtil.getContextName(enumConstant, qualified, false));
            }
            return PsiBundle.message("anonymous.class.context.display", ClassPresentationUtil.getContextName(aClass2, qualified, false));
        }
        if (qualified && (qName = aClass2.getQualifiedName()) != null) {
            return qName;
        }
        String className2 = aClass2.getName();
        String contextName = ClassPresentationUtil.getContextName(aClass2, qualified);
        return contextName != null ? PsiBundle.message("class.context.display", className2, contextName) : className2;
    }

    private static String getNameForElement(@NotNull PsiElement element, boolean qualified, boolean ignorePsiClassOwner) {
        if (element == null) {
            ClassPresentationUtil.$$$reportNull$$$0(1);
        }
        if (element instanceof PsiClass) {
            return ClassPresentationUtil.getNameForClass((PsiClass)element, qualified);
        }
        if (element instanceof PsiMethod) {
            PsiMethod method = (PsiMethod)element;
            String methodName = method.getName();
            return PsiBundle.message("method.context.display", methodName, ClassPresentationUtil.getContextName(method, qualified, false));
        }
        if (element instanceof PsiClassOwner && ignorePsiClassOwner) {
            return null;
        }
        if (element instanceof PsiFile) {
            return ((PsiFile)element).getName();
        }
        if (element instanceof PsiField) {
            return ((PsiField)element).getName() + " in " + ClassPresentationUtil.getContextName(element, qualified, false);
        }
        return null;
    }

    public static String getContextName(@NotNull PsiElement element, boolean qualified) {
        if (element == null) {
            ClassPresentationUtil.$$$reportNull$$$0(2);
        }
        return ClassPresentationUtil.getContextName(element, qualified, true);
    }

    public static String getContextName(@NotNull PsiElement element, boolean qualified, boolean ignorePsiClassOwner) {
        PsiElement parent2;
        if (element == null) {
            ClassPresentationUtil.$$$reportNull$$$0(3);
        }
        if ((parent2 = PsiTreeUtil.getStubOrPsiParentOfType(element, PsiMember.class)) == null) {
            parent2 = element.getContainingFile();
        }
        while (parent2 != null) {
            String name2 = ClassPresentationUtil.getNameForElement(parent2, qualified, ignorePsiClassOwner);
            if (name2 != null) {
                return name2;
            }
            if (parent2 instanceof PsiFile) {
                return null;
            }
            parent2 = PsiTreeUtil.getStubOrPsiParent(parent2);
        }
        return null;
    }

    public static String getFunctionalExpressionPresentation(PsiFunctionalExpression functionalExpression, boolean qualified) {
        Object stub = ((StubBasedPsiElementBase)((Object)functionalExpression)).getGreenStub();
        String lambdaText = stub instanceof FunctionalExpressionStub ? ((FunctionalExpressionStub)stub).getPresentableText() : PsiExpressionTrimRenderer.render(functionalExpression);
        return PsiBundle.message("class.context.display", lambdaText, ClassPresentationUtil.getContextName(functionalExpression, qualified, false));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/kotlin/com/intellij/psi/presentation/java/ClassPresentationUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getNameForClass";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getNameForElement";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getContextName";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

