/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl.cache;

import gnu.trove.TIntObjectHashMap;
import gnu.trove.TObjectIntHashMap;
import org.jetbrains.kotlin.com.intellij.psi.JavaTokenType;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;
import org.jetbrains.kotlin.com.intellij.util.BitUtil;

public final class ModifierFlags {
    public static final int PUBLIC_MASK = 1;
    public static final int PRIVATE_MASK = 2;
    public static final int PROTECTED_MASK = 4;
    public static final int STATIC_MASK = 8;
    public static final int FINAL_MASK = 16;
    public static final int SYNCHRONIZED_MASK = 32;
    public static final int VOLATILE_MASK = 64;
    public static final int TRANSIENT_MASK = 128;
    public static final int NATIVE_MASK = 256;
    public static final int DEFAULT_MASK = 512;
    public static final int ABSTRACT_MASK = 1024;
    public static final int STRICTFP_MASK = 2048;
    public static final int PACKAGE_LOCAL_MASK = 4096;
    public static final int OPEN_MASK = 8192;
    public static final int TRANSITIVE_MASK = 16384;
    public static final TObjectIntHashMap<String> NAME_TO_MODIFIER_FLAG_MAP = new TObjectIntHashMap();
    public static final TIntObjectHashMap<String> MODIFIER_FLAG_TO_NAME_MAP = new TIntObjectHashMap();
    public static final TObjectIntHashMap<IElementType> KEYWORD_TO_MODIFIER_FLAG_MAP = new TObjectIntHashMap();

    public static boolean hasModifierProperty(String name2, int mask) {
        int flag = NAME_TO_MODIFIER_FLAG_MAP.get(name2);
        assert (flag != 0) : name2;
        return BitUtil.isSet(mask, flag);
    }

    static {
        NAME_TO_MODIFIER_FLAG_MAP.put("public", 1);
        NAME_TO_MODIFIER_FLAG_MAP.put("private", 2);
        NAME_TO_MODIFIER_FLAG_MAP.put("protected", 4);
        NAME_TO_MODIFIER_FLAG_MAP.put("static", 8);
        NAME_TO_MODIFIER_FLAG_MAP.put("final", 16);
        NAME_TO_MODIFIER_FLAG_MAP.put("synchronized", 32);
        NAME_TO_MODIFIER_FLAG_MAP.put("volatile", 64);
        NAME_TO_MODIFIER_FLAG_MAP.put("transient", 128);
        NAME_TO_MODIFIER_FLAG_MAP.put("native", 256);
        NAME_TO_MODIFIER_FLAG_MAP.put("default", 512);
        NAME_TO_MODIFIER_FLAG_MAP.put("abstract", 1024);
        NAME_TO_MODIFIER_FLAG_MAP.put("strictfp", 2048);
        NAME_TO_MODIFIER_FLAG_MAP.put("packageLocal", 4096);
        NAME_TO_MODIFIER_FLAG_MAP.put("open", 8192);
        NAME_TO_MODIFIER_FLAG_MAP.put("transitive", 16384);
        for (Object name2 : NAME_TO_MODIFIER_FLAG_MAP.keys()) {
            MODIFIER_FLAG_TO_NAME_MAP.put(NAME_TO_MODIFIER_FLAG_MAP.get((String)name2), (String)name2);
        }
        KEYWORD_TO_MODIFIER_FLAG_MAP.put(JavaTokenType.PUBLIC_KEYWORD, 1);
        KEYWORD_TO_MODIFIER_FLAG_MAP.put(JavaTokenType.PRIVATE_KEYWORD, 2);
        KEYWORD_TO_MODIFIER_FLAG_MAP.put(JavaTokenType.PROTECTED_KEYWORD, 4);
        KEYWORD_TO_MODIFIER_FLAG_MAP.put(JavaTokenType.STATIC_KEYWORD, 8);
        KEYWORD_TO_MODIFIER_FLAG_MAP.put(JavaTokenType.FINAL_KEYWORD, 16);
        KEYWORD_TO_MODIFIER_FLAG_MAP.put(JavaTokenType.SYNCHRONIZED_KEYWORD, 32);
        KEYWORD_TO_MODIFIER_FLAG_MAP.put(JavaTokenType.VOLATILE_KEYWORD, 64);
        KEYWORD_TO_MODIFIER_FLAG_MAP.put(JavaTokenType.TRANSIENT_KEYWORD, 128);
        KEYWORD_TO_MODIFIER_FLAG_MAP.put(JavaTokenType.NATIVE_KEYWORD, 256);
        KEYWORD_TO_MODIFIER_FLAG_MAP.put(JavaTokenType.DEFAULT_KEYWORD, 512);
        KEYWORD_TO_MODIFIER_FLAG_MAP.put(JavaTokenType.ABSTRACT_KEYWORD, 1024);
        KEYWORD_TO_MODIFIER_FLAG_MAP.put(JavaTokenType.STRICTFP_KEYWORD, 2048);
        KEYWORD_TO_MODIFIER_FLAG_MAP.put(JavaTokenType.OPEN_KEYWORD, 8192);
        KEYWORD_TO_MODIFIER_FLAG_MAP.put(JavaTokenType.TRANSITIVE_KEYWORD, 16384);
    }
}

