/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.openapi.util.io;

import org.jetbrains.annotations.NotNull;

public class ByteArraySequence {
    private final byte[] myBytes;
    private final int myOffset;
    private final int myLen;

    public ByteArraySequence(@NotNull byte[] bytes2) {
        if (bytes2 == null) {
            ByteArraySequence.$$$reportNull$$$0(0);
        }
        this(bytes2, 0, bytes2.length);
    }

    public ByteArraySequence(@NotNull byte[] bytes2, int offset2, int len) {
        if (bytes2 == null) {
            ByteArraySequence.$$$reportNull$$$0(1);
        }
        this.myBytes = bytes2;
        this.myOffset = offset2;
        this.myLen = len;
        if (offset2 < 0 || offset2 > bytes2.length || offset2 + len > bytes2.length || len < 0) {
            throw new IllegalArgumentException("Offset is out of range: " + offset2 + "; bytes.length: " + bytes2.length + "; len: " + len);
        }
    }

    @NotNull
    public byte[] getBytes() {
        if (this.myBytes == null) {
            ByteArraySequence.$$$reportNull$$$0(2);
        }
        return this.myBytes;
    }

    public int getOffset() {
        return this.myOffset;
    }

    public int getLength() {
        return this.myLen;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ByteArraySequence sequence2 = (ByteArraySequence)o;
        int len = this.myLen;
        if (len != sequence2.myLen) {
            return false;
        }
        byte[] thisBytes = this.myBytes;
        byte[] thatBytes = sequence2.myBytes;
        int i = 0;
        int j = this.myOffset;
        int k = sequence2.myOffset;
        while (i < len) {
            if (thisBytes[j] != thatBytes[k]) {
                return false;
            }
            ++i;
            ++j;
            ++k;
        }
        return true;
    }

    public int hashCode() {
        int len = this.myLen;
        byte[] thisBytes = this.myBytes;
        int result2 = 1;
        int i = 0;
        int j = this.myOffset;
        while (i < len) {
            result2 = result2 * 31 + thisBytes[j];
            ++i;
            ++j;
        }
        return result2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bytes";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/openapi/util/io/ByteArraySequence";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/openapi/util/io/ByteArraySequence";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getBytes";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "subSequence";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "toBytes";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "toByteBuffer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

