/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.ide.plugins;

import gnu.trove.THashMap;
import gnu.trove.THashSet;
import gnu.trove.TObjectIntHashMap;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.diagnostic.PluginException;
import org.jetbrains.kotlin.com.intellij.ide.ClassUtilCore;
import org.jetbrains.kotlin.com.intellij.ide.IdeBundle;
import org.jetbrains.kotlin.com.intellij.ide.StartupProgress;
import org.jetbrains.kotlin.com.intellij.ide.plugins.IdeaPluginDescriptor;
import org.jetbrains.kotlin.com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import org.jetbrains.kotlin.com.intellij.ide.plugins.LoadDescriptorsContext;
import org.jetbrains.kotlin.com.intellij.ide.plugins.PluginClassCache;
import org.jetbrains.kotlin.com.intellij.ide.plugins.PluginLoadProgressManager;
import org.jetbrains.kotlin.com.intellij.ide.plugins.PluginXmlPathResolver;
import org.jetbrains.kotlin.com.intellij.ide.plugins.cl.PluginClassLoader;
import org.jetbrains.kotlin.com.intellij.openapi.application.Application;
import org.jetbrains.kotlin.com.intellij.openapi.application.ApplicationManager;
import org.jetbrains.kotlin.com.intellij.openapi.application.PathManager;
import org.jetbrains.kotlin.com.intellij.openapi.application.ex.ApplicationInfoEx;
import org.jetbrains.kotlin.com.intellij.openapi.application.impl.ApplicationInfoImpl;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.openapi.extensions.AreaInstance;
import org.jetbrains.kotlin.com.intellij.openapi.extensions.AreaListener;
import org.jetbrains.kotlin.com.intellij.openapi.extensions.ExtensionPoint;
import org.jetbrains.kotlin.com.intellij.openapi.extensions.Extensions;
import org.jetbrains.kotlin.com.intellij.openapi.extensions.ExtensionsArea;
import org.jetbrains.kotlin.com.intellij.openapi.extensions.PluginId;
import org.jetbrains.kotlin.com.intellij.openapi.extensions.impl.PicoPluginExtensionInitializationException;
import org.jetbrains.kotlin.com.intellij.openapi.util.BuildNumber;
import org.jetbrains.kotlin.com.intellij.openapi.util.Condition;
import org.jetbrains.kotlin.com.intellij.openapi.util.Couple;
import org.jetbrains.kotlin.com.intellij.openapi.util.InvalidDataException;
import org.jetbrains.kotlin.com.intellij.openapi.util.JDOMUtil;
import org.jetbrains.kotlin.com.intellij.openapi.util.SafeJdomFactory;
import org.jetbrains.kotlin.com.intellij.openapi.util.io.FileUtil;
import org.jetbrains.kotlin.com.intellij.openapi.util.io.StreamUtil;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.StringUtilRt;
import org.jetbrains.kotlin.com.intellij.util.ArrayUtil;
import org.jetbrains.kotlin.com.intellij.util.ExceptionUtil;
import org.jetbrains.kotlin.com.intellij.util.ExceptionUtilRt;
import org.jetbrains.kotlin.com.intellij.util.Function;
import org.jetbrains.kotlin.com.intellij.util.LineSeparator;
import org.jetbrains.kotlin.com.intellij.util.ObjectUtils;
import org.jetbrains.kotlin.com.intellij.util.ReflectionUtil;
import org.jetbrains.kotlin.com.intellij.util.SmartList;
import org.jetbrains.kotlin.com.intellij.util.SystemProperties;
import org.jetbrains.kotlin.com.intellij.util.containers.ContainerUtil;
import org.jetbrains.kotlin.com.intellij.util.containers.JBIterable;
import org.jetbrains.kotlin.com.intellij.util.containers.MultiMap;
import org.jetbrains.kotlin.com.intellij.util.execution.ParametersListUtil;
import org.jetbrains.kotlin.com.intellij.util.graph.CachingSemiGraph;
import org.jetbrains.kotlin.com.intellij.util.graph.DFSTBuilder;
import org.jetbrains.kotlin.com.intellij.util.graph.Graph;
import org.jetbrains.kotlin.com.intellij.util.graph.GraphGenerator;
import org.jetbrains.kotlin.com.intellij.util.graph.InboundSemiGraph;
import org.jetbrains.kotlin.com.intellij.util.io.URLUtil;
import org.jetbrains.kotlin.com.intellij.util.lang.UrlClassLoader;
import org.jetbrains.kotlin.com.intellij.util.text.VersionComparatorUtil;
import org.jetbrains.kotlin.com.intellij.util.xmlb.JDOMXIncluder;
import org.jetbrains.kotlin.com.intellij.util.xmlb.XmlSerializationException;
import org.jetbrains.kotlin.org.jdom.JDOMException;

public class PluginManagerCore {
    public static String BUILD_NUMBER;
    private static final TObjectIntHashMap<PluginId> ourId2Index;
    private static final Map<String, IdeaPluginDescriptorImpl> ourModulesToContainingPlugins;
    private static final PluginClassCache ourPluginClasses;
    private static List<String> ourDisabledPlugins;
    private static MultiMap<String, String> ourBrokenPluginVersions;
    private static IdeaPluginDescriptor[] ourPlugins;
    private static List<IdeaPluginDescriptor> ourLoadedPlugins;
    private static boolean ourUnitTestWithBundledPlugins;
    static String myPluginError;
    static List<String> myPlugins2Disable;
    static LinkedHashSet<String> myPlugins2Enable;
    private static final List<Runnable> ourDisabledPluginsListeners;

    @NotNull
    public static IdeaPluginDescriptor[] getPlugins() {
        IdeaPluginDescriptor[] ideaPluginDescriptorArray = PluginManagerCore.getPlugins(null);
        if (ideaPluginDescriptorArray == null) {
            PluginManagerCore.$$$reportNull$$$0(0);
        }
        return ideaPluginDescriptorArray;
    }

    @NotNull
    public static synchronized IdeaPluginDescriptor[] getPlugins(@Nullable StartupProgress progress) {
        if (ourPlugins == null) {
            PluginManagerCore.initPlugins(progress);
        }
        if (ourPlugins == null) {
            PluginManagerCore.$$$reportNull$$$0(1);
        }
        return ourPlugins;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadDisabledPlugins(@NotNull String configPath, @NotNull Collection<String> disabledPlugins) {
        File file2;
        if (configPath == null) {
            PluginManagerCore.$$$reportNull$$$0(4);
        }
        if (disabledPlugins == null) {
            PluginManagerCore.$$$reportNull$$$0(5);
        }
        if ((file2 = new File(configPath, "disabled_plugins.txt")).isFile()) {
            ApplicationInfoEx appInfo = ApplicationInfoImpl.getShadowInstance();
            List<String> requiredPlugins = StringUtil.split(System.getProperty("idea.required.plugins.id", ""), ",");
            try {
                boolean updateDisablePluginsList = false;
                try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file2), StandardCharsets.UTF_8));){
                    String id;
                    while ((id = reader.readLine()) != null) {
                        if (!requiredPlugins.contains(id = id.trim()) && !appInfo.isEssentialPlugin(id)) {
                            disabledPlugins.add(id);
                            continue;
                        }
                        updateDisablePluginsList = true;
                    }
                }
                finally {
                    if (updateDisablePluginsList) {
                        PluginManagerCore.savePluginsList(disabledPlugins, false, file2);
                        PluginManagerCore.fireEditDisablePlugins();
                    }
                }
            }
            catch (IOException e) {
                PluginManagerCore.getLogger().info("Unable to load disabled plugins list from " + file2, e);
            }
        }
    }

    @NotNull
    public static List<String> getDisabledPlugins() {
        if (ourDisabledPlugins == null) {
            ourDisabledPlugins = new ArrayList<String>();
            if (System.getProperty("idea.ignore.disabled.plugins") == null && !PluginManagerCore.isUnitTestMode()) {
                PluginManagerCore.loadDisabledPlugins(PathManager.getConfigPath(), ourDisabledPlugins);
            }
        }
        List<String> list2 = ourDisabledPlugins;
        if (list2 == null) {
            PluginManagerCore.$$$reportNull$$$0(6);
        }
        return list2;
    }

    public static boolean isBrokenPlugin(@NotNull IdeaPluginDescriptor descriptor2) {
        PluginId pluginId;
        if (descriptor2 == null) {
            PluginManagerCore.$$$reportNull$$$0(7);
        }
        return (pluginId = descriptor2.getPluginId()) == null || PluginManagerCore.getBrokenPluginVersions().get(pluginId.getIdString()).contains(descriptor2.getVersion());
    }

    @NotNull
    private static MultiMap<String, String> getBrokenPluginVersions() {
        if (ourBrokenPluginVersions == null) {
            ourBrokenPluginVersions = MultiMap.createSet();
            if (System.getProperty("idea.ignore.disabled.plugins") == null && !PluginManagerCore.isUnitTestMode()) {
                BufferedReader br = new BufferedReader(new InputStreamReader(PluginManagerCore.class.getResourceAsStream("/brokenPlugins.txt"), StandardCharsets.UTF_8));
                try {
                    String s;
                    while ((s = br.readLine()) != null) {
                        List<String> tokens;
                        if ((s = s.trim()).startsWith("//") || (tokens = ParametersListUtil.parse(s)).isEmpty()) continue;
                        if (tokens.size() == 1) {
                            throw new RuntimeException("brokenPlugins.txt is broken. The line contains plugin name, but does not contains version: " + s);
                        }
                        String pluginId = tokens.get(0);
                        List<String> versions2 = tokens.subList(1, tokens.size());
                        ourBrokenPluginVersions.putValues(pluginId, versions2);
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException("Failed to read /brokenPlugins.txt", e);
                }
                finally {
                    StreamUtil.closeStream(br);
                }
            }
        }
        MultiMap<String, String> multiMap = ourBrokenPluginVersions;
        if (multiMap == null) {
            PluginManagerCore.$$$reportNull$$$0(8);
        }
        return multiMap;
    }

    private static boolean isUnitTestMode() {
        Application app = ApplicationManager.getApplication();
        return app != null && app.isUnitTestMode();
    }

    private static void fireEditDisablePlugins() {
        for (Runnable listener : ourDisabledPluginsListeners) {
            listener.run();
        }
    }

    public static void savePluginsList(@NotNull Collection<String> ids, boolean append2, @NotNull File plugins) throws IOException {
        if (ids == null) {
            PluginManagerCore.$$$reportNull$$$0(11);
        }
        if (plugins == null) {
            PluginManagerCore.$$$reportNull$$$0(12);
        }
        if (!plugins.isFile()) {
            FileUtil.ensureCanCreateFile(plugins);
        }
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(plugins, append2), StandardCharsets.UTF_8));){
            PluginManagerCore.writePluginsList(ids, writer);
        }
    }

    public static void writePluginsList(@NotNull Collection<String> ids, @NotNull Writer writer) throws IOException {
        if (ids == null) {
            PluginManagerCore.$$$reportNull$$$0(13);
        }
        if (writer == null) {
            PluginManagerCore.$$$reportNull$$$0(14);
        }
        Object[] sortedIds = ArrayUtil.toStringArray(ids);
        Arrays.sort(sortedIds);
        String separator = LineSeparator.getSystemLineSeparator().getSeparatorString();
        for (Object id : sortedIds) {
            writer.write((String)id);
            writer.write(separator);
        }
    }

    public static boolean isModuleDependency(@NotNull PluginId dependentPluginId) {
        if (dependentPluginId == null) {
            PluginManagerCore.$$$reportNull$$$0(22);
        }
        return dependentPluginId.getIdString().startsWith("org.jetbrains.kotlin.com.intellij.module");
    }

    public static void checkDependants(@NotNull IdeaPluginDescriptor pluginDescriptor, @NotNull Function<? super PluginId, ? extends IdeaPluginDescriptor> pluginId2Descriptor, @NotNull Condition<? super PluginId> check2) {
        if (pluginDescriptor == null) {
            PluginManagerCore.$$$reportNull$$$0(23);
        }
        if (pluginId2Descriptor == null) {
            PluginManagerCore.$$$reportNull$$$0(24);
        }
        if (check2 == null) {
            PluginManagerCore.$$$reportNull$$$0(25);
        }
        PluginManagerCore.checkDependants(pluginDescriptor, pluginId2Descriptor, check2, new THashSet());
    }

    private static boolean checkDependants(@NotNull IdeaPluginDescriptor pluginDescriptor, @NotNull Function<? super PluginId, ? extends IdeaPluginDescriptor> pluginId2Descriptor, @NotNull Condition<? super PluginId> check2, @NotNull Set<? super PluginId> processed) {
        if (pluginDescriptor == null) {
            PluginManagerCore.$$$reportNull$$$0(26);
        }
        if (pluginId2Descriptor == null) {
            PluginManagerCore.$$$reportNull$$$0(27);
        }
        if (check2 == null) {
            PluginManagerCore.$$$reportNull$$$0(28);
        }
        if (processed == null) {
            PluginManagerCore.$$$reportNull$$$0(29);
        }
        processed.add(pluginDescriptor.getPluginId());
        PluginId[] dependentPluginIds = pluginDescriptor.getDependentPluginIds();
        THashSet<PluginId> optionalDependencies = new THashSet<PluginId>(Arrays.asList(pluginDescriptor.getOptionalDependentPluginIds()));
        for (PluginId dependentPluginId : dependentPluginIds) {
            if (processed.contains(dependentPluginId) || PluginManagerCore.isModuleDependency(dependentPluginId) && (ourModulesToContainingPlugins.isEmpty() || ourModulesToContainingPlugins.containsKey(dependentPluginId.getIdString())) || optionalDependencies.contains(dependentPluginId)) continue;
            if (!check2.value(dependentPluginId)) {
                return false;
            }
            IdeaPluginDescriptor dependantPluginDescriptor = pluginId2Descriptor.fun(dependentPluginId);
            if (dependantPluginDescriptor == null || PluginManagerCore.checkDependants(dependantPluginDescriptor, pluginId2Descriptor, check2, processed)) continue;
            return false;
        }
        return true;
    }

    public static void addPluginClass(@NotNull PluginId pluginId) {
        if (pluginId == null) {
            PluginManagerCore.$$$reportNull$$$0(30);
        }
        ourPluginClasses.addPluginClass(pluginId);
    }

    @Nullable
    public static PluginId getPluginByClassName(@NotNull String className2) {
        PluginId id;
        if (className2 == null) {
            PluginManagerCore.$$$reportNull$$$0(34);
        }
        return (id = PluginManagerCore.getPluginOrPlatformByClassName(className2)) == null || "org.jetbrains.kotlin.com.intellij".equals(id.getIdString()) ? null : id;
    }

    @Nullable
    public static PluginId getPluginOrPlatformByClassName(@NotNull String className2) {
        if (className2 == null) {
            PluginManagerCore.$$$reportNull$$$0(35);
        }
        if (className2.startsWith("java.") || className2.startsWith("javax.") || className2.startsWith("kotlin.") || className2.startsWith("groovy.")) {
            return null;
        }
        for (IdeaPluginDescriptor descriptor2 : PluginManagerCore.getPlugins()) {
            if (!PluginManagerCore.hasLoadedClass(className2, descriptor2.getPluginClassLoader())) continue;
            return descriptor2.getPluginId();
        }
        return null;
    }

    private static boolean hasLoadedClass(@NotNull String className2, ClassLoader loader) {
        if (className2 == null) {
            PluginManagerCore.$$$reportNull$$$0(36);
        }
        if (loader instanceof UrlClassLoader) {
            return ((UrlClassLoader)loader).hasLoadedClass(className2);
        }
        try {
            return (Boolean)loader.getClass().getMethod("hasLoadedClass", String.class).invoke((Object)loader, className2);
        }
        catch (Exception e) {
            return false;
        }
    }

    private static boolean isDependent(@NotNull IdeaPluginDescriptor descriptor2, @NotNull PluginId on, @NotNull Map<PluginId, IdeaPluginDescriptor> map2, boolean checkModuleDependencies) {
        if (descriptor2 == null) {
            PluginManagerCore.$$$reportNull$$$0(37);
        }
        if (on == null) {
            PluginManagerCore.$$$reportNull$$$0(38);
        }
        if (map2 == null) {
            PluginManagerCore.$$$reportNull$$$0(39);
        }
        for (PluginId id : descriptor2.getDependentPluginIds()) {
            if (ArrayUtil.contains(id, (Object[])descriptor2.getOptionalDependentPluginIds()) || !checkModuleDependencies && PluginManagerCore.isModuleDependency(id)) continue;
            if (id.equals(on)) {
                return true;
            }
            IdeaPluginDescriptor depDescriptor = map2.get(id);
            if (depDescriptor == null || !PluginManagerCore.isDependent(depDescriptor, on, map2, checkModuleDependencies)) continue;
            return true;
        }
        return false;
    }

    private static boolean hasModuleDependencies(@NotNull IdeaPluginDescriptor descriptor2) {
        PluginId[] dependentPluginIds;
        if (descriptor2 == null) {
            PluginManagerCore.$$$reportNull$$$0(40);
        }
        for (PluginId dependentPluginId : dependentPluginIds = descriptor2.getDependentPluginIds()) {
            if (!PluginManagerCore.isModuleDependency(dependentPluginId)) continue;
            return true;
        }
        return false;
    }

    private static boolean shouldLoadPlugins() {
        try {
            Class.forName("org.jetbrains.kotlin.com.intellij.openapi.extensions.Extensions");
        }
        catch (ClassNotFoundException e) {
            return false;
        }
        String loadPlugins = System.getProperty("idea.load.plugins");
        return loadPlugins == null || Boolean.TRUE.toString().equals(loadPlugins);
    }

    private static void configureExtensions() {
        Extensions.registerAreaClass("IDEA_PROJECT", null);
        Extensions.registerAreaClass("IDEA_MODULE", "IDEA_PROJECT");
    }

    @NotNull
    private static Method getAddUrlMethod(@NotNull ClassLoader loader) {
        if (loader == null) {
            PluginManagerCore.$$$reportNull$$$0(41);
        }
        Method method = ReflectionUtil.getDeclaredMethod(loader instanceof URLClassLoader ? URLClassLoader.class : loader.getClass(), "addURL", URL.class);
        if (method == null) {
            PluginManagerCore.$$$reportNull$$$0(42);
        }
        return method;
    }

    @Nullable
    private static ClassLoader createPluginClassLoader(@NotNull File[] classPath2, @NotNull ClassLoader[] parentLoaders, @NotNull IdeaPluginDescriptor pluginDescriptor) {
        if (classPath2 == null) {
            PluginManagerCore.$$$reportNull$$$0(43);
        }
        if (parentLoaders == null) {
            PluginManagerCore.$$$reportNull$$$0(44);
        }
        if (pluginDescriptor == null) {
            PluginManagerCore.$$$reportNull$$$0(45);
        }
        if (pluginDescriptor.getUseIdeaClassLoader()) {
            try {
                ClassLoader loader = PluginManagerCore.class.getClassLoader();
                Method addUrlMethod = PluginManagerCore.getAddUrlMethod(loader);
                for (File pathElement : classPath2) {
                    addUrlMethod.invoke((Object)loader, pathElement.toPath().normalize().toUri().toURL());
                }
                return loader;
            }
            catch (IOException | IllegalAccessException | InvocationTargetException e) {
                PluginManagerCore.getLogger().warn(e);
            }
        }
        PluginId pluginId = pluginDescriptor.getPluginId();
        File pluginRoot2 = pluginDescriptor.getPath();
        if (PluginManagerCore.isUnitTestMode() && !ourUnitTestWithBundledPlugins) {
            return null;
        }
        try {
            ArrayList<URL> urls = new ArrayList<URL>(classPath2.length);
            for (File pathElement : classPath2) {
                urls.add(pathElement.toPath().normalize().toUri().toURL());
            }
            return new PluginClassLoader(urls, parentLoaders, pluginId, pluginDescriptor.getVersion(), pluginRoot2);
        }
        catch (IOException e) {
            PluginManagerCore.getLogger().warn(e);
            return null;
        }
    }

    private static void logPlugins() {
        ArrayList<String> bundled = new ArrayList<String>();
        ArrayList<String> disabled = new ArrayList<String>();
        ArrayList<String> custom = new ArrayList<String>();
        for (IdeaPluginDescriptor descriptor2 : ourPlugins) {
            String version = descriptor2.getVersion();
            String s = descriptor2.getName() + (version != null ? " (" + version + ")" : "");
            if (!descriptor2.isEnabled()) {
                disabled.add(s);
                continue;
            }
            if ("IDEA CORE".equals(descriptor2.getName()) || descriptor2.isBundled()) {
                bundled.add(s);
                continue;
            }
            custom.add(s);
        }
        Collections.sort(bundled);
        Collections.sort(custom);
        Collections.sort(disabled);
        PluginManagerCore.getLogger().info("Loaded bundled plugins: " + StringUtil.join(bundled, ", "));
        if (!custom.isEmpty()) {
            PluginManagerCore.getLogger().info("Loaded custom plugins: " + StringUtil.join(custom, ", "));
        }
        if (!disabled.isEmpty()) {
            PluginManagerCore.getLogger().info("Disabled plugins: " + StringUtil.join(disabled, ", "));
        }
    }

    @NotNull
    private static ClassLoader[] getParentLoaders(@NotNull Map<PluginId, ? extends IdeaPluginDescriptor> idToDescriptorMap, @NotNull PluginId[] pluginIds) {
        if (idToDescriptorMap == null) {
            PluginManagerCore.$$$reportNull$$$0(47);
        }
        if (pluginIds == null) {
            PluginManagerCore.$$$reportNull$$$0(48);
        }
        if (PluginManagerCore.isUnitTestMode() && !ourUnitTestWithBundledPlugins) {
            ClassLoader[] classLoaderArray = new ClassLoader[]{};
            if (classLoaderArray == null) {
                PluginManagerCore.$$$reportNull$$$0(49);
            }
            return classLoaderArray;
        }
        LinkedHashSet<ClassLoader> loaders = new LinkedHashSet<ClassLoader>(pluginIds.length);
        for (PluginId id : pluginIds) {
            IdeaPluginDescriptor pluginDescriptor = idToDescriptorMap.get(id);
            if (pluginDescriptor == null) continue;
            ClassLoader loader = pluginDescriptor.getPluginClassLoader();
            if (loader == null) {
                PluginManagerCore.getLogger().error("Plugin class loader should be initialized for plugin " + id);
                continue;
            }
            loaders.add(loader);
        }
        ClassLoader[] classLoaderArray = loaders.toArray(new ClassLoader[0]);
        if (classLoaderArray == null) {
            PluginManagerCore.$$$reportNull$$$0(50);
        }
        return classLoaderArray;
    }

    public static boolean isRunningFromSources() {
        return Holder.ourIsRunningFromSources;
    }

    private static void prepareLoadingPluginsErrorMessage(@NotNull List<String> errors) {
        if (errors == null) {
            PluginManagerCore.$$$reportNull$$$0(51);
        }
        if (!errors.isEmpty()) {
            String errorMessage2 = IdeBundle.message("error.problems.found.loading.plugins", new Object[0]) + StringUtil.join(errors, "<p/>");
            Application app = ApplicationManager.getApplication();
            if (app != null && !app.isHeadlessEnvironment() && !app.isUnitTestMode()) {
                myPluginError = myPluginError == null ? errorMessage2 : myPluginError + "\n" + errorMessage2;
            } else {
                PluginManagerCore.getLogger().error(errorMessage2);
            }
        }
    }

    private static void addModulesAsDependents(@NotNull Map<PluginId, ? super IdeaPluginDescriptorImpl> map2) {
        if (map2 == null) {
            PluginManagerCore.$$$reportNull$$$0(52);
        }
        for (Map.Entry<String, IdeaPluginDescriptorImpl> entry : ourModulesToContainingPlugins.entrySet()) {
            map2.put(PluginId.getId(entry.getKey()), entry.getValue());
        }
    }

    @NotNull
    private static String reportCycles(@NotNull DFSTBuilder<PluginId> builder, @NotNull Map<PluginId, ? extends IdeaPluginDescriptor> idToDescriptorMap) {
        String cyclePresentation;
        if (builder == null) {
            PluginManagerCore.$$$reportNull$$$0(53);
        }
        if (idToDescriptorMap == null) {
            PluginManagerCore.$$$reportNull$$$0(54);
        }
        List<Collection> cycles = ContainerUtil.filter(builder.getComponents(), c -> c.size() > 1);
        cycles.stream().flatMap(Collection::stream).forEach(id -> ((IdeaPluginDescriptor)idToDescriptorMap.get(id)).setEnabled(false));
        Application app = ApplicationManager.getApplication();
        if (app != null ? app.isInternal() : SystemProperties.is("idea.is.internal")) {
            cyclePresentation = cycles.stream().map(c -> StringUtil.join(c, " ")).collect(Collectors.joining("; "));
        } else {
            Couple<PluginId> loop2 = builder.getCircularDependency();
            cyclePresentation = loop2.first + "->" + loop2.second + "->...->" + loop2.first;
        }
        String string = IdeBundle.message("error.plugins.should.not.have.cyclic.dependencies", new Object[0]) + " " + cyclePresentation;
        if (string == null) {
            PluginManagerCore.$$$reportNull$$$0(55);
        }
        return string;
    }

    @NotNull
    private static Comparator<IdeaPluginDescriptor> getPluginDescriptorComparator(@NotNull DFSTBuilder<PluginId> builder) {
        if (builder == null) {
            PluginManagerCore.$$$reportNull$$$0(56);
        }
        Comparator<PluginId> idComparator = builder.comparator();
        Comparator comparator = (o1, o2) -> {
            PluginId pluginId1 = o1.getPluginId();
            PluginId pluginId2 = o2.getPluginId();
            if (pluginId1.getIdString().equals("org.jetbrains.kotlin.com.intellij")) {
                return -1;
            }
            if (pluginId2.getIdString().equals("org.jetbrains.kotlin.com.intellij")) {
                return 1;
            }
            return idComparator.compare(pluginId1, pluginId2);
        };
        if (comparator == null) {
            PluginManagerCore.$$$reportNull$$$0(57);
        }
        return comparator;
    }

    @NotNull
    private static Graph<PluginId> createPluginIdGraph(final @NotNull Map<PluginId, ? extends IdeaPluginDescriptor> idToDescriptorMap) {
        if (idToDescriptorMap == null) {
            PluginManagerCore.$$$reportNull$$$0(58);
        }
        final ArrayList<PluginId> ids = new ArrayList<PluginId>(idToDescriptorMap.keySet());
        ids.sort((o1, o2) -> o2.getIdString().compareTo(o1.getIdString()));
        Graph<PluginId> graph2 = GraphGenerator.generate(CachingSemiGraph.cache(new InboundSemiGraph<PluginId>(){

            @Override
            @NotNull
            public Collection<PluginId> getNodes() {
                List list2 = ids;
                if (list2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                return list2;
            }

            @Override
            @NotNull
            public Iterator<PluginId> getIn(PluginId pluginId) {
                IdeaPluginDescriptor descriptor2 = (IdeaPluginDescriptor)idToDescriptorMap.get(pluginId);
                ArrayList<PluginId> plugins = new ArrayList<PluginId>();
                for (PluginId dependentPluginId : descriptor2.getDependentPluginIds()) {
                    PluginId realPluginId;
                    IdeaPluginDescriptor dep = (IdeaPluginDescriptor)idToDescriptorMap.get(dependentPluginId);
                    if (dep == null || !idToDescriptorMap.containsKey(realPluginId = dep.getPluginId())) continue;
                    plugins.add(realPluginId);
                }
                Iterator<PluginId> iterator2 = plugins.iterator();
                if (iterator2 == null) {
                    1.$$$reportNull$$$0(1);
                }
                return iterator2;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "org/jetbrains/kotlin/com/intellij/ide/plugins/PluginManagerCore$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getNodes";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getIn";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        }));
        if (graph2 == null) {
            PluginManagerCore.$$$reportNull$$$0(59);
        }
        return graph2;
    }

    @Nullable
    private static IdeaPluginDescriptorImpl loadDescriptorFromDir(@NotNull File file2, @NotNull String pathName, @Nullable File pluginPath, @NotNull LoadingContext loadingContext) {
        File descriptorFile;
        if (file2 == null) {
            PluginManagerCore.$$$reportNull$$$0(60);
        }
        if (pathName == null) {
            PluginManagerCore.$$$reportNull$$$0(61);
        }
        if (loadingContext == null) {
            PluginManagerCore.$$$reportNull$$$0(62);
        }
        if (!(descriptorFile = new File(file2, "META-INF/" + pathName)).exists()) {
            return null;
        }
        try {
            IdeaPluginDescriptorImpl descriptor2 = new IdeaPluginDescriptorImpl(ObjectUtils.notNull(pluginPath, file2), loadingContext.isBundled);
            descriptor2.loadFromFile(descriptorFile, loadingContext.getXmlFactory());
            return descriptor2;
        }
        catch (IOException | XmlSerializationException | JDOMException e) {
            if (loadingContext.isEssential) {
                ExceptionUtil.rethrow(e);
            }
            PluginManagerCore.getLogger().warn("Cannot load " + descriptorFile, e);
            PluginManagerCore.prepareLoadingPluginsErrorMessage(Collections.singletonList("File '" + file2.getName() + "' contains invalid plugin descriptor."));
        }
        catch (Throwable e) {
            if (loadingContext.isEssential) {
                ExceptionUtil.rethrow(e);
            }
            PluginManagerCore.getLogger().warn("Cannot load " + descriptorFile, e);
        }
        return null;
    }

    private static IdeaPluginDescriptorImpl loadDescriptorFromJar(@NotNull File file2, @NotNull String pathName, boolean bundled) {
        if (file2 == null) {
            PluginManagerCore.$$$reportNull$$$0(63);
        }
        if (pathName == null) {
            PluginManagerCore.$$$reportNull$$$0(64);
        }
        try (LoadingContext context2 = new LoadingContext(null, bundled, true);){
            IdeaPluginDescriptorImpl ideaPluginDescriptorImpl = PluginManagerCore.loadDescriptorFromJar(file2, pathName, JDOMXIncluder.DEFAULT_PATH_RESOLVER, context2, null);
            return ideaPluginDescriptorImpl;
        }
    }

    @Nullable
    private static IdeaPluginDescriptorImpl loadDescriptorFromJar(@NotNull File file2, @NotNull String fileName, @NotNull JDOMXIncluder.PathResolver pathResolver, @NotNull LoadingContext context2, @Nullable File pluginPath) {
        if (file2 == null) {
            PluginManagerCore.$$$reportNull$$$0(65);
        }
        if (fileName == null) {
            PluginManagerCore.$$$reportNull$$$0(66);
        }
        if (pathResolver == null) {
            PluginManagerCore.$$$reportNull$$$0(67);
        }
        if (context2 == null) {
            PluginManagerCore.$$$reportNull$$$0(68);
        }
        try {
            String entryName = "META-INF/" + fileName;
            URL jarURL = URLUtil.getJarEntryURL(file2, FileUtil.toCanonicalPath(entryName, '/'));
            ZipFile zipFile2 = context2.open(file2);
            ZipEntry entry = zipFile2.getEntry(entryName);
            if (entry != null) {
                IdeaPluginDescriptorImpl descriptor2 = new IdeaPluginDescriptorImpl(ObjectUtils.notNull(pluginPath, file2), context2.isBundled);
                descriptor2.readExternal(JDOMUtil.load(zipFile2.getInputStream(entry), context2.getXmlFactory()), jarURL, pathResolver);
                context2.myLastZipFileContainingDescriptor = file2;
                return descriptor2;
            }
        }
        catch (InvalidDataException | XmlSerializationException e) {
            if (context2.isEssential) {
                ExceptionUtil.rethrow(e);
            }
            PluginManagerCore.getLogger().info("Cannot load " + file2 + "!/META-INF/" + fileName, e);
            PluginManagerCore.prepareLoadingPluginsErrorMessage(Collections.singletonList("File '" + file2.getName() + "' contains invalid plugin descriptor."));
        }
        catch (Throwable e) {
            if (context2.isEssential) {
                ExceptionUtil.rethrow(e);
            }
            PluginManagerCore.getLogger().info("Cannot load " + file2 + "!/META-INF/" + fileName, e);
        }
        return null;
    }

    @Nullable
    private static IdeaPluginDescriptorImpl loadDescriptor(@NotNull File file2, @NotNull String fileName, boolean bundled, boolean essential, @Nullable LoadDescriptorsContext parentContext) {
        if (file2 == null) {
            PluginManagerCore.$$$reportNull$$$0(71);
        }
        if (fileName == null) {
            PluginManagerCore.$$$reportNull$$$0(72);
        }
        try (LoadingContext context2 = new LoadingContext(parentContext, bundled, essential);){
            IdeaPluginDescriptorImpl ideaPluginDescriptorImpl = PluginManagerCore.loadDescriptor(file2, fileName, context2);
            return ideaPluginDescriptorImpl;
        }
    }

    @Nullable
    private static IdeaPluginDescriptorImpl loadDescriptor(@NotNull File file2, @NotNull String pathName, @NotNull LoadingContext context2) {
        if (file2 == null) {
            PluginManagerCore.$$$reportNull$$$0(73);
        }
        if (pathName == null) {
            PluginManagerCore.$$$reportNull$$$0(74);
        }
        if (context2 == null) {
            PluginManagerCore.$$$reportNull$$$0(75);
        }
        IdeaPluginDescriptorImpl descriptor2 = null;
        boolean isDirectory = file2.isDirectory();
        if (isDirectory) {
            descriptor2 = PluginManagerCore.loadDescriptorFromDir(file2, pathName, null, context2);
            if (descriptor2 == null) {
                File libDir = new File(file2, "lib");
                File[] files2 = libDir.listFiles();
                if (files2 == null || files2.length == 0) {
                    return null;
                }
                PluginManagerCore.putMoreLikelyPluginJarsFirst(file2, files2);
                List<File> pluginJarFiles = null;
                for (File f : files2) {
                    if (f.isDirectory()) {
                        IdeaPluginDescriptorImpl descriptor1 = PluginManagerCore.loadDescriptorFromDir(f, pathName, file2, context2);
                        if (descriptor1 == null) continue;
                        if (descriptor2 != null) {
                            PluginManagerCore.getLogger().info("Cannot load " + file2 + " because two or more plugin.xml's detected");
                            return null;
                        }
                        descriptor2 = descriptor1;
                        continue;
                    }
                    if (!FileUtil.isJarOrZip(f, false)) continue;
                    if (files2.length == 1) {
                        pluginJarFiles = Collections.singletonList(f);
                        continue;
                    }
                    if (pluginJarFiles == null) {
                        pluginJarFiles = new ArrayList<File>();
                    }
                    pluginJarFiles.add(f);
                }
                if (pluginJarFiles != null) {
                    File jarFile;
                    PluginXmlPathResolver pathResolver = new PluginXmlPathResolver(files2);
                    Iterator iterator2 = pluginJarFiles.iterator();
                    while (iterator2.hasNext() && (descriptor2 = PluginManagerCore.loadDescriptorFromJar(jarFile = (File)iterator2.next(), pathName, pathResolver, context2, file2)) == null) {
                    }
                }
            }
        } else if (StringUtilRt.endsWithIgnoreCase(file2.getPath(), ".jar")) {
            descriptor2 = PluginManagerCore.loadDescriptorFromJar(file2, pathName, JDOMXIncluder.DEFAULT_PATH_RESOLVER, context2, null);
        }
        if (descriptor2 == null) {
            return null;
        }
        if ("plugin.xml".equals(pathName) && (descriptor2.getPluginId() == null || descriptor2.getName() == null)) {
            PluginManagerCore.getLogger().info("Cannot load descriptor from " + file2 + ": ID or name missing");
            PluginManagerCore.prepareLoadingPluginsErrorMessage(Collections.singletonList("'" + file2.getName() + "' contains invalid plugin descriptor."));
            return null;
        }
        PluginManagerCore.resolveOptionalDescriptors(pathName, descriptor2, optPathName -> {
            URL resource;
            IdeaPluginDescriptorImpl optionalDescriptor = null;
            if (context2.myLastZipFileContainingDescriptor != null) {
                optionalDescriptor = PluginManagerCore.loadDescriptor(context2.myLastZipFileContainingDescriptor, optPathName, context2);
            }
            if (optionalDescriptor == null) {
                optionalDescriptor = PluginManagerCore.loadDescriptor(file2, optPathName, context2);
            }
            if (optionalDescriptor == null && (isDirectory || PluginManagerCore.resolveDescriptorsInResources()) && (resource = PluginManagerCore.class.getClassLoader().getResource("META-INF/" + optPathName)) != null) {
                optionalDescriptor = PluginManagerCore.loadDescriptorFromResource(resource, optPathName, context2.isBundled, false, context2.myParentContext);
            }
            return optionalDescriptor;
        });
        return descriptor2;
    }

    private static boolean resolveDescriptorsInResources() {
        return System.getProperty("resolve.descriptors.in.resources") != null;
    }

    private static void putMoreLikelyPluginJarsFirst(File pluginDir, File[] filesInLibUnderPluginDir) {
        String pluginDirName = pluginDir.getName();
        Arrays.parallelSort(filesInLibUnderPluginDir, (o1, o2) -> {
            boolean o1StartsWithNeededName;
            boolean o1IsVersioned;
            boolean o1StartsWithResources;
            String o2Name = o2.getName();
            String o1Name = o1.getName();
            boolean o2StartsWithResources = o2Name.startsWith("resources");
            if (o2StartsWithResources != (o1StartsWithResources = o1Name.startsWith("resources"))) {
                return o2StartsWithResources ? -1 : 1;
            }
            boolean o2IsVersioned = PluginManagerCore.fileNameIsLikeVersionedLibraryName(o2Name);
            if (o2IsVersioned != (o1IsVersioned = PluginManagerCore.fileNameIsLikeVersionedLibraryName(o1Name))) {
                return o2IsVersioned ? -1 : 1;
            }
            boolean o2StartsWithNeededName = StringUtil.startsWithIgnoreCase(o2Name, pluginDirName);
            if (o2StartsWithNeededName != (o1StartsWithNeededName = StringUtil.startsWithIgnoreCase(o1Name, pluginDirName))) {
                return o2StartsWithNeededName ? 1 : -1;
            }
            return o1Name.length() - o2Name.length();
        });
    }

    private static boolean fileNameIsLikeVersionedLibraryName(String name2) {
        int i = name2.lastIndexOf(45);
        if (i == -1) {
            return false;
        }
        if (i + 1 < name2.length()) {
            char c = name2.charAt(i + 1);
            if (Character.isDigit(c)) {
                return true;
            }
            if ((c == 'm' || c == 'M') && i + 2 < name2.length() && Character.isDigit(name2.charAt(i + 2))) {
                return true;
            }
        }
        return false;
    }

    private static void resolveOptionalDescriptors(@NotNull String fileName, @NotNull IdeaPluginDescriptorImpl descriptor2, @NotNull Function<? super String, ? extends IdeaPluginDescriptorImpl> optionalDescriptorLoader) {
        Map<PluginId, List<String>> optionalConfigs;
        if (fileName == null) {
            PluginManagerCore.$$$reportNull$$$0(76);
        }
        if (descriptor2 == null) {
            PluginManagerCore.$$$reportNull$$$0(77);
        }
        if (optionalDescriptorLoader == null) {
            PluginManagerCore.$$$reportNull$$$0(78);
        }
        if ((optionalConfigs = descriptor2.getOptionalConfigs()) != null && !optionalConfigs.isEmpty()) {
            LinkedHashMap<PluginId, List<IdeaPluginDescriptorImpl>> descriptors = new LinkedHashMap<PluginId, List<IdeaPluginDescriptorImpl>>(optionalConfigs.size());
            for (Map.Entry<PluginId, List<String>> entry : optionalConfigs.entrySet()) {
                for (String optionalDescriptorName : entry.getValue()) {
                    if (fileName.equals(optionalDescriptorName)) {
                        PluginManagerCore.getLogger().info("recursive dependency (" + fileName + ") in " + descriptor2);
                        continue;
                    }
                    IdeaPluginDescriptorImpl optionalDescriptor = optionalDescriptorLoader.fun(optionalDescriptorName);
                    if (optionalDescriptor == null) {
                        PluginManagerCore.getLogger().info("Cannot find optional descriptor " + optionalDescriptorName);
                        continue;
                    }
                    descriptors.computeIfAbsent(entry.getKey(), it -> new SmartList()).add(optionalDescriptor);
                }
            }
            descriptor2.setOptionalDescriptors(descriptors);
        }
    }

    private static void loadDescriptorsFromDir(@NotNull File dir, @NotNull List<IdeaPluginDescriptorImpl> result2, boolean bundled, @NotNull LoadDescriptorsContext context2) throws ExecutionException, InterruptedException {
        File[] files2;
        if (dir == null) {
            PluginManagerCore.$$$reportNull$$$0(79);
        }
        if (result2 == null) {
            PluginManagerCore.$$$reportNull$$$0(80);
        }
        if (context2 == null) {
            PluginManagerCore.$$$reportNull$$$0(81);
        }
        if ((files2 = dir.listFiles()) == null || files2.length == 0) {
            return;
        }
        THashSet<IdeaPluginDescriptorImpl> existingResults = new THashSet<IdeaPluginDescriptorImpl>(result2);
        ArrayList<Future<IdeaPluginDescriptorImpl>> tasks = new ArrayList<Future<IdeaPluginDescriptorImpl>>(files2.length);
        for (File file2 : files2) {
            tasks.add(context2.getExecutorService().submit(() -> PluginManagerCore.loadDescriptor(file2, "plugin.xml", bundled, false, context2)));
        }
        for (Future future : tasks) {
            IdeaPluginDescriptorImpl descriptor2 = (IdeaPluginDescriptorImpl)future.get();
            if (descriptor2 == null) continue;
            if (existingResults.add(descriptor2)) {
                if (context2.getPluginLoadProgressManager() != null) {
                    context2.getPluginLoadProgressManager().showProgress(descriptor2);
                }
                result2.add(descriptor2);
                continue;
            }
            int oldIndex = result2.indexOf(descriptor2);
            IdeaPluginDescriptorImpl oldDescriptor = result2.get(oldIndex);
            if (VersionComparatorUtil.compare(oldDescriptor.getVersion(), descriptor2.getVersion()) >= 0) continue;
            if (PluginManagerCore.isIncompatible(descriptor2) && PluginManagerCore.isCompatible(oldDescriptor)) {
                PluginManagerCore.getLogger().info("newer plugin is incompatible, ignoring: " + descriptor2.getPath());
                continue;
            }
            result2.set(oldIndex, descriptor2);
        }
    }

    private static void filterBadPlugins(@NotNull List<? extends IdeaPluginDescriptor> result2, @NotNull Map<String, String> disabledPluginNames, @NotNull List<? super String> errors) {
        if (result2 == null) {
            PluginManagerCore.$$$reportNull$$$0(82);
        }
        if (disabledPluginNames == null) {
            PluginManagerCore.$$$reportNull$$$0(83);
        }
        if (errors == null) {
            PluginManagerCore.$$$reportNull$$$0(84);
        }
        THashMap<PluginId, IdeaPluginDescriptor> idToDescriptorMap = new THashMap<PluginId, IdeaPluginDescriptor>();
        boolean pluginsWithoutIdFound = false;
        Iterator<? extends IdeaPluginDescriptor> it = result2.iterator();
        while (it.hasNext()) {
            IdeaPluginDescriptor descriptor2 = it.next();
            PluginId id = descriptor2.getPluginId();
            if (id == null) {
                pluginsWithoutIdFound = true;
                continue;
            }
            if (idToDescriptorMap.containsKey(id)) {
                errors.add(IdeBundle.message("message.duplicate.plugin.id", new Object[0]) + id);
                it.remove();
                continue;
            }
            if (!descriptor2.isEnabled()) continue;
            idToDescriptorMap.put(id, descriptor2);
        }
        PluginManagerCore.addModulesAsDependents(idToDescriptorMap);
        SmartList<String> disabledPluginIds = new SmartList<String>();
        LinkedHashSet faultyDescriptors = new LinkedHashSet();
        Iterator<? extends IdeaPluginDescriptor> it2 = result2.iterator();
        while (it2.hasNext()) {
            IdeaPluginDescriptor pluginDescriptor = it2.next();
            PluginManagerCore.checkDependants(pluginDescriptor, idToDescriptorMap::get, pluginId -> {
                if (!idToDescriptorMap.containsKey(pluginId)) {
                    pluginDescriptor.setEnabled(false);
                    if (!pluginId.getIdString().startsWith("org.jetbrains.kotlin.com.intellij.module")) {
                        boolean disabled;
                        String pluginName;
                        faultyDescriptors.add(pluginId.getIdString());
                        disabledPluginIds.add(pluginDescriptor.getPluginId().getIdString());
                        String name2 = pluginDescriptor.getName();
                        IdeaPluginDescriptor descriptor2 = (IdeaPluginDescriptor)idToDescriptorMap.get(pluginId);
                        if (descriptor2 == null) {
                            pluginName = pluginId.getIdString();
                            if (disabledPluginNames.containsKey(pluginName)) {
                                pluginName = (String)disabledPluginNames.get(pluginName);
                            }
                        } else {
                            pluginName = descriptor2.getName();
                        }
                        errors.add(IdeBundle.message((disabled = PluginManagerCore.getDisabledPlugins().contains(pluginId.getIdString())) ? "error.required.plugin.disabled" : "error.required.plugin.not.installed", name2, pluginName));
                    }
                    it2.remove();
                    return false;
                }
                return true;
            });
        }
        if (!disabledPluginIds.isEmpty()) {
            myPlugins2Disable = disabledPluginIds;
            myPlugins2Enable = faultyDescriptors;
            String error = "<br><a href=\"disable\">Disable ";
            if (disabledPluginIds.size() == 1) {
                PluginId pluginId2Disable = PluginId.getId((String)disabledPluginIds.iterator().next());
                error = error + (idToDescriptorMap.containsKey(pluginId2Disable) ? ((IdeaPluginDescriptor)idToDescriptorMap.get(pluginId2Disable)).getName() : pluginId2Disable.getIdString());
            } else {
                error = error + "not loaded plugins";
            }
            errors.add(error + "</a>");
            boolean possibleToEnable = true;
            for (String descriptor3 : faultyDescriptors) {
                if (disabledPluginNames.get(descriptor3) != null) continue;
                possibleToEnable = false;
                break;
            }
            if (possibleToEnable) {
                String name2 = faultyDescriptors.size() == 1 ? disabledPluginNames.get(faultyDescriptors.iterator().next()) : " all necessary plugins";
                errors.add("<a href=\"enable\">Enable " + name2 + "</a>");
            }
            errors.add("<a href=\"edit\">Open plugin manager</a>");
        }
        if (pluginsWithoutIdFound) {
            errors.add(IdeBundle.message("error.plugins.without.id.found", new Object[0]));
        }
    }

    private static void loadDescriptorsFromClassPath(@NotNull LinkedHashMap<URL, String> urls, @NotNull List<IdeaPluginDescriptorImpl> result2, @NotNull LoadDescriptorsContext context2, @Nullable URL platformPluginURL) throws ExecutionException, InterruptedException {
        if (urls == null) {
            PluginManagerCore.$$$reportNull$$$0(86);
        }
        if (result2 == null) {
            PluginManagerCore.$$$reportNull$$$0(87);
        }
        if (context2 == null) {
            PluginManagerCore.$$$reportNull$$$0(88);
        }
        if (urls.isEmpty()) {
            return;
        }
        ArrayList<Future<IdeaPluginDescriptorImpl>> tasks = new ArrayList<Future<IdeaPluginDescriptorImpl>>(urls.size());
        for (Map.Entry<URL, String> entry : urls.entrySet()) {
            URL uRL = entry.getKey();
            tasks.add(context2.getExecutorService().submit(() -> PluginManagerCore.loadDescriptorFromResource(url, (String)entry.getValue(), true, url.equals(platformPluginURL), context2)));
        }
        THashSet<IdeaPluginDescriptorImpl> existingResults = new THashSet<IdeaPluginDescriptorImpl>(result2);
        for (Future future : tasks) {
            IdeaPluginDescriptorImpl descriptor2 = (IdeaPluginDescriptorImpl)future.get();
            if (descriptor2 == null || !existingResults.add(descriptor2)) continue;
            descriptor2.setUseCoreClassLoader(true);
            result2.add(descriptor2);
            if (context2.getPluginLoadProgressManager() == null || "IDEA CORE".equals(descriptor2.getName())) continue;
            context2.getPluginLoadProgressManager().showProgress(descriptor2);
        }
    }

    @Nullable
    private static URL computePlatformPluginUrlAndCollectPluginUrls(@NotNull ClassLoader loader, @NotNull Map<URL, String> urls) {
        if (loader == null) {
            PluginManagerCore.$$$reportNull$$$0(89);
        }
        if (urls == null) {
            PluginManagerCore.$$$reportNull$$$0(90);
        }
        String platformPrefix = System.getProperty("idea.platform.prefix");
        URL result2 = null;
        if (platformPrefix != null) {
            String fileName = platformPrefix + "Plugin.xml";
            URL resource = loader.getResource("META-INF/" + fileName);
            if (resource != null) {
                urls.put(resource, fileName);
                result2 = resource;
            }
        }
        try {
            Enumeration<URL> enumeration = loader.getResources("META-INF/plugin.xml");
            while (enumeration.hasMoreElements()) {
                urls.put(enumeration.nextElement(), "plugin.xml");
            }
        }
        catch (IOException e) {
            PluginManagerCore.getLogger().info(e);
        }
        return result2;
    }

    @Nullable
    private static IdeaPluginDescriptorImpl loadDescriptorFromResource(@NotNull URL resource, @NotNull String pathName, boolean bundled, boolean essential, @Nullable LoadDescriptorsContext parentContext) {
        if (resource == null) {
            PluginManagerCore.$$$reportNull$$$0(91);
        }
        if (pathName == null) {
            PluginManagerCore.$$$reportNull$$$0(92);
        }
        try {
            if ("file".equals(resource.getProtocol())) {
                File descriptorFile = PluginManagerCore.urlToFile(resource);
                String pathname = StringUtil.trimEnd(FileUtil.toSystemIndependentName(descriptorFile.getPath()), pathName);
                File pluginDir = new File(pathname).getParentFile();
                return PluginManagerCore.loadDescriptor(pluginDir, pathName, bundled, essential, parentContext);
            }
            if ("jar".equals(resource.getProtocol())) {
                String path2 = resource.getFile();
                File pluginJar = PluginManagerCore.urlToFile(new URL(path2.substring(0, path2.indexOf("!/"))));
                return PluginManagerCore.loadDescriptor(pluginJar, pathName, bundled, essential, parentContext);
            }
        }
        catch (Throwable e) {
            if (essential) {
                ExceptionUtil.rethrow(e);
            }
            PluginManagerCore.getLogger().info("Cannot load " + resource, e);
        }
        return null;
    }

    private static File urlToFile(URL url) throws URISyntaxException, MalformedURLException {
        try {
            return new File(url.toURI());
        }
        catch (URISyntaxException e) {
            String str = url.toString();
            if (str.indexOf(32) > 0) {
                return new File(new URL(StringUtil.replace(str, " ", "%20")).toURI());
            }
            throw e;
        }
    }

    private static void loadDescriptorsFromProperty(@NotNull List<? super IdeaPluginDescriptorImpl> result2, @NotNull LoadDescriptorsContext context2) {
        String pathProperty;
        if (result2 == null) {
            PluginManagerCore.$$$reportNull$$$0(93);
        }
        if (context2 == null) {
            PluginManagerCore.$$$reportNull$$$0(94);
        }
        if ((pathProperty = System.getProperty("plugin.path")) == null) {
            return;
        }
        StringTokenizer t = new StringTokenizer(pathProperty, File.pathSeparator + ",");
        while (t.hasMoreTokens()) {
            String s = t.nextToken();
            IdeaPluginDescriptorImpl ideaPluginDescriptor = PluginManagerCore.loadDescriptor(new File(s), "plugin.xml", false, false, context2);
            if (ideaPluginDescriptor == null) continue;
            result2.add(ideaPluginDescriptor);
        }
    }

    @NotNull
    public static IdeaPluginDescriptorImpl[] loadDescriptors(@Nullable StartupProgress progress, @NotNull List<? super String> errors) {
        if (errors == null) {
            PluginManagerCore.$$$reportNull$$$0(95);
        }
        if (ClassUtilCore.isLoadingOfExternalPluginsDisabled()) {
            if (IdeaPluginDescriptorImpl.EMPTY_ARRAY == null) {
                PluginManagerCore.$$$reportNull$$$0(96);
            }
            return IdeaPluginDescriptorImpl.EMPTY_ARRAY;
        }
        ArrayList<IdeaPluginDescriptorImpl> result2 = new ArrayList<IdeaPluginDescriptorImpl>();
        long start = System.currentTimeMillis();
        LinkedHashMap<URL, String> urlsFromClassPath = new LinkedHashMap<URL, String>();
        URL platformPluginURL = PluginManagerCore.computePlatformPluginUrlAndCollectPluginUrls(PluginManagerCore.class.getClassLoader(), urlsFromClassPath);
        PluginLoadProgressManager pluginLoadProgressManager = progress == null ? null : new PluginLoadProgressManager(progress, urlsFromClassPath.size());
        try (LoadDescriptorsContext context2 = new LoadDescriptorsContext(pluginLoadProgressManager, SystemProperties.getBooleanProperty("parallel.pluginDescriptors.loading", true));){
            PluginManagerCore.loadDescriptorsFromDir(new File(PathManager.getPluginsPath()), result2, false, context2);
            Application application = ApplicationManager.getApplication();
            if (application == null || !application.isUnitTestMode()) {
                PluginManagerCore.loadDescriptorsFromDir(new File(PathManager.getPreInstalledPluginsPath()), result2, true, context2);
            }
            PluginManagerCore.loadDescriptorsFromProperty(result2, context2);
            PluginManagerCore.loadDescriptorsFromClassPath(urlsFromClassPath, result2, context2, platformPluginURL);
            if (application != null && application.isUnitTestMode() && result2.size() <= 1) {
                ourUnitTestWithBundledPlugins = true;
                PluginManagerCore.loadDescriptorsFromDir(new File(PathManager.getPreInstalledPluginsPath()), result2, true, context2);
            }
        }
        catch (InterruptedException | ExecutionException e) {
            ExceptionUtilRt.rethrow(e);
        }
        long duration = System.currentTimeMillis() - start;
        PluginManagerCore.getLogger().info("load plugin descriptors took " + duration + " ms");
        IdeaPluginDescriptorImpl[] ideaPluginDescriptorImplArray = PluginManagerCore.topoSortPlugins(result2, errors);
        if (ideaPluginDescriptorImplArray == null) {
            PluginManagerCore.$$$reportNull$$$0(97);
        }
        return ideaPluginDescriptorImplArray;
    }

    @NotNull
    private static IdeaPluginDescriptorImpl[] topoSortPlugins(@NotNull List<IdeaPluginDescriptorImpl> result2, @NotNull List<? super String> errors) {
        if (result2 == null) {
            PluginManagerCore.$$$reportNull$$$0(98);
        }
        if (errors == null) {
            PluginManagerCore.$$$reportNull$$$0(99);
        }
        IdeaPluginDescriptorImpl[] pluginDescriptors = result2.toArray(IdeaPluginDescriptorImpl.EMPTY_ARRAY);
        THashMap<PluginId, IdeaPluginDescriptorImpl> idToDescriptorMap = new THashMap<PluginId, IdeaPluginDescriptorImpl>();
        for (IdeaPluginDescriptorImpl descriptor2 : pluginDescriptors) {
            idToDescriptorMap.put(descriptor2.getPluginId(), descriptor2);
        }
        Graph<PluginId> graph2 = PluginManagerCore.createPluginIdGraph(idToDescriptorMap);
        DFSTBuilder<PluginId> builder = new DFSTBuilder<PluginId>(graph2);
        if (!builder.isAcyclic()) {
            errors.add(PluginManagerCore.reportCycles(builder, idToDescriptorMap));
        }
        Arrays.sort(pluginDescriptors, PluginManagerCore.getPluginDescriptorComparator(builder));
        if (pluginDescriptors == null) {
            PluginManagerCore.$$$reportNull$$$0(100);
        }
        return pluginDescriptors;
    }

    private static void mergeOptionalConfigs(@NotNull Map<PluginId, IdeaPluginDescriptorImpl> descriptors) {
        if (descriptors == null) {
            PluginManagerCore.$$$reportNull$$$0(101);
        }
        THashMap<PluginId, IdeaPluginDescriptorImpl> descriptorsWithModules = new THashMap<PluginId, IdeaPluginDescriptorImpl>(descriptors);
        PluginManagerCore.addModulesAsDependents(descriptorsWithModules);
        for (IdeaPluginDescriptorImpl descriptor2 : descriptors.values()) {
            Map<PluginId, List<IdeaPluginDescriptorImpl>> optionalDescriptors = descriptor2.getOptionalDescriptors();
            if (optionalDescriptors == null || optionalDescriptors.isEmpty()) continue;
            for (Map.Entry<PluginId, List<IdeaPluginDescriptorImpl>> entry : optionalDescriptors.entrySet()) {
                if (!descriptorsWithModules.containsKey(entry.getKey())) continue;
                for (IdeaPluginDescriptorImpl optionalDescriptor : entry.getValue()) {
                    descriptor2.mergeOptionalConfig(optionalDescriptor);
                }
            }
        }
    }

    public static void initClassLoader(@NotNull ClassLoader parentLoader, @NotNull IdeaPluginDescriptorImpl descriptor2) {
        if (parentLoader == null) {
            PluginManagerCore.$$$reportNull$$$0(102);
        }
        if (descriptor2 == null) {
            PluginManagerCore.$$$reportNull$$$0(103);
        }
        List<File> classPath2 = descriptor2.getClassPath();
        ClassLoader loader = PluginManagerCore.createPluginClassLoader(classPath2.toArray(ArrayUtil.EMPTY_FILE_ARRAY), new ClassLoader[]{parentLoader}, descriptor2);
        descriptor2.setLoader(loader);
    }

    static BuildNumber getBuildNumber() {
        return Holder.ourBuildNumber;
    }

    @Nullable
    private static String detectReasonToNotLoad(@NotNull IdeaPluginDescriptor descriptor2, @NotNull IdeaPluginDescriptor[] loaded) {
        String reasonToNotLoad;
        boolean checkModuleDependencies;
        String idString;
        if (descriptor2 == null) {
            PluginManagerCore.$$$reportNull$$$0(104);
        }
        if (loaded == null) {
            PluginManagerCore.$$$reportNull$$$0(105);
        }
        if ("org.jetbrains.kotlin.com.intellij".equals(idString = descriptor2.getPluginId().getIdString())) {
            return null;
        }
        String pluginId = System.getProperty("idea.load.plugins.id");
        List<String> pluginIds = null;
        if (pluginId == null) {
            if (descriptor2 instanceof IdeaPluginDescriptorImpl && !descriptor2.isEnabled()) {
                return "Plugin is not enabled";
            }
            if (!PluginManagerCore.shouldLoadPlugins()) {
                return "Plugins should not be loaded";
            }
        } else {
            pluginIds = StringUtil.split(pluginId, ",");
        }
        boolean bl = checkModuleDependencies = !ourModulesToContainingPlugins.isEmpty() && !ourModulesToContainingPlugins.containsKey("org.jetbrains.kotlin.com.intellij.modules.all");
        if (checkModuleDependencies && !PluginManagerCore.hasModuleDependencies(descriptor2)) {
            return "Plugin does not include any module dependency tags in its plugin.xml therefore is assumed legacy and can be loaded only in IntelliJ IDEA";
        }
        String loadPluginCategory = System.getProperty("idea.load.plugins.category");
        if (loadPluginCategory != null) {
            reasonToNotLoad = loadPluginCategory.equals(descriptor2.getCategory()) ? null : "Plugin category doesn't match 'idea.load.plugins.category' value";
        } else if (pluginIds != null) {
            String string = reasonToNotLoad = pluginIds.contains(idString) ? null : "'idea.load.plugins.id' doesn't contain this plugin id";
            if (reasonToNotLoad != null) {
                THashMap<PluginId, IdeaPluginDescriptor> map2 = new THashMap<PluginId, IdeaPluginDescriptor>();
                for (IdeaPluginDescriptor pluginDescriptor : loaded) {
                    map2.put(pluginDescriptor.getPluginId(), pluginDescriptor);
                }
                PluginManagerCore.addModulesAsDependents(map2);
                for (String id : pluginIds) {
                    IdeaPluginDescriptor descriptorFromProperty = (IdeaPluginDescriptor)map2.get(PluginId.getId(id));
                    if (descriptorFromProperty == null || !PluginManagerCore.isDependent(descriptorFromProperty, descriptor2.getPluginId(), map2, checkModuleDependencies)) continue;
                    reasonToNotLoad = null;
                    break;
                }
            }
        } else {
            String string = reasonToNotLoad = PluginManagerCore.getDisabledPlugins().contains(idString) ? "Plugin is disabled" : null;
        }
        if (reasonToNotLoad == null && descriptor2 instanceof IdeaPluginDescriptorImpl && PluginManagerCore.isIncompatible(descriptor2)) {
            reasonToNotLoad = "Plugin since-build(" + descriptor2.getSinceBuild() + ") or until-build(" + descriptor2.getUntilBuild() + ") don't match this product's build number(" + PluginManagerCore.getBuildNumber() + ").";
        }
        return reasonToNotLoad;
    }

    public static boolean isCompatible(@NotNull IdeaPluginDescriptor descriptor2) {
        if (descriptor2 == null) {
            PluginManagerCore.$$$reportNull$$$0(106);
        }
        return !PluginManagerCore.isIncompatible(descriptor2);
    }

    public static boolean isIncompatible(@NotNull IdeaPluginDescriptor descriptor2) {
        if (descriptor2 == null) {
            PluginManagerCore.$$$reportNull$$$0(108);
        }
        return PluginManagerCore.isIncompatible(descriptor2, PluginManagerCore.getBuildNumber());
    }

    public static boolean isIncompatible(@NotNull IdeaPluginDescriptor descriptor2, @Nullable BuildNumber buildNumber) {
        if (descriptor2 == null) {
            PluginManagerCore.$$$reportNull$$$0(109);
        }
        if (buildNumber == null) {
            buildNumber = PluginManagerCore.getBuildNumber();
        }
        try {
            return PluginManagerCore.isIncompatible(buildNumber, descriptor2.getSinceBuild(), descriptor2.getUntilBuild(), descriptor2.getName(), descriptor2.toString());
        }
        catch (RuntimeException e) {
            PluginManagerCore.getLogger().error(e);
            return false;
        }
    }

    static boolean isIncompatible(@NotNull BuildNumber buildNumber, @Nullable String sinceBuild, @Nullable String untilBuild, @Nullable String descriptorName, @Nullable String descriptorDebugString) {
        BuildNumber untilBuildNumber;
        BuildNumber sinceBuildNumber;
        if (buildNumber == null) {
            PluginManagerCore.$$$reportNull$$$0(110);
        }
        JBIterable<String> messages = JBIterable.empty();
        BuildNumber buildNumber2 = sinceBuildNumber = StringUtil.isEmpty(sinceBuild) ? null : BuildNumber.fromString(sinceBuild, descriptorName, null);
        if (sinceBuildNumber != null && sinceBuildNumber.compareTo(buildNumber) > 0) {
            messages = messages.append("since build " + sinceBuildNumber + " > " + buildNumber);
        }
        BuildNumber buildNumber3 = untilBuildNumber = StringUtil.isEmpty(untilBuild) ? null : BuildNumber.fromString(untilBuild, descriptorName, null);
        if (untilBuildNumber != null && untilBuildNumber.compareTo(buildNumber) < 0) {
            messages = messages.append("until build " + untilBuildNumber + " < " + buildNumber);
        }
        if (messages.isNotEmpty()) {
            PluginManagerCore.getLogger().warn(ObjectUtils.coalesce(descriptorName, descriptorDebugString) + " not loaded: " + StringUtil.join(messages, ", "));
            return true;
        }
        return false;
    }

    private static void checkEssentialPluginsAreAvailable(IdeaPluginDescriptorImpl[] plugins) {
        Set<String> available = ContainerUtil.map2Set(plugins, plugin -> plugin.getPluginId().getIdString());
        List<String> required = ((ApplicationInfoImpl)ApplicationInfoImpl.getShadowInstance()).getEssentialPluginsIds();
        Set<String> missing = JBIterable.from(required).filter(id -> !available.contains(id)).toSet();
        if (!missing.isEmpty()) {
            throw new EssentialPluginMissingException(missing);
        }
    }

    private static void initializePlugins(@Nullable StartupProgress progress) {
        int i;
        PluginManagerCore.configureExtensions();
        ArrayList<String> errors = ContainerUtil.newArrayList();
        IdeaPluginDescriptorImpl[] pluginDescriptors = PluginManagerCore.loadDescriptors(progress, errors);
        PluginManagerCore.checkEssentialPluginsAreAvailable(pluginDescriptors);
        Class callerClass = ReflectionUtil.findCallerClass(1);
        assert (callerClass != null);
        ClassLoader coreLoader = callerClass.getClassLoader();
        final ArrayList<IdeaPluginDescriptorImpl> result2 = new ArrayList<IdeaPluginDescriptorImpl>();
        THashMap<PluginId, IdeaPluginDescriptorImpl> idToDescriptorMap = new THashMap<PluginId, IdeaPluginDescriptorImpl>();
        THashMap<String, String> disabledPluginNames = new THashMap<String, String>();
        SmartList brokenPluginsList = new SmartList();
        PluginManagerCore.fixDescriptors(pluginDescriptors, coreLoader, idToDescriptorMap, disabledPluginNames, brokenPluginsList, result2, errors);
        Graph<PluginId> graph2 = PluginManagerCore.createPluginIdGraph(idToDescriptorMap);
        DFSTBuilder<PluginId> builder = new DFSTBuilder<PluginId>(graph2);
        PluginManagerCore.prepareLoadingPluginsErrorMessage(errors);
        Comparator<PluginId> idComparator = builder.comparator();
        result2.sort((o1, o2) -> idComparator.compare(o1.getPluginId(), o2.getPluginId()));
        for (i = 0; i < result2.size(); ++i) {
            ourId2Index.put(((IdeaPluginDescriptorImpl)result2.get(i)).getPluginId(), i);
        }
        i = 0;
        for (IdeaPluginDescriptorImpl pluginDescriptor : result2) {
            if (pluginDescriptor.getPluginId().getIdString().equals("org.jetbrains.kotlin.com.intellij") || pluginDescriptor.isUseCoreClassLoader()) {
                pluginDescriptor.setLoader(coreLoader);
            } else {
                File[] classPath2 = pluginDescriptor.getClassPath().toArray(ArrayUtil.EMPTY_FILE_ARRAY);
                ClassLoader[] parentLoaders = PluginManagerCore.getParentLoaders(idToDescriptorMap, pluginDescriptor.getDependentPluginIds());
                if (parentLoaders.length == 0) {
                    parentLoaders = new ClassLoader[]{coreLoader};
                }
                pluginDescriptor.setLoader(PluginManagerCore.createPluginClassLoader(classPath2, parentLoaders, pluginDescriptor));
            }
            if (progress == null) continue;
            progress.showProgress("", 0.3f + (float)i++ / (float)result2.size() * 0.35f);
        }
        PluginManagerCore.registerExtensionPointsAndExtensions(Extensions.getRootArea(), result2);
        Extensions.AREA_LISTENER_EXTENSION_POINT.getPoint(null).registerExtension(new AreaListener(){

            @Override
            public void areaCreated(@NotNull String areaClass, @NotNull AreaInstance areaInstance) {
                if (areaClass == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (areaInstance == null) {
                    2.$$$reportNull$$$0(1);
                }
                PluginManagerCore.registerExtensionPointsAndExtensions(Extensions.getArea(areaInstance), result2);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "areaClass";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "areaInstance";
                        break;
                    }
                }
                objectArray[1] = "org/jetbrains/kotlin/com/intellij/ide/plugins/PluginManagerCore$2";
                objectArray[2] = "areaCreated";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        ourLoadedPlugins = Collections.unmodifiableList(result2);
        ourPlugins = pluginDescriptors;
    }

    private static void fixDescriptors(@NotNull IdeaPluginDescriptorImpl[] pluginDescriptors, @NotNull ClassLoader parentLoader, @NotNull Map<PluginId, IdeaPluginDescriptorImpl> idToDescriptorMap, @NotNull Map<String, String> disabledPluginNames, @NotNull List<? super String> brokenPluginsList, @NotNull List<IdeaPluginDescriptorImpl> result2, @NotNull List<? super String> errors) {
        if (pluginDescriptors == null) {
            PluginManagerCore.$$$reportNull$$$0(112);
        }
        if (parentLoader == null) {
            PluginManagerCore.$$$reportNull$$$0(113);
        }
        if (idToDescriptorMap == null) {
            PluginManagerCore.$$$reportNull$$$0(114);
        }
        if (disabledPluginNames == null) {
            PluginManagerCore.$$$reportNull$$$0(115);
        }
        if (brokenPluginsList == null) {
            PluginManagerCore.$$$reportNull$$$0(116);
        }
        if (result2 == null) {
            PluginManagerCore.$$$reportNull$$$0(117);
        }
        if (errors == null) {
            PluginManagerCore.$$$reportNull$$$0(118);
        }
        PluginManagerCore.checkCanLoadPlugins(pluginDescriptors, parentLoader, disabledPluginNames, brokenPluginsList, result2);
        PluginManagerCore.filterBadPlugins(result2, disabledPluginNames, errors);
        if (!brokenPluginsList.isEmpty()) {
            errors.add("The following plugins are incompatible with the current IDE build: " + StringUtil.join(brokenPluginsList, ", "));
        }
        PluginManagerCore.fixDependencies(result2, idToDescriptorMap);
    }

    private static void checkCanLoadPlugins(@NotNull IdeaPluginDescriptorImpl[] pluginDescriptors, @NotNull ClassLoader parentLoader, @NotNull Map<String, String> disabledPluginNames, @NotNull List<? super String> brokenPluginsList, @NotNull List<? super IdeaPluginDescriptorImpl> result2) {
        if (pluginDescriptors == null) {
            PluginManagerCore.$$$reportNull$$$0(119);
        }
        if (parentLoader == null) {
            PluginManagerCore.$$$reportNull$$$0(120);
        }
        if (disabledPluginNames == null) {
            PluginManagerCore.$$$reportNull$$$0(121);
        }
        if (brokenPluginsList == null) {
            PluginManagerCore.$$$reportNull$$$0(122);
        }
        if (result2 == null) {
            PluginManagerCore.$$$reportNull$$$0(123);
        }
        for (IdeaPluginDescriptorImpl descriptor2 : pluginDescriptors) {
            String toNotLoadReason = PluginManagerCore.detectReasonToNotLoad(descriptor2, pluginDescriptors);
            if (toNotLoadReason == null && PluginManagerCore.isBrokenPlugin(descriptor2)) {
                brokenPluginsList.add(descriptor2.getName());
                toNotLoadReason = "This plugin version was marked as incompatible";
            }
            if (toNotLoadReason == null) {
                List<String> modules = descriptor2.getModules();
                for (String module2 : modules) {
                    if (ourModulesToContainingPlugins.containsKey(module2)) continue;
                    ourModulesToContainingPlugins.put(module2, descriptor2);
                }
                result2.add(descriptor2);
                continue;
            }
            descriptor2.setEnabled(false);
            PluginManagerCore.getLogger().info(String.format("Plugin '%s' can't be loaded because: %s", descriptor2.getName(), toNotLoadReason));
            disabledPluginNames.put(descriptor2.getPluginId().getIdString(), descriptor2.getName());
            PluginManagerCore.initClassLoader(parentLoader, descriptor2);
        }
    }

    private static void fixDependencies(@NotNull List<? extends IdeaPluginDescriptorImpl> result2, @NotNull Map<PluginId, IdeaPluginDescriptorImpl> idToDescriptorMap) {
        if (result2 == null) {
            PluginManagerCore.$$$reportNull$$$0(124);
        }
        if (idToDescriptorMap == null) {
            PluginManagerCore.$$$reportNull$$$0(125);
        }
        for (IdeaPluginDescriptorImpl ideaPluginDescriptorImpl : result2) {
            idToDescriptorMap.put(ideaPluginDescriptorImpl.getPluginId(), ideaPluginDescriptorImpl);
        }
        IdeaPluginDescriptor corePluginDescriptor = idToDescriptorMap.get(PluginId.getId("org.jetbrains.kotlin.com.intellij"));
        assert (corePluginDescriptor != null) : "org.jetbrains.kotlin.com.intellij not found; platform prefix is " + System.getProperty("idea.platform.prefix");
        for (IdeaPluginDescriptorImpl ideaPluginDescriptorImpl : result2) {
            if (ideaPluginDescriptorImpl == corePluginDescriptor) continue;
            ideaPluginDescriptorImpl.insertDependency(corePluginDescriptor);
        }
        PluginManagerCore.fixOptionalConfigs(idToDescriptorMap);
        PluginManagerCore.mergeOptionalConfigs(idToDescriptorMap);
        PluginManagerCore.addModulesAsDependents(idToDescriptorMap);
    }

    private static void fixOptionalConfigs(@NotNull Map<PluginId, IdeaPluginDescriptorImpl> idToDescriptorMap) {
        if (idToDescriptorMap == null) {
            PluginManagerCore.$$$reportNull$$$0(126);
        }
        if (!PluginManagerCore.isRunningFromSources()) {
            return;
        }
        for (IdeaPluginDescriptorImpl descriptor2 : idToDescriptorMap.values()) {
            if (!descriptor2.isUseCoreClassLoader() || descriptor2.getOptionalDescriptors() == null) continue;
            descriptor2.getOptionalDescriptors().entrySet().removeIf(entry -> {
                IdeaPluginDescriptorImpl dependent = (IdeaPluginDescriptorImpl)idToDescriptorMap.get(entry.getKey());
                return dependent != null && !dependent.isUseCoreClassLoader();
            });
        }
    }

    private static void registerExtensionPointsAndExtensions(@NotNull ExtensionsArea area, @NotNull List<? extends IdeaPluginDescriptorImpl> loadedPlugins) {
        if (area == null) {
            PluginManagerCore.$$$reportNull$$$0(127);
        }
        if (loadedPlugins == null) {
            PluginManagerCore.$$$reportNull$$$0(128);
        }
        for (IdeaPluginDescriptorImpl ideaPluginDescriptorImpl : loadedPlugins) {
            ideaPluginDescriptorImpl.registerExtensionPoints(area);
        }
        ExtensionPoint[] extensionPoints = area.getExtensionPoints();
        for (IdeaPluginDescriptorImpl ideaPluginDescriptorImpl : loadedPlugins) {
            for (ExtensionPoint extensionPoint : extensionPoints) {
                ideaPluginDescriptorImpl.registerExtensions(area, extensionPoint);
            }
        }
    }

    public static void registerExtensionPointAndExtensions(@NotNull File pluginRoot2, @NotNull String fileName, @NotNull ExtensionsArea area) {
        IdeaPluginDescriptorImpl descriptor2;
        if (pluginRoot2 == null) {
            PluginManagerCore.$$$reportNull$$$0(129);
        }
        if (fileName == null) {
            PluginManagerCore.$$$reportNull$$$0(130);
        }
        if (area == null) {
            PluginManagerCore.$$$reportNull$$$0(131);
        }
        if (pluginRoot2.isDirectory()) {
            try (LoadingContext context2 = new LoadingContext(null, true, true);){
                descriptor2 = PluginManagerCore.loadDescriptorFromDir(pluginRoot2, fileName, null, context2);
            }
        } else {
            descriptor2 = PluginManagerCore.loadDescriptorFromJar(pluginRoot2, fileName, true);
        }
        if (descriptor2 != null) {
            PluginManagerCore.registerExtensionPointsAndExtensions(area, Collections.singletonList(descriptor2));
        } else {
            PluginManagerCore.getLogger().error("Cannot load " + fileName + " from " + pluginRoot2);
        }
    }

    private static void initPlugins(@Nullable StartupProgress progress) {
        long start = System.currentTimeMillis();
        try {
            PluginManagerCore.initializePlugins(progress);
        }
        catch (PicoPluginExtensionInitializationException e) {
            throw new PluginException(e, e.getPluginId());
        }
        catch (RuntimeException e) {
            PluginManagerCore.getLogger().error(e);
            throw e;
        }
        PluginManagerCore.getLogger().info(ourPlugins.length + " plugins initialized in " + (System.currentTimeMillis() - start) + " ms");
        PluginManagerCore.logPlugins();
        ClassUtilCore.clearJarURLCache();
    }

    @NotNull
    public static Logger getLogger() {
        Logger logger = Logger.getInstance("#com.intellij.ide.plugins.PluginManager");
        if (logger == null) {
            PluginManagerCore.$$$reportNull$$$0(132);
        }
        return logger;
    }

    static {
        ourId2Index = new TObjectIntHashMap();
        ourModulesToContainingPlugins = new THashMap<String, IdeaPluginDescriptorImpl>();
        ourPluginClasses = new PluginClassCache();
        ourUnitTestWithBundledPlugins = SystemProperties.getBooleanProperty("idea.run.tests.with.bundled.plugins", false);
        ourDisabledPluginsListeners = new CopyOnWriteArrayList<Runnable>();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 56: 
            case 58: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 98: 
            case 99: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 124: 
            case 125: 
            case 126: 
            case 127: 
            case 128: 
            case 129: 
            case 130: 
            case 131: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 56: 
            case 58: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 98: 
            case 99: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 124: 
            case 125: 
            case 126: 
            case 127: 
            case 128: 
            case 129: 
            case 130: 
            case 131: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/ide/plugins/PluginManagerCore";
                break;
            }
            case 3: 
            case 101: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptors";
                break;
            }
            case 4: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configPath";
                break;
            }
            case 5: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disabledPlugins";
                break;
            }
            case 7: 
            case 37: 
            case 40: 
            case 77: 
            case 103: 
            case 104: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 111: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 11: 
            case 13: 
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ids";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "plugins";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "writer";
                break;
            }
            case 15: 
            case 16: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependentPluginId";
                break;
            }
            case 23: 
            case 26: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginDescriptor";
                break;
            }
            case 24: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginId2Descriptor";
                break;
            }
            case 25: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "check";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processed";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginId";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorMessage";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginClass";
                break;
            }
            case 34: 
            case 35: 
            case 36: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "className";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "on";
                break;
            }
            case 39: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 41: 
            case 85: 
            case 89: {
                objectArray2 = objectArray3;
                objectArray3[0] = "loader";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classPath";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentLoaders";
                break;
            }
            case 47: 
            case 54: 
            case 58: 
            case 114: 
            case 125: 
            case 126: {
                objectArray2 = objectArray3;
                objectArray3[0] = "idToDescriptorMap";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginIds";
                break;
            }
            case 51: 
            case 84: 
            case 95: 
            case 99: 
            case 118: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errors";
                break;
            }
            case 53: 
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 60: 
            case 63: 
            case 65: 
            case 69: 
            case 71: 
            case 73: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 61: 
            case 64: 
            case 74: 
            case 92: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathName";
                break;
            }
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "loadingContext";
                break;
            }
            case 66: 
            case 70: 
            case 72: 
            case 76: 
            case 130: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathResolver";
                break;
            }
            case 68: 
            case 75: 
            case 81: 
            case 88: 
            case 94: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 78: {
                objectArray2 = objectArray3;
                objectArray3[0] = "optionalDescriptorLoader";
                break;
            }
            case 79: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 80: 
            case 82: 
            case 87: 
            case 93: 
            case 98: 
            case 117: 
            case 123: 
            case 124: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 83: 
            case 115: 
            case 121: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disabledPluginNames";
                break;
            }
            case 86: 
            case 90: {
                objectArray2 = objectArray3;
                objectArray3[0] = "urls";
                break;
            }
            case 91: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resource";
                break;
            }
            case 102: 
            case 113: 
            case 120: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentLoader";
                break;
            }
            case 105: {
                objectArray2 = objectArray3;
                objectArray3[0] = "loaded";
                break;
            }
            case 110: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildNumber";
                break;
            }
            case 112: 
            case 119: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginDescriptors";
                break;
            }
            case 116: 
            case 122: {
                objectArray2 = objectArray3;
                objectArray3[0] = "brokenPluginsList";
                break;
            }
            case 127: 
            case 131: {
                objectArray2 = objectArray3;
                objectArray3[0] = "area";
                break;
            }
            case 128: {
                objectArray2 = objectArray3;
                objectArray3[0] = "loadedPlugins";
                break;
            }
            case 129: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginRoot";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getPlugins";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getLoadedPlugins";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 56: 
            case 58: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 98: 
            case 99: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 124: 
            case 125: 
            case 126: 
            case 127: 
            case 128: 
            case 129: 
            case 130: 
            case 131: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/ide/plugins/PluginManagerCore";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisabledPlugins";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getBrokenPluginVersions";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "createPluginException";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "getAddUrlMethod";
                break;
            }
            case 49: 
            case 50: {
                objectArray = objectArray2;
                objectArray2[1] = "getParentLoaders";
                break;
            }
            case 55: {
                objectArray = objectArray2;
                objectArray2[1] = "reportCycles";
                break;
            }
            case 57: {
                objectArray = objectArray2;
                objectArray2[1] = "getPluginDescriptorComparator";
                break;
            }
            case 59: {
                objectArray = objectArray2;
                objectArray2[1] = "createPluginIdGraph";
                break;
            }
            case 96: 
            case 97: {
                objectArray = objectArray2;
                objectArray2[1] = "loadDescriptors";
                break;
            }
            case 100: {
                objectArray = objectArray2;
                objectArray2[1] = "topoSortPlugins";
                break;
            }
            case 132: {
                objectArray = objectArray2;
                objectArray2[1] = "getLogger";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setPlugins";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "loadDisabledPlugins";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isBrokenPlugin";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "addDisablePluginListener";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "removeDisablePluginListener";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "savePluginsList";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "writePluginsList";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "disablePlugin";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "enablePlugin";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "trySaveDisabledPlugins";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "saveDisabledPlugins";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getPluginLoadingOrder";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "isModuleDependency";
                break;
            }
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "checkDependants";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "addPluginClass";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "createPluginException";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "getPluginByClassName";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "getPluginOrPlatformByClassName";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "hasLoadedClass";
                break;
            }
            case 37: 
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "isDependent";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "hasModuleDependencies";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "getAddUrlMethod";
                break;
            }
            case 43: 
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "createPluginClassLoader";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "isPluginClass";
                break;
            }
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "getParentLoaders";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "prepareLoadingPluginsErrorMessage";
                break;
            }
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "addModulesAsDependents";
                break;
            }
            case 53: 
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "reportCycles";
                break;
            }
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "getPluginDescriptorComparator";
                break;
            }
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "createPluginIdGraph";
                break;
            }
            case 60: 
            case 61: 
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "loadDescriptorFromDir";
                break;
            }
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "loadDescriptorFromJar";
                break;
            }
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: {
                objectArray = objectArray;
                objectArray[2] = "loadDescriptor";
                break;
            }
            case 76: 
            case 77: 
            case 78: {
                objectArray = objectArray;
                objectArray[2] = "resolveOptionalDescriptors";
                break;
            }
            case 79: 
            case 80: 
            case 81: {
                objectArray = objectArray;
                objectArray[2] = "loadDescriptorsFromDir";
                break;
            }
            case 82: 
            case 83: 
            case 84: {
                objectArray = objectArray;
                objectArray[2] = "filterBadPlugins";
                break;
            }
            case 85: {
                objectArray = objectArray;
                objectArray[2] = "testLoadDescriptorsFromClassPath";
                break;
            }
            case 86: 
            case 87: 
            case 88: {
                objectArray = objectArray;
                objectArray[2] = "loadDescriptorsFromClassPath";
                break;
            }
            case 89: 
            case 90: {
                objectArray = objectArray;
                objectArray[2] = "computePlatformPluginUrlAndCollectPluginUrls";
                break;
            }
            case 91: 
            case 92: {
                objectArray = objectArray;
                objectArray[2] = "loadDescriptorFromResource";
                break;
            }
            case 93: 
            case 94: {
                objectArray = objectArray;
                objectArray[2] = "loadDescriptorsFromProperty";
                break;
            }
            case 95: {
                objectArray = objectArray;
                objectArray[2] = "loadDescriptors";
                break;
            }
            case 98: 
            case 99: {
                objectArray = objectArray;
                objectArray[2] = "topoSortPlugins";
                break;
            }
            case 101: {
                objectArray = objectArray;
                objectArray[2] = "mergeOptionalConfigs";
                break;
            }
            case 102: 
            case 103: {
                objectArray = objectArray;
                objectArray[2] = "initClassLoader";
                break;
            }
            case 104: 
            case 105: {
                objectArray = objectArray;
                objectArray[2] = "detectReasonToNotLoad";
                break;
            }
            case 106: 
            case 107: {
                objectArray = objectArray;
                objectArray[2] = "isCompatible";
                break;
            }
            case 108: 
            case 109: 
            case 110: {
                objectArray = objectArray;
                objectArray[2] = "isIncompatible";
                break;
            }
            case 111: {
                objectArray = objectArray;
                objectArray[2] = "shouldSkipPlugin";
                break;
            }
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 118: {
                objectArray = objectArray;
                objectArray[2] = "fixDescriptors";
                break;
            }
            case 119: 
            case 120: 
            case 121: 
            case 122: 
            case 123: {
                objectArray = objectArray;
                objectArray[2] = "checkCanLoadPlugins";
                break;
            }
            case 124: 
            case 125: {
                objectArray = objectArray;
                objectArray[2] = "fixDependencies";
                break;
            }
            case 126: {
                objectArray = objectArray;
                objectArray[2] = "fixOptionalConfigs";
                break;
            }
            case 127: 
            case 128: {
                objectArray = objectArray;
                objectArray[2] = "registerExtensionPointsAndExtensions";
                break;
            }
            case 129: 
            case 130: 
            case 131: {
                objectArray = objectArray;
                objectArray[2] = "registerExtensionPointAndExtensions";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 56: 
            case 58: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 98: 
            case 99: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 124: 
            case 125: 
            case 126: 
            case 127: 
            case 128: 
            case 129: 
            case 130: 
            case 131: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class EssentialPluginMissingException
    extends RuntimeException {
        final Set<String> pluginIds;

        EssentialPluginMissingException(@NotNull Set<String> ids) {
            if (ids == null) {
                EssentialPluginMissingException.$$$reportNull$$$0(0);
            }
            super("Missing essential plugins: " + StringUtil.join(ids, ", "));
            this.pluginIds = ids;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ids", "org/jetbrains/kotlin/com/intellij/ide/plugins/PluginManagerCore$EssentialPluginMissingException", "<init>"));
        }
    }

    private static class LoadingContext
    implements AutoCloseable {
        private final Map<File, ZipFile> myOpenedFiles = new THashMap<File, ZipFile>();
        private File myLastZipFileContainingDescriptor;
        @Nullable
        private final LoadDescriptorsContext myParentContext;
        final boolean isBundled;
        final boolean isEssential;

        LoadingContext(@Nullable LoadDescriptorsContext parentContext, boolean isBundled, boolean isEssential) {
            this.myParentContext = parentContext;
            this.isBundled = isBundled;
            this.isEssential = isEssential;
        }

        private ZipFile open(File file2) throws IOException {
            ZipFile zipFile2 = this.myOpenedFiles.get(file2);
            if (zipFile2 == null) {
                zipFile2 = new ZipFile(file2);
                this.myOpenedFiles.put(file2, zipFile2);
            }
            return zipFile2;
        }

        @Override
        public void close() {
            for (ZipFile file2 : this.myOpenedFiles.values()) {
                try {
                    file2.close();
                }
                catch (IOException iOException) {}
            }
        }

        @Nullable
        public SafeJdomFactory getXmlFactory() {
            if (this.myParentContext == null) {
                return null;
            }
            return this.myParentContext.getXmlFactory();
        }
    }

    private static class Holder {
        private static final BuildNumber ourBuildNumber = Holder.calcBuildNumber();
        private static final boolean ourIsRunningFromSources = new File(PathManager.getHomePath(), ".idea").isDirectory();

        private static BuildNumber calcBuildNumber() {
            BuildNumber ourBuildNumber = BuildNumber.fromString(System.getProperty("idea.plugins.compatible.build"));
            if (ourBuildNumber == null) {
                BuildNumber buildNumber = ourBuildNumber = BUILD_NUMBER == null ? null : BuildNumber.fromString(BUILD_NUMBER);
                if (ourBuildNumber == null) {
                    ourBuildNumber = BuildNumber.currentVersion();
                }
            }
            return ourBuildNumber;
        }
    }
}

