/*
 * Decompiled with CFR 0.152.
 */
package gnu.trove;

import gnu.trove.HashFunctions;
import gnu.trove.SerializationProcedure;
import gnu.trove.TDoubleFunction;
import gnu.trove.TDoubleProcedure;
import gnu.trove.TFloatDoubleIterator;
import gnu.trove.TFloatDoubleProcedure;
import gnu.trove.TFloatHash;
import gnu.trove.TFloatHashingStrategy;
import gnu.trove.TFloatProcedure;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class TFloatDoubleHashMap
extends TFloatHash {
    protected transient double[] _values;

    public TFloatDoubleHashMap() {
    }

    public TFloatDoubleHashMap(int initialCapacity) {
        super(initialCapacity);
    }

    public TFloatDoubleHashMap(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
    }

    public TFloatDoubleHashMap(TFloatHashingStrategy strategy) {
        super(strategy);
    }

    public TFloatDoubleHashMap(int initialCapacity, TFloatHashingStrategy strategy) {
        super(initialCapacity, strategy);
    }

    public TFloatDoubleHashMap(int initialCapacity, float loadFactor, TFloatHashingStrategy strategy) {
        super(initialCapacity, loadFactor, strategy);
    }

    public Object clone() {
        TFloatDoubleHashMap m = (TFloatDoubleHashMap)super.clone();
        m._values = this._values == null ? null : (double[])this._values.clone();
        return m;
    }

    public TFloatDoubleIterator iterator() {
        return new TFloatDoubleIterator(this);
    }

    protected int setUp(int initialCapacity) {
        int capacity = super.setUp(initialCapacity);
        this._values = initialCapacity == -1 ? null : new double[capacity];
        return capacity;
    }

    public double put(float key, double value) {
        double previous = 0.0;
        int index2 = this.insertionIndex(key);
        boolean isNewMapping = true;
        if (index2 < 0) {
            index2 = -index2 - 1;
            previous = this._values[index2];
            isNewMapping = false;
        }
        byte previousState = this._states[index2];
        this._set[index2] = key;
        this._states[index2] = 1;
        this._values[index2] = value;
        if (isNewMapping) {
            this.postInsertHook(previousState == 0);
        }
        return previous;
    }

    protected void rehash(int newCapacity) {
        int oldCapacity = this.capacity();
        float[] oldKeys = this._set;
        double[] oldVals = this._values;
        byte[] oldStates = this._states;
        this._set = new float[newCapacity];
        this._values = new double[newCapacity];
        this._states = new byte[newCapacity];
        int i = oldCapacity;
        while (i-- > 0) {
            if (oldStates[i] != 1) continue;
            float o = oldKeys[i];
            int index2 = this.insertionIndex(o);
            this._set[index2] = o;
            this._values[index2] = oldVals[i];
            this._states[index2] = 1;
        }
    }

    public double get(float key) {
        int index2 = this.index(key);
        return index2 < 0 ? 0.0 : this._values[index2];
    }

    public void clear() {
        super.clear();
        float[] keys2 = this._set;
        double[] vals = this._values;
        if (vals == null) {
            return;
        }
        byte[] states = this._states;
        int i = keys2.length;
        while (i-- > 0) {
            keys2[i] = 0.0f;
            vals[i] = 0.0;
            states[i] = 0;
        }
    }

    public double remove(float key) {
        double prev = 0.0;
        int index2 = this.index(key);
        if (index2 >= 0) {
            prev = this._values[index2];
            this.removeAt(index2);
        }
        return prev;
    }

    public boolean equals(Object other) {
        if (!(other instanceof TFloatDoubleHashMap)) {
            return false;
        }
        TFloatDoubleHashMap that = (TFloatDoubleHashMap)other;
        if (that.size() != this.size()) {
            return false;
        }
        return this.forEachEntry(new EqProcedure(that));
    }

    public int hashCode() {
        HashProcedure p = new HashProcedure();
        this.forEachEntry(p);
        return p.getHashCode();
    }

    protected void removeAt(int index2) {
        this._values[index2] = 0.0;
        super.removeAt(index2);
    }

    public double[] getValues() {
        double[] vals = new double[this.size()];
        double[] v = this._values;
        byte[] states = this._states;
        if (states != null) {
            int i = states.length;
            int j = 0;
            while (i-- > 0) {
                if (states[i] != 1) continue;
                vals[j++] = v[i];
            }
        }
        return vals;
    }

    public float[] keys() {
        float[] keys2 = new float[this.size()];
        float[] k = this._set;
        byte[] states = this._states;
        if (states != null) {
            int i = states.length;
            int j = 0;
            while (i-- > 0) {
                if (states[i] != 1) continue;
                keys2[j++] = k[i];
            }
        }
        return keys2;
    }

    public boolean containsValue(double val) {
        byte[] states = this._states;
        double[] vals = this._values;
        if (states != null) {
            int i = states.length;
            while (i-- > 0) {
                if (states[i] != 1 || val != vals[i]) continue;
                return true;
            }
        }
        return false;
    }

    public boolean containsKey(float key) {
        return this.contains(key);
    }

    public boolean forEachKey(TFloatProcedure procedure) {
        return this.forEach(procedure);
    }

    public boolean forEachValue(TDoubleProcedure procedure) {
        byte[] states = this._states;
        double[] values2 = this._values;
        if (states != null) {
            int i = states.length;
            while (i-- > 0) {
                if (states[i] != 1 || procedure.execute(values2[i])) continue;
                return false;
            }
        }
        return true;
    }

    public boolean forEachEntry(TFloatDoubleProcedure procedure) {
        byte[] states = this._states;
        float[] keys2 = this._set;
        double[] values2 = this._values;
        if (states != null) {
            int i = states.length;
            while (i-- > 0) {
                if (states[i] != 1 || procedure.execute(keys2[i], values2[i])) continue;
                return false;
            }
        }
        return true;
    }

    public boolean retainEntries(TFloatDoubleProcedure procedure) {
        boolean modified = false;
        byte[] states = this._states;
        float[] keys2 = this._set;
        double[] values2 = this._values;
        if (states != null) {
            int i = states.length;
            while (i-- > 0) {
                if (states[i] != 1 || procedure.execute(keys2[i], values2[i])) continue;
                this.removeAt(i);
                modified = true;
            }
        }
        return modified;
    }

    public void transformValues(TDoubleFunction function2) {
        byte[] states = this._states;
        double[] values2 = this._values;
        if (states != null) {
            int i = states.length;
            while (i-- > 0) {
                if (states[i] != 1) continue;
                values2[i] = function2.execute(values2[i]);
            }
        }
    }

    public boolean increment(float key) {
        return this.adjustValue(key, 1.0);
    }

    public boolean adjustValue(float key, double amount) {
        int index2 = this.index(key);
        if (index2 < 0) {
            return false;
        }
        int n = index2;
        this._values[n] = this._values[n] + amount;
        return true;
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        stream.writeInt(this._size);
        SerializationProcedure writeProcedure = new SerializationProcedure(stream);
        if (!this.forEachEntry(writeProcedure)) {
            throw writeProcedure.exception;
        }
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        int size = stream.readInt();
        this.setUp(size);
        while (size-- > 0) {
            float key = stream.readFloat();
            double val = stream.readDouble();
            this.put(key, val);
        }
    }

    public String toString() {
        final StringBuilder sb = new StringBuilder();
        this.forEachEntry(new TFloatDoubleProcedure(){

            public boolean execute(float key, double value) {
                if (sb.length() != 0) {
                    sb.append(',').append(' ');
                }
                sb.append(key);
                sb.append('=');
                sb.append(value);
                return true;
            }
        });
        sb.append('}');
        sb.insert(0, '{');
        return sb.toString();
    }

    private static final class EqProcedure
    implements TFloatDoubleProcedure {
        private final TFloatDoubleHashMap _otherMap;

        EqProcedure(TFloatDoubleHashMap otherMap) {
            this._otherMap = otherMap;
        }

        public final boolean execute(float key, double value) {
            int index2 = this._otherMap.index(key);
            return index2 >= 0 && EqProcedure.eq(value, this._otherMap.get(key));
        }

        private static boolean eq(double v1, double v2) {
            return v1 == v2;
        }
    }

    private final class HashProcedure
    implements TFloatDoubleProcedure {
        private int h;

        HashProcedure() {
        }

        public int getHashCode() {
            return this.h;
        }

        public final boolean execute(float key, double value) {
            this.h += TFloatDoubleHashMap.this._hashingStrategy.computeHashCode(key) ^ HashFunctions.hash(value);
            return true;
        }
    }
}

