/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.notebook.repo;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.fs.Path;
import org.apache.zeppelin.conf.ZeppelinConfiguration;
import org.apache.zeppelin.notebook.FileSystemStorage;
import org.apache.zeppelin.notebook.Note;
import org.apache.zeppelin.notebook.NoteInfo;
import org.apache.zeppelin.notebook.repo.NotebookRepo;
import org.apache.zeppelin.notebook.repo.NotebookRepoSettingsInfo;
import org.apache.zeppelin.user.AuthenticationInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileSystemNotebookRepo
implements NotebookRepo {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileSystemNotebookRepo.class);
    private FileSystemStorage fs;
    private Path notebookDir;

    public void init(ZeppelinConfiguration zConf) throws IOException {
        this.fs = new FileSystemStorage(zConf, zConf.getString(ZeppelinConfiguration.ConfVars.ZEPPELIN_NOTEBOOK_DIR));
        LOGGER.info("Creating FileSystem: {}", (Object)this.fs.getFs().getClass().getName());
        this.notebookDir = this.fs.makeQualified(new Path(zConf.getNotebookDir()));
        LOGGER.info("Using folder {} to store notebook", (Object)this.notebookDir);
        this.fs.tryMkDir(this.notebookDir);
    }

    public Map<String, NoteInfo> list(AuthenticationInfo subject) throws IOException {
        List notePaths = this.fs.listAll(this.notebookDir);
        HashMap<String, NoteInfo> noteInfos = new HashMap<String, NoteInfo>();
        for (Path path : notePaths) {
            try {
                NoteInfo noteInfo = new NoteInfo(this.getNoteId(path.getName()), this.getNotePath(this.notebookDir.toString(), path.toString()));
                noteInfos.put(noteInfo.getId(), noteInfo);
            }
            catch (IOException e) {
                LOGGER.warn("Fail to get NoteInfo for note: {}", (Object)path.getName(), (Object)e);
            }
        }
        return noteInfos;
    }

    public Note get(String noteId, String notePath, AuthenticationInfo subject) throws IOException {
        String content = this.fs.readFile(new Path(this.notebookDir, this.buildNoteFileName(noteId, notePath)));
        return Note.fromJson((String)noteId, (String)content);
    }

    public void save(Note note, AuthenticationInfo subject) throws IOException {
        this.fs.writeFile(note.toJson(), new Path(this.notebookDir, this.buildNoteFileName(note.getId(), note.getPath())), true);
    }

    public void move(String noteId, String notePath, String newNotePath, AuthenticationInfo subject) throws IOException {
        Path src = new Path(this.notebookDir, this.buildNoteFileName(noteId, notePath));
        Path dest = new Path(this.notebookDir, this.buildNoteFileName(noteId, newNotePath));
        this.fs.tryMkDir(new Path(this.notebookDir, newNotePath.substring(1)).getParent());
        this.fs.move(src, dest);
    }

    public void move(String folderPath, String newFolderPath, AuthenticationInfo subject) throws IOException {
        this.fs.tryMkDir(new Path(this.notebookDir, folderPath.substring(1)).getParent());
        this.fs.move(new Path(this.notebookDir, folderPath.substring(1)), new Path(this.notebookDir, newFolderPath.substring(1)));
    }

    public void remove(String noteId, String notePath, AuthenticationInfo subject) throws IOException {
        if (!this.fs.delete(new Path(this.notebookDir.toString(), this.buildNoteFileName(noteId, notePath)))) {
            LOGGER.warn("Fail to move note, noteId: {}, notePath: {}", (Object)notePath, (Object)notePath);
        }
    }

    public void remove(String folderPath, AuthenticationInfo subject) throws IOException {
        if (!this.fs.delete(new Path(this.notebookDir, folderPath.substring(1)))) {
            LOGGER.warn("Fail to remove folder: {}", (Object)folderPath);
        }
    }

    public void close() {
        LOGGER.warn("close is not implemented for FileSystemNotebookRepo");
    }

    public List<NotebookRepoSettingsInfo> getSettings(AuthenticationInfo subject) {
        LOGGER.warn("getSettings is not implemented for FileSystemNotebookRepo");
        return null;
    }

    public void updateSettings(Map<String, String> settings, AuthenticationInfo subject) {
        LOGGER.warn("updateSettings is not implemented for FileSystemNotebookRepo");
    }
}

