/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.jdbc.hive;

import java.io.PrintStream;
import java.util.List;
import org.apache.hadoop.hive.common.log.InPlaceUpdate;
import org.apache.hadoop.hive.common.log.ProgressMonitor;
import org.apache.hive.jdbc.logs.InPlaceUpdateStream;
import org.apache.hive.service.rpc.thrift.TJobExecutionStatus;
import org.apache.hive.service.rpc.thrift.TProgressUpdateResp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BeelineInPlaceUpdateStream
implements InPlaceUpdateStream {
    private static final Logger LOGGER = LoggerFactory.getLogger(BeelineInPlaceUpdateStream.class);
    private InPlaceUpdate inPlaceUpdate;
    private InPlaceUpdateStream.EventNotifier notifier;
    private long lastUpdateTimestamp;

    public BeelineInPlaceUpdateStream(PrintStream out, InPlaceUpdateStream.EventNotifier notifier) {
        this.inPlaceUpdate = new InPlaceUpdate(out);
        this.notifier = notifier;
    }

    public void update(TProgressUpdateResp response) {
        if (response == null || response.getStatus().equals((Object)TJobExecutionStatus.NOT_AVAILABLE)) {
            this.notifier.progressBarCompleted();
        } else if (this.notifier.isOperationLogUpdatedAtLeastOnce()) {
            this.lastUpdateTimestamp = System.currentTimeMillis();
            LOGGER.info("update progress: " + response.getProgressedPercentage());
            this.inPlaceUpdate.render((ProgressMonitor)new ProgressMonitorWrapper(response));
        }
    }

    public long getLastUpdateTimestamp() {
        return this.lastUpdateTimestamp;
    }

    public InPlaceUpdateStream.EventNotifier getEventNotifier() {
        return this.notifier;
    }

    static class ProgressMonitorWrapper
    implements ProgressMonitor {
        private TProgressUpdateResp response;

        ProgressMonitorWrapper(TProgressUpdateResp response) {
            this.response = response;
        }

        public List<String> headers() {
            return this.response.getHeaderNames();
        }

        public List<List<String>> rows() {
            return this.response.getRows();
        }

        public String footerSummary() {
            return this.response.getFooterSummary();
        }

        public long startTime() {
            return this.response.getStartTime();
        }

        public String executionStatus() {
            throw new UnsupportedOperationException("This should never be used for anything. All the required data is available via other methods");
        }

        public double progressedPercentage() {
            return this.response.getProgressedPercentage();
        }
    }
}

