/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.engine.join;

import org.apache.jena.atlas.logging.Log;
import org.apache.jena.sparql.engine.ExecutionContext;
import org.apache.jena.sparql.engine.QueryIterator;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.iterator.QueryIterNullIterator;
import org.apache.jena.sparql.engine.join.AbstractIterHashJoin;
import org.apache.jena.sparql.engine.join.JoinKey;
import org.apache.jena.sparql.expr.ExprList;

public class QueryIterHashLeftJoin_Right
extends AbstractIterHashJoin {
    private final ExprList conditions;

    public static QueryIterator create(JoinKey joinKey, QueryIterator left, QueryIterator right, ExprList conditions, ExecutionContext execCxt) {
        if (!left.hasNext()) {
            left.close();
            right.close();
            return QueryIterNullIterator.create(execCxt);
        }
        if (!right.hasNext()) {
            right.close();
            return left;
        }
        if (joinKey != null && joinKey.length() > 1) {
            Log.warn(QueryIterHashLeftJoin_Right.class, "Multivariable join key");
        }
        return new QueryIterHashLeftJoin_Right(joinKey, left, right, conditions, execCxt);
    }

    public static QueryIterator create(QueryIterator left, QueryIterator right, ExprList conditions, ExecutionContext execCxt) {
        return QueryIterHashLeftJoin_Right.create(null, left, right, conditions, execCxt);
    }

    private QueryIterHashLeftJoin_Right(JoinKey joinKey, QueryIterator left, QueryIterator right, ExprList conditions, ExecutionContext execCxt) {
        super(joinKey, right, left, execCxt);
        this.conditions = conditions;
    }

    @Override
    protected Binding yieldOneResult(Binding rowCurrentProbe, Binding rowStream, Binding rowResult) {
        if (this.conditions != null && !this.conditions.isSatisfied(rowResult, this.getExecContext())) {
            return null;
        }
        return rowResult;
    }

    @Override
    protected Binding noYieldedRows(Binding rowCurrentProbe) {
        return rowCurrentProbe;
    }

    @Override
    protected QueryIterator joinFinished() {
        return null;
    }
}

