/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.algebra;

import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Deque;
import org.apache.jena.graph.Node;
import org.apache.jena.sparql.algebra.Op;
import org.apache.jena.sparql.algebra.OpVars;
import org.apache.jena.sparql.algebra.OpVisitorBase;
import org.apache.jena.sparql.algebra.TransformQuadBlockGraph;
import org.apache.jena.sparql.algebra.TransformQuadGraph;
import org.apache.jena.sparql.algebra.Transformer;
import org.apache.jena.sparql.algebra.op.OpGraph;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.core.VarAlloc;

public class AlgebraQuad {
    private AlgebraQuad() {
    }

    public static Op quadize(Op op) {
        ArrayDeque<QuadSlot> stack = new ArrayDeque<QuadSlot>();
        QuadSlot qSlot = new QuadSlot(Quad.defaultGraphNodeGenerated, Quad.defaultGraphNodeGenerated);
        stack.push(qSlot);
        Pusher before = new Pusher(stack);
        Popper after = new Popper(stack);
        TransformQuadGraph qg = new TransformQuadGraph(stack, before, after);
        return Transformer.transformSkipService(qg, null, op, before, after);
    }

    public static Op quadizeBlock(Op op) {
        ArrayDeque<QuadSlot> stack = new ArrayDeque<QuadSlot>();
        QuadSlot qSlot = new QuadSlot(Quad.defaultGraphNodeGenerated, Quad.defaultGraphNodeGenerated);
        stack.push(qSlot);
        Pusher before = new Pusher(stack);
        Popper after = new Popper(stack);
        TransformQuadBlockGraph qg = new TransformQuadBlockGraph(stack, before, after);
        return Transformer.transformSkipService(qg, null, op, before, after);
    }

    private static class Popper
    extends OpVisitorBase {
        Deque<QuadSlot> stack;

        Popper(Deque<QuadSlot> stack) {
            this.stack = stack;
        }

        @Override
        public void visit(OpGraph opGraph) {
            QuadSlot qs = this.stack.pop();
        }
    }

    private static class Pusher
    extends OpVisitorBase {
        Deque<QuadSlot> stack;
        VarAlloc varAlloc = new VarAlloc("*g");

        Pusher(Deque<QuadSlot> stack) {
            this.stack = stack;
        }

        @Override
        public void visit(OpGraph opGraph) {
            Collection<Var> vars;
            Node gn;
            Node gnQuad = gn = opGraph.getNode();
            if (Var.isVar(gn) && (vars = OpVars.mentionedVars(opGraph.getSubOp())).contains(gn)) {
                gnQuad = this.varAlloc.allocVar();
            }
            this.stack.push(new QuadSlot(gn, gnQuad));
        }
    }

    static class QuadSlot {
        final Node actualGraphName;
        final Node rewriteGraphName;

        QuadSlot(Node actualGraphName, Node rewriteGraphName) {
            this.actualGraphName = actualGraphName;
            this.rewriteGraphName = rewriteGraphName;
        }

        public String toString() {
            return "actualGraphName=" + this.actualGraphName + " rewriteGraphName=" + this.rewriteGraphName;
        }
    }
}

