/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.config;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import org.apache.shiro.config.ConfigurationException;
import org.apache.shiro.io.ResourceUtils;
import org.apache.shiro.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Ini
implements Map<String, Section> {
    private static final transient Logger log = LoggerFactory.getLogger(Ini.class);
    public static final String DEFAULT_SECTION_NAME = "";
    public static final String DEFAULT_CHARSET_NAME = "UTF-8";
    public static final String COMMENT_POUND = "#";
    public static final String COMMENT_SEMICOLON = ";";
    public static final String SECTION_PREFIX = "[";
    public static final String SECTION_SUFFIX = "]";
    protected static final char ESCAPE_TOKEN = '\\';
    private final Map<String, Section> sections = new LinkedHashMap<String, Section>();

    public Ini() {
    }

    public Ini(Ini defaults) {
        this();
        if (defaults == null) {
            throw new NullPointerException("Defaults cannot be null.");
        }
        for (Section section : defaults.getSections()) {
            Section copy = new Section(section);
            this.sections.put(section.getName(), copy);
        }
    }

    @Override
    public boolean isEmpty() {
        Collection<Section> sections = this.sections.values();
        if (!sections.isEmpty()) {
            for (Section section : sections) {
                if (section.isEmpty()) continue;
                return false;
            }
        }
        return true;
    }

    public Set<String> getSectionNames() {
        return Collections.unmodifiableSet(this.sections.keySet());
    }

    public Collection<Section> getSections() {
        return Collections.unmodifiableCollection(this.sections.values());
    }

    public Section getSection(String sectionName) {
        String name = Ini.cleanName(sectionName);
        return this.sections.get(name);
    }

    public Section addSection(String sectionName) {
        String name = Ini.cleanName(sectionName);
        Section section = this.getSection(name);
        if (section == null) {
            section = new Section(name);
            this.sections.put(name, section);
        }
        return section;
    }

    public Section removeSection(String sectionName) {
        String name = Ini.cleanName(sectionName);
        return this.sections.remove(name);
    }

    private static String cleanName(String sectionName) {
        String name = StringUtils.clean(sectionName);
        if (name == null) {
            log.trace("Specified name was null or empty.  Defaulting to the default section (name = \"\")");
            name = DEFAULT_SECTION_NAME;
        }
        return name;
    }

    public void setSectionProperty(String sectionName, String propertyName, String propertyValue) {
        String name = Ini.cleanName(sectionName);
        Section section = this.getSection(name);
        if (section == null) {
            section = this.addSection(name);
        }
        section.put(propertyName, propertyValue);
    }

    public String getSectionProperty(String sectionName, String propertyName) {
        Section section = this.getSection(sectionName);
        return section != null ? section.get(propertyName) : null;
    }

    public String getSectionProperty(String sectionName, String propertyName, String defaultValue) {
        String value = this.getSectionProperty(sectionName, propertyName);
        return value != null ? value : defaultValue;
    }

    public static Ini fromResourcePath(String resourcePath) throws ConfigurationException {
        if (!StringUtils.hasLength(resourcePath)) {
            throw new IllegalArgumentException("Resource Path argument cannot be null or empty.");
        }
        Ini ini = new Ini();
        ini.loadFromPath(resourcePath);
        return ini;
    }

    public void loadFromPath(String resourcePath) throws ConfigurationException {
        InputStream is;
        try {
            is = ResourceUtils.getInputStreamForPath(resourcePath);
        }
        catch (IOException e) {
            throw new ConfigurationException(e);
        }
        this.load(is);
    }

    public void load(String iniConfig) throws ConfigurationException {
        this.load(new Scanner(iniConfig));
    }

    public void load(InputStream is) throws ConfigurationException {
        InputStreamReader isr;
        if (is == null) {
            throw new NullPointerException("InputStream argument cannot be null.");
        }
        try {
            isr = new InputStreamReader(is, DEFAULT_CHARSET_NAME);
        }
        catch (UnsupportedEncodingException e) {
            throw new ConfigurationException(e);
        }
        this.load(isr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(Reader reader) {
        Scanner scanner = new Scanner(reader);
        try {
            this.load(scanner);
        }
        finally {
            try {
                scanner.close();
            }
            catch (Exception e) {
                log.debug("Unable to cleanly close the InputStream scanner.  Non-critical - ignoring.", e);
            }
        }
    }

    public void merge(Map<String, Section> m) {
        if (m != null) {
            for (Map.Entry<String, Section> entry : m.entrySet()) {
                Section section = this.getSection(entry.getKey());
                if (section == null) {
                    section = this.addSection(entry.getKey());
                }
                section.putAll(entry.getValue());
            }
        }
    }

    private void addSection(String name, StringBuilder content) {
        Section section;
        String contentString;
        String cleaned;
        if (content.length() > 0 && (cleaned = StringUtils.clean(contentString = content.toString())) != null && !(section = new Section(name, contentString)).isEmpty()) {
            this.sections.put(name, section);
        }
    }

    public void load(Scanner scanner) {
        String sectionName = DEFAULT_SECTION_NAME;
        StringBuilder sectionContent = new StringBuilder();
        while (scanner.hasNextLine()) {
            String rawLine = scanner.nextLine();
            String line = StringUtils.clean(rawLine);
            if (line == null || line.startsWith(COMMENT_POUND) || line.startsWith(COMMENT_SEMICOLON)) continue;
            String newSectionName = Ini.getSectionName(line);
            if (newSectionName != null) {
                this.addSection(sectionName, sectionContent);
                sectionContent = new StringBuilder();
                sectionName = newSectionName;
                if (!log.isDebugEnabled()) continue;
                log.debug("Parsing [" + sectionName + SECTION_SUFFIX);
                continue;
            }
            sectionContent.append(rawLine).append("\n");
        }
        this.addSection(sectionName, sectionContent);
    }

    protected static boolean isSectionHeader(String line) {
        String s = StringUtils.clean(line);
        return s != null && s.startsWith(SECTION_PREFIX) && s.endsWith(SECTION_SUFFIX);
    }

    protected static String getSectionName(String line) {
        String s = StringUtils.clean(line);
        if (Ini.isSectionHeader(s)) {
            return Ini.cleanName(s.substring(1, s.length() - 1));
        }
        return null;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof Ini) {
            Ini ini = (Ini)obj;
            return this.sections.equals(ini.sections);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.sections.hashCode();
    }

    public String toString() {
        if (this.sections == null || this.sections.isEmpty()) {
            return "<empty INI>";
        }
        StringBuilder sb = new StringBuilder("sections=");
        int i = 0;
        for (Section section : this.sections.values()) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append(section.toString());
            ++i;
        }
        return sb.toString();
    }

    @Override
    public int size() {
        return this.sections.size();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.sections.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.sections.containsValue(value);
    }

    @Override
    public Section get(Object key) {
        return this.sections.get(key);
    }

    @Override
    public Section put(String key, Section value) {
        return this.sections.put(key, value);
    }

    @Override
    public Section remove(Object key) {
        return this.sections.remove(key);
    }

    @Override
    public void putAll(Map<? extends String, ? extends Section> m) {
        this.sections.putAll(m);
    }

    @Override
    public void clear() {
        this.sections.clear();
    }

    @Override
    public Set<String> keySet() {
        return Collections.unmodifiableSet(this.sections.keySet());
    }

    @Override
    public Collection<Section> values() {
        return Collections.unmodifiableCollection(this.sections.values());
    }

    @Override
    public Set<Map.Entry<String, Section>> entrySet() {
        return Collections.unmodifiableSet(this.sections.entrySet());
    }

    public static class Section
    implements Map<String, String> {
        private final String name;
        private final Map<String, String> props;

        private Section(String name) {
            if (name == null) {
                throw new NullPointerException("name");
            }
            this.name = name;
            this.props = new LinkedHashMap<String, String>();
        }

        private Section(String name, String sectionContent) {
            if (name == null) {
                throw new NullPointerException("name");
            }
            this.name = name;
            Map<String, String> props = StringUtils.hasText(sectionContent) ? Section.toMapProps(sectionContent) : new LinkedHashMap<String, String>();
            this.props = props != null ? props : new LinkedHashMap<String, String>();
        }

        private Section(Section defaults) {
            this(defaults.getName());
            this.putAll((Map<? extends String, ? extends String>)defaults.props);
        }

        protected static boolean isContinued(String line) {
            if (!StringUtils.hasText(line)) {
                return false;
            }
            int length = line.length();
            int backslashCount = 0;
            for (int i = length - 1; i > 0 && line.charAt(i) == '\\'; --i) {
                ++backslashCount;
            }
            return backslashCount % 2 != 0;
        }

        private static boolean isKeyValueSeparatorChar(char c) {
            return Character.isWhitespace(c) || c == ':' || c == '=';
        }

        private static boolean isCharEscaped(CharSequence s, int index) {
            return index > 0 && s.charAt(index) == '\\';
        }

        protected static String[] splitKeyValue(String keyValueLine) {
            String line = StringUtils.clean(keyValueLine);
            if (line == null) {
                return null;
            }
            StringBuilder keyBuffer = new StringBuilder();
            StringBuilder valueBuffer = new StringBuilder();
            boolean buildingKey = true;
            for (int i = 0; i < line.length(); ++i) {
                char c = line.charAt(i);
                if (buildingKey) {
                    if (Section.isKeyValueSeparatorChar(c) && !Section.isCharEscaped(line, i)) {
                        buildingKey = false;
                        continue;
                    }
                    if (Section.isCharEscaped(line, i)) continue;
                    keyBuffer.append(c);
                    continue;
                }
                if (valueBuffer.length() == 0 && Section.isKeyValueSeparatorChar(c) && !Section.isCharEscaped(line, i)) continue;
                valueBuffer.append(c);
            }
            String key = StringUtils.clean(keyBuffer.toString());
            String value = StringUtils.clean(valueBuffer.toString());
            if (key == null || value == null) {
                String msg = "Line argument must contain a key and a value.  Only one string token was found.";
                throw new IllegalArgumentException(msg);
            }
            log.trace("Discovered key/value pair: {} = {}", (Object)key, (Object)value);
            return new String[]{key, value};
        }

        private static Map<String, String> toMapProps(String content) {
            LinkedHashMap<String, String> props = new LinkedHashMap<String, String>();
            StringBuilder lineBuffer = new StringBuilder();
            Scanner scanner = new Scanner(content);
            while (scanner.hasNextLine()) {
                String line = StringUtils.clean(scanner.nextLine());
                if (Section.isContinued(line)) {
                    line = line.substring(0, line.length() - 1);
                    lineBuffer.append(line);
                    continue;
                }
                lineBuffer.append(line);
                line = lineBuffer.toString();
                lineBuffer = new StringBuilder();
                String[] kvPair = Section.splitKeyValue(line);
                props.put(kvPair[0], kvPair[1]);
            }
            return props;
        }

        public String getName() {
            return this.name;
        }

        @Override
        public void clear() {
            this.props.clear();
        }

        @Override
        public boolean containsKey(Object key) {
            return this.props.containsKey(key);
        }

        @Override
        public boolean containsValue(Object value) {
            return this.props.containsValue(value);
        }

        @Override
        public Set<Map.Entry<String, String>> entrySet() {
            return this.props.entrySet();
        }

        @Override
        public String get(Object key) {
            return this.props.get(key);
        }

        @Override
        public boolean isEmpty() {
            return this.props.isEmpty();
        }

        @Override
        public Set<String> keySet() {
            return this.props.keySet();
        }

        @Override
        public String put(String key, String value) {
            return this.props.put(key, value);
        }

        @Override
        public void putAll(Map<? extends String, ? extends String> m) {
            this.props.putAll(m);
        }

        @Override
        public String remove(Object key) {
            return this.props.remove(key);
        }

        @Override
        public int size() {
            return this.props.size();
        }

        @Override
        public Collection<String> values() {
            return this.props.values();
        }

        public String toString() {
            String name = this.getName();
            if (Ini.DEFAULT_SECTION_NAME.equals(name)) {
                return "<default>";
            }
            return name;
        }

        @Override
        public boolean equals(Object obj) {
            if (obj instanceof Section) {
                Section other = (Section)obj;
                return this.getName().equals(other.getName()) && this.props.equals(other.props);
            }
            return false;
        }

        @Override
        public int hashCode() {
            return this.name.hashCode() * 31 + this.props.hashCode();
        }
    }
}

