/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.redis.internal.executor.list;

import java.util.List;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.query.Query;
import org.apache.geode.cache.query.SelectResults;
import org.apache.geode.cache.query.Struct;
import org.apache.geode.redis.internal.ByteArrayWrapper;
import org.apache.geode.redis.internal.Coder;
import org.apache.geode.redis.internal.Command;
import org.apache.geode.redis.internal.ExecutionHandlerContext;
import org.apache.geode.redis.internal.RedisDataType;
import org.apache.geode.redis.internal.executor.ListQuery;
import org.apache.geode.redis.internal.executor.list.ListExecutor;

public class LIndexExecutor
extends ListExecutor {
    private final String ERROR_NOT_NUMERIC = "The index provided is not numeric";

    @Override
    public void executeCommand(Command command, ExecutionHandlerContext context) {
        Struct entry;
        Integer redisIndex;
        List<byte[]> commandElems = command.getProcessedCommand();
        if (commandElems.size() < 3) {
            command.setResponse(Coder.getErrorResponse(context.getByteBufAllocator(), "The wrong number of arguments or syntax was provided, the format for the LINDEX command is \"LINDEX key index"));
            return;
        }
        ByteArrayWrapper key = command.getKey();
        byte[] indexArray = commandElems.get(2);
        this.checkDataType(key, RedisDataType.REDIS_LIST, context);
        Region<Integer, ByteArrayWrapper> keyRegion = this.getRegion(context, key);
        if (keyRegion == null) {
            command.setResponse(Coder.getNilResponse(context.getByteBufAllocator()));
            return;
        }
        int listSize = keyRegion.size() - 2;
        try {
            redisIndex = Coder.bytesToInt(indexArray);
        }
        catch (NumberFormatException e) {
            command.setResponse(Coder.getErrorResponse(context.getByteBufAllocator(), "The index provided is not numeric"));
            return;
        }
        if (redisIndex < 0) {
            redisIndex = listSize + redisIndex;
        }
        if (redisIndex < 0) {
            command.setResponse(Coder.getNilResponse(context.getByteBufAllocator()));
            return;
        }
        try {
            entry = this.getEntryAtIndex(context, key, redisIndex);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (entry == null) {
            command.setResponse(Coder.getNilResponse(context.getByteBufAllocator()));
            return;
        }
        Object[] entryArray = entry.getFieldValues();
        ByteArrayWrapper valueWrapper = (ByteArrayWrapper)entryArray[1];
        command.setResponse(Coder.getBulkStringResponse(context.getByteBufAllocator(), valueWrapper.toBytes()));
    }

    private Struct getEntryAtIndex(ExecutionHandlerContext context, ByteArrayWrapper key, int index) throws Exception {
        Object[] params;
        Query query = this.getQuery(key, ListQuery.LINDEX, context);
        SelectResults results = (SelectResults)query.execute(params = new Object[]{index + 1});
        if (results == null || results.size() == 0 || results.size() <= index) {
            return null;
        }
        return (Struct)results.asList().get(index);
    }
}

