/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.pdx.internal;

import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.geode.cache.CacheClosedException;
import org.apache.geode.cache.DiskStore;
import org.apache.geode.cache.wan.GatewaySender;
import org.apache.geode.internal.Assert;
import org.apache.geode.internal.InternalDataSerializer;
import org.apache.geode.internal.cache.GemFireCacheImpl;
import org.apache.geode.internal.i18n.LocalizedStrings;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.internal.util.concurrent.CopyOnWriteHashMap;
import org.apache.geode.internal.util.concurrent.CopyOnWriteWeakHashMap;
import org.apache.geode.pdx.PdxSerializationException;
import org.apache.geode.pdx.PdxSerializer;
import org.apache.geode.pdx.ReflectionBasedAutoSerializer;
import org.apache.geode.pdx.internal.AutoSerializableManager;
import org.apache.geode.pdx.internal.ClientTypeRegistration;
import org.apache.geode.pdx.internal.EnumInfo;
import org.apache.geode.pdx.internal.LonerTypeRegistration;
import org.apache.geode.pdx.internal.NullTypeRegistration;
import org.apache.geode.pdx.internal.PdxType;
import org.apache.geode.pdx.internal.PdxUnreadData;
import org.apache.geode.pdx.internal.PeerTypeRegistration;
import org.apache.geode.pdx.internal.TypeRegistration;
import org.apache.geode.pdx.internal.UnreadPdxType;
import org.apache.geode.pdx.internal.WeakConcurrentIdentityHashMap;
import org.apache.logging.log4j.Logger;

public class TypeRegistry {
    private static final Logger logger = LogService.getLogger();
    private static final boolean DISABLE_TYPE_REGISTRY = Boolean.getBoolean("gemfire.TypeRegistry.DISABLE_PDX_REGISTRY");
    private final Map<Integer, PdxType> idToType = new CopyOnWriteHashMap<Integer, PdxType>();
    private final Map<PdxType, Integer> typeToId = new CopyOnWriteHashMap<PdxType, Integer>();
    private final Map<Class<?>, PdxType> localTypeIds = new CopyOnWriteWeakHashMap();
    private final Map<Class<?>, Map<Integer, UnreadPdxType>> localTypeIdMaps = new CopyOnWriteWeakHashMap();
    private final WeakConcurrentIdentityHashMap<Object, PdxUnreadData> unreadDataMap = WeakConcurrentIdentityHashMap.make();
    private final Map<Integer, EnumInfo> idToEnum = new CopyOnWriteHashMap<Integer, EnumInfo>();
    private final Map<EnumInfo, Integer> enumInfoToId = new CopyOnWriteHashMap<EnumInfo, Integer>();
    private final Map<Enum<?>, Integer> localEnumIds = new CopyOnWriteWeakHashMap();
    private final TypeRegistration distributedTypeRegistry;
    private final GemFireCacheImpl cache;
    private static final AtomicReference<PdxSerializer> pdxSerializer = new AtomicReference<Object>(null);
    private static final AtomicReference<AutoSerializableManager> asm = new AtomicReference<Object>(null);
    private static volatile boolean open = false;
    private static volatile boolean pdxSerializerWasSet = false;

    public TypeRegistry(GemFireCacheImpl cache, boolean disableTypeRegistry) {
        this.cache = cache;
        this.distributedTypeRegistry = DISABLE_TYPE_REGISTRY || disableTypeRegistry ? new NullTypeRegistration() : (cache.hasPool() ? new ClientTypeRegistration(cache) : (LonerTypeRegistration.isIndeterminateLoner(cache) ? new LonerTypeRegistration(cache) : new PeerTypeRegistration(cache)));
    }

    public void testClearTypeRegistry() {
        this.typeToId.clear();
        this.idToType.clear();
        this.idToEnum.clear();
        this.enumInfoToId.clear();
        this.distributedTypeRegistry.testClearRegistry();
    }

    public void testClearLocalTypeRegistry() {
        this.localTypeIds.clear();
        this.localTypeIdMaps.clear();
        this.localEnumIds.clear();
    }

    public static boolean mayNeedDiskStore(GemFireCacheImpl cache) {
        if (DISABLE_TYPE_REGISTRY) {
            return false;
        }
        if (cache.hasPool()) {
            return false;
        }
        return cache.getPdxPersistent();
    }

    public static String getPdxDiskStoreName(GemFireCacheImpl cache) {
        if (!TypeRegistry.mayNeedDiskStore(cache)) {
            return null;
        }
        String result = cache.getPdxDiskStore();
        if (result == null) {
            result = "DEFAULT";
        }
        return result;
    }

    public void initialize() {
        if (!this.cache.getPdxPersistent() || this.cache.getPdxDiskStore() == null || this.cache.findDiskStore(this.cache.getPdxDiskStore()) != null) {
            this.distributedTypeRegistry.initialize();
        }
    }

    public void flushCache() {
        InternalDataSerializer.flushClassCache();
        for (EnumInfo ei : this.idToEnum.values()) {
            ei.flushCache();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PdxType getType(int typeId) {
        PdxType pdxType = this.idToType.get(typeId);
        if (pdxType != null) {
            return pdxType;
        }
        TypeRegistry typeRegistry = this;
        synchronized (typeRegistry) {
            pdxType = this.distributedTypeRegistry.getType(typeId);
            if (pdxType != null) {
                this.idToType.put(typeId, pdxType);
                this.typeToId.put(pdxType, typeId);
                if (logger.isInfoEnabled()) {
                    logger.info("Adding: {}", (Object)pdxType.toFormattedString());
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("Adding entry into pdx type registry, typeId: {}  {}", (Object)typeId, (Object)pdxType);
                }
                return pdxType;
            }
        }
        return null;
    }

    public PdxType getExistingType(Object o) {
        return this.getExistingTypeForClass(o.getClass());
    }

    public PdxType getExistingTypeForClass(Class<?> c) {
        return this.localTypeIds.get(c);
    }

    public UnreadPdxType getExistingTypeForClass(Class<?> c, int typeId) {
        Map<Integer, UnreadPdxType> m = this.localTypeIdMaps.get(c);
        if (m != null) {
            return m.get(typeId);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void defineUnreadType(Class<?> c, UnreadPdxType unreadPdxType) {
        int typeId = unreadPdxType.getTypeId();
        Map<Class<?>, Map<Integer, UnreadPdxType>> map = this.localTypeIdMaps;
        synchronized (map) {
            Map<Integer, UnreadPdxType> m = this.localTypeIdMaps.get(c);
            if (m == null) {
                m = new CopyOnWriteHashMap<Integer, UnreadPdxType>();
                this.localTypeIdMaps.put(c, m);
            }
            m.put(typeId, unreadPdxType);
        }
    }

    public int defineType(PdxType newType) {
        Integer existingId = this.typeToId.get(newType);
        if (existingId != null) {
            int eid = existingId;
            newType.setTypeId(eid);
            return eid;
        }
        int id = this.distributedTypeRegistry.defineType(newType);
        newType.setTypeId(id);
        PdxType oldType = this.idToType.get(id);
        if (oldType == null) {
            this.idToType.put(id, newType);
            this.typeToId.put(newType, id);
            if (logger.isInfoEnabled()) {
                logger.info("Caching {}", (Object)newType.toFormattedString());
            }
        } else if (!oldType.equals(newType)) {
            Assert.fail("Old type does not equal new type for the same id. oldType=" + oldType + " new type=" + newType);
        }
        return id;
    }

    public void addRemoteType(int typeId, PdxType newType) {
        PdxType oldType = this.idToType.get(typeId);
        if (oldType == null) {
            this.distributedTypeRegistry.addRemoteType(typeId, newType);
            this.idToType.put(typeId, newType);
            this.typeToId.put(newType, typeId);
            if (logger.isInfoEnabled()) {
                logger.info("Adding, from remote WAN: {}", (Object)newType.toFormattedString());
            }
        } else if (!oldType.equals(newType)) {
            Assert.fail("Old type does not equal new type for the same id. oldType=" + oldType + " new type=" + newType);
        }
    }

    public PdxType defineLocalType(Object o, PdxType newType) {
        if (o != null) {
            PdxType t = this.getExistingType(o);
            if (t != null) {
                return t;
            }
            this.defineType(newType);
            this.localTypeIds.put(o.getClass(), newType);
        } else {
            this.defineType(newType);
        }
        return newType;
    }

    public int getLastAllocatedTypeId() {
        return this.distributedTypeRegistry.getLastAllocatedTypeId();
    }

    public TypeRegistration getTypeRegistration() {
        return this.distributedTypeRegistry;
    }

    public void gatewaySenderStarted(GatewaySender gatewaySender) {
        if (this.distributedTypeRegistry != null) {
            this.distributedTypeRegistry.gatewaySenderStarted(gatewaySender);
        }
    }

    public void creatingDiskStore(DiskStore dsi) {
        if (this.cache.getPdxDiskStore() != null && dsi.getName().equals(this.cache.getPdxDiskStore())) {
            this.distributedTypeRegistry.initialize();
        }
    }

    public void creatingPersistentRegion() {
        this.distributedTypeRegistry.creatingPersistentRegion();
    }

    public void creatingPool() {
        this.distributedTypeRegistry.creatingPool();
    }

    public void removeLocal(Object o) {
        this.localTypeIds.remove(o.getClass());
    }

    public PdxUnreadData getUnreadData(Object o) {
        return this.unreadDataMap.get(o);
    }

    public void putUnreadData(Object o, PdxUnreadData ud) {
        this.unreadDataMap.put(o, ud);
    }

    public static void init() {
        pdxSerializerWasSet = false;
    }

    public static void open() {
        open = true;
    }

    public static void close() {
        open = false;
    }

    public static PdxSerializer getPdxSerializer() {
        PdxSerializer result = pdxSerializer.get();
        if (result == null && !open && pdxSerializerWasSet) {
            throw new CacheClosedException("Could not PDX serialize because the cache was closed");
        }
        return result;
    }

    public static AutoSerializableManager getAutoSerializableManager() {
        return asm.get();
    }

    public static void setPdxSerializer(PdxSerializer v) {
        if (v == null) {
            PdxSerializer oldValue = pdxSerializer.getAndSet(null);
            if (oldValue instanceof ReflectionBasedAutoSerializer) {
                asm.compareAndSet((AutoSerializableManager)((ReflectionBasedAutoSerializer)oldValue).getManager(), null);
            }
        } else {
            pdxSerializerWasSet = true;
            pdxSerializer.set(v);
            if (v instanceof ReflectionBasedAutoSerializer) {
                asm.set((AutoSerializableManager)((ReflectionBasedAutoSerializer)v).getManager());
            }
        }
    }

    public int getEnumId(Enum<?> v) {
        int result = 0;
        if (v != null) {
            Integer id = this.localEnumIds.get(v);
            if (id != null) {
                result = id;
            } else {
                result = this.distributedTypeRegistry.getEnumId(v);
                id = result;
                this.localEnumIds.put(v, id);
                EnumInfo ei = new EnumInfo(v);
                this.idToEnum.put(id, ei);
                this.enumInfoToId.put(ei, id);
            }
        }
        return result;
    }

    public void addRemoteEnum(int enumId, EnumInfo newInfo) {
        EnumInfo oldInfo = this.idToEnum.get(enumId);
        if (oldInfo == null) {
            this.distributedTypeRegistry.addRemoteEnum(enumId, newInfo);
            this.idToEnum.put(enumId, newInfo);
            this.enumInfoToId.put(newInfo, enumId);
        } else if (!oldInfo.equals(newInfo)) {
            Assert.fail("Old enum does not equal new enum for the same id. oldEnum=" + oldInfo + " new enum=" + newInfo);
        }
    }

    public int defineEnum(EnumInfo newInfo) {
        Integer existingId = this.enumInfoToId.get(newInfo);
        if (existingId != null) {
            return existingId;
        }
        int id = this.distributedTypeRegistry.defineEnum(newInfo);
        EnumInfo oldInfo = this.idToEnum.get(id);
        if (oldInfo == null) {
            this.idToEnum.put(id, newInfo);
            this.enumInfoToId.put(newInfo, id);
            if (logger.isInfoEnabled()) {
                logger.info("Caching PDX Enum: {}, dsid={} typenum={}", (Object)newInfo, (Object)(id >> 24), (Object)(id & 0xFFFFFF));
            }
        } else if (!oldInfo.equals(newInfo)) {
            Assert.fail("Old enum does not equal new enum for the same id. oldEnum=" + oldInfo + " newEnum=" + newInfo);
        }
        return id;
    }

    public Object getEnumById(int enumId) {
        if (enumId == 0) {
            return null;
        }
        EnumInfo ei = this.getEnumInfoById(enumId);
        if (ei == null) {
            throw new PdxSerializationException("Could not find a PDX registration for the enum with id " + enumId);
        }
        if (this.cache.getPdxReadSerializedByAnyGemFireServices()) {
            return ei.getPdxInstance(enumId);
        }
        try {
            return ei.getEnum();
        }
        catch (ClassNotFoundException ex) {
            throw new PdxSerializationException("PDX enum field could not be read because the enum class could not be loaded", ex);
        }
    }

    public EnumInfo getEnumInfoById(int enumId) {
        if (enumId == 0) {
            return null;
        }
        EnumInfo ei = this.idToEnum.get(enumId);
        if (ei == null && (ei = this.distributedTypeRegistry.getEnumById(enumId)) != null) {
            this.idToEnum.put(enumId, ei);
            this.enumInfoToId.put(ei, enumId);
        }
        return ei;
    }

    public void clear() {
        if (this.distributedTypeRegistry.isClient()) {
            this.idToType.clear();
            this.typeToId.clear();
            this.localTypeIds.clear();
            this.localTypeIdMaps.clear();
            this.unreadDataMap.clear();
            this.idToEnum.clear();
            this.enumInfoToId.clear();
            this.localEnumIds.clear();
            AutoSerializableManager autoSerializer = TypeRegistry.getAutoSerializableManager();
            if (autoSerializer != null) {
                autoSerializer.resetCachedTypes();
            }
        }
    }

    public Map<Integer, PdxType> typeMap() {
        return this.distributedTypeRegistry.types();
    }

    public Map<Integer, EnumInfo> enumMap() {
        return this.distributedTypeRegistry.enums();
    }

    public PdxType getPdxTypeForField(String fieldName, String className) {
        return this.distributedTypeRegistry.getPdxTypeForField(fieldName, className);
    }

    public void addImportedType(int typeId, PdxType importedType) {
        PdxType existing = this.getType(typeId);
        if (existing != null && !existing.equals(importedType)) {
            throw new PdxSerializationException(LocalizedStrings.Snapshot_PDX_CONFLICT_0_1.toLocalizedString(importedType, existing));
        }
        this.distributedTypeRegistry.addImportedType(typeId, importedType);
        this.idToType.put(typeId, importedType);
        this.typeToId.put(importedType, typeId);
        if (logger.isInfoEnabled()) {
            logger.info("Importing type: {}", (Object)importedType.toFormattedString());
        }
    }

    public void addImportedEnum(int enumId, EnumInfo importedEnum) {
        EnumInfo existing = this.getEnumInfoById(enumId);
        if (existing != null && !existing.equals(importedEnum)) {
            throw new PdxSerializationException(LocalizedStrings.Snapshot_PDX_CONFLICT_0_1.toLocalizedString(importedEnum, existing));
        }
        this.distributedTypeRegistry.addImportedEnum(enumId, importedEnum);
        this.idToEnum.put(enumId, importedEnum);
        this.enumInfoToId.put(importedEnum, enumId);
    }

    public int getLocalSize() {
        int result = this.distributedTypeRegistry.getLocalSize();
        if (result == 0) {
            return this.idToType.size();
        }
        return result;
    }
}

