/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.pdx;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.math.BigInteger;
import org.apache.geode.pdx.JSONFormatterException;
import org.apache.geode.pdx.PdxInstance;
import org.apache.geode.pdx.internal.json.JSONToPdxMapper;
import org.apache.geode.pdx.internal.json.PdxInstanceHelper;
import org.apache.geode.pdx.internal.json.PdxInstanceSortedHelper;
import org.apache.geode.pdx.internal.json.PdxListHelper;
import org.apache.geode.pdx.internal.json.PdxToJSON;

public class JSONFormatter {
    public static final String JSON_CLASSNAME = "__GEMFIRE_JSON";
    public static final String SORT_JSON_FIELD_NAMES_PROPERTY = "gemfire.pdx.mapper.sort-json-field-names";

    private JSONFormatter() {
    }

    public static PdxInstance fromJSON(String jsonString) {
        JsonParser jp = null;
        try {
            jp = new JsonFactory().createParser(jsonString);
            JSONFormatter.enableJSONParserFeature(jp);
            return new JSONFormatter().getPdxInstance(jp, states.NONE, null).getPdxInstance();
        }
        catch (JsonParseException jpe) {
            throw new JSONFormatterException("Could not parse JSON document ", jpe);
        }
        catch (IOException e) {
            throw new JSONFormatterException("Could not parse JSON document: " + jp.getCurrentLocation(), e);
        }
        catch (Exception e) {
            throw new JSONFormatterException("Could not parse JSON document: " + jp.getCurrentLocation(), e);
        }
    }

    public static PdxInstance fromJSON(byte[] jsonByteArray) {
        JsonParser jp = null;
        try {
            jp = new JsonFactory().createParser(jsonByteArray);
            JSONFormatter.enableJSONParserFeature(jp);
            return new JSONFormatter().getPdxInstance(jp, states.NONE, null).getPdxInstance();
        }
        catch (JsonParseException jpe) {
            throw new JSONFormatterException("Could not parse JSON document ", jpe);
        }
        catch (IOException e) {
            throw new JSONFormatterException("Could not parse JSON document: " + jp.getCurrentLocation(), e);
        }
        catch (Exception e) {
            throw new JSONFormatterException("Could not parse JSON document: " + jp.getCurrentLocation(), e);
        }
    }

    private static void enableJSONParserFeature(JsonParser jp) {
        jp.enable(JsonParser.Feature.ALLOW_BACKSLASH_ESCAPING_ANY_CHARACTER);
        jp.enable(JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES);
    }

    public static String toJSON(PdxInstance pdxInstance) {
        try {
            PdxToJSON pj = new PdxToJSON(pdxInstance);
            return pj.getJSON();
        }
        catch (Exception e) {
            throw new JSONFormatterException("Could not create JSON document from PdxInstance", e);
        }
    }

    public static byte[] toJSONByteArray(PdxInstance pdxInstance) {
        try {
            PdxToJSON pj = new PdxToJSON(pdxInstance);
            return pj.getJSONByteArray();
        }
        catch (Exception e) {
            throw new JSONFormatterException("Could not create JSON document from PdxInstance", e);
        }
    }

    private static JSONToPdxMapper createJSONToPdxMapper(String className, JSONToPdxMapper parent) {
        if (Boolean.getBoolean(SORT_JSON_FIELD_NAMES_PROPERTY)) {
            return new PdxInstanceSortedHelper(className, parent);
        }
        return new PdxInstanceHelper(className, parent);
    }

    private JSONToPdxMapper getPdxInstance(JsonParser jp, states currentState, JSONToPdxMapper currentPdxInstance) throws JsonParseException, IOException {
        JsonToken nt;
        String currentFieldName = null;
        if (currentState == states.ObJECT_START && currentPdxInstance == null) {
            currentPdxInstance = JSONFormatter.createJSONToPdxMapper(null, null);
        }
        block15: while (true) {
            if ((nt = jp.nextToken()) == null) {
                return currentPdxInstance;
            }
            switch (nt) {
                case START_OBJECT: {
                    JSONToPdxMapper tmp;
                    this.objectStarts(currentState);
                    currentState = states.ObJECT_START;
                    currentPdxInstance = tmp = JSONFormatter.createJSONToPdxMapper(currentFieldName, currentPdxInstance);
                    continue block15;
                }
                case END_OBJECT: {
                    this.objectEnds(currentState);
                    currentState = states.OBJECT_ENDS;
                    currentPdxInstance.endObjectField("endobject");
                    if (currentPdxInstance.getParent() == null) {
                        return currentPdxInstance;
                    }
                    JSONToPdxMapper tmp = currentPdxInstance;
                    currentPdxInstance = currentPdxInstance.getParent();
                    currentPdxInstance.addObjectField(tmp.getPdxFieldName(), tmp.getPdxInstance());
                    continue block15;
                }
                case FIELD_NAME: {
                    this.fieldFound(currentState);
                    if (currentState == states.ObJECT_START) {
                        currentPdxInstance.setPdxFieldName(currentFieldName);
                    }
                    currentFieldName = jp.getText();
                    currentState = states.FIELD_NAME;
                    continue block15;
                }
                case NOT_AVAILABLE: {
                    throw new IllegalStateException("NOT_AVAILABLE token found");
                }
                case START_ARRAY: {
                    this.arrayStarts(currentState);
                    currentState = states.LIST_FOUND;
                    PdxListHelper list = this.getList(jp, currentState, null);
                    currentPdxInstance.addListField(currentFieldName, list);
                    currentState = states.LIST_ENDS;
                    currentFieldName = null;
                    continue block15;
                }
                case END_ARRAY: {
                    throw new IllegalStateException("END_ARRAY token found in getPdxInstance while current state is " + (Object)((Object)currentState));
                }
                case VALUE_EMBEDDED_OBJECT: {
                    throw new IllegalStateException("VALUE_EMBEDDED_OBJECT token found in getPdxInstance while current state is " + (Object)((Object)currentState));
                }
                case VALUE_FALSE: {
                    this.boolFound(currentState);
                    currentState = states.SCALER_FOUND;
                    currentPdxInstance.addBooleanField(currentFieldName, jp.getValueAsBoolean());
                    currentFieldName = null;
                    continue block15;
                }
                case VALUE_NULL: {
                    this.nullFound(currentState);
                    currentState = states.SCALER_FOUND;
                    currentPdxInstance.addNullField(currentFieldName);
                    currentFieldName = null;
                    continue block15;
                }
                case VALUE_NUMBER_FLOAT: {
                    this.doubleFound(currentState);
                    currentState = states.SCALER_FOUND;
                    this.setNumberField(jp, currentPdxInstance, currentFieldName);
                    currentFieldName = null;
                    continue block15;
                }
                case VALUE_NUMBER_INT: {
                    this.intFound(currentState);
                    currentState = states.SCALER_FOUND;
                    this.setNumberField(jp, currentPdxInstance, currentFieldName);
                    currentFieldName = null;
                    continue block15;
                }
                case VALUE_STRING: {
                    this.stringFound(currentState);
                    currentState = states.SCALER_FOUND;
                    currentPdxInstance.addObjectField(currentFieldName, new String(jp.getText()));
                    currentFieldName = null;
                    continue block15;
                }
                case VALUE_TRUE: {
                    this.boolFound(currentState);
                    currentState = states.SCALER_FOUND;
                    currentPdxInstance.addBooleanField(currentFieldName, jp.getValueAsBoolean());
                    currentFieldName = null;
                    continue block15;
                }
            }
            break;
        }
        throw new IllegalStateException("Token not handled " + (Object)((Object)nt));
    }

    private void setNumberField(JsonParser jp, JSONToPdxMapper pih, String fieldName) throws IOException {
        try {
            JsonParser.NumberType nt = jp.getNumberType();
            switch (nt) {
                case BIG_DECIMAL: {
                    pih.addBigDecimalField(fieldName, jp.getDecimalValue());
                    break;
                }
                case BIG_INTEGER: {
                    BigInteger bi = jp.getBigIntegerValue();
                    pih.addBigIntegerField(fieldName, bi);
                    break;
                }
                case DOUBLE: {
                    pih.addDoubleField(fieldName, jp.getDoubleValue());
                    break;
                }
                case FLOAT: {
                    pih.addFloatField(fieldName, jp.getFloatValue());
                    break;
                }
                case INT: {
                    int val = jp.getIntValue();
                    if (val > Short.MAX_VALUE || val < Short.MIN_VALUE) {
                        pih.addIntField(fieldName, val);
                        break;
                    }
                    if (val > 127 || val < -128) {
                        pih.addShortField(fieldName, (short)val);
                        break;
                    }
                    pih.addByteField(fieldName, (byte)val);
                    break;
                }
                case LONG: {
                    pih.addLongField(fieldName, jp.getLongValue());
                    break;
                }
                default: {
                    throw new IllegalStateException("setNumberField:unknow number type " + (Object)((Object)nt));
                }
            }
        }
        catch (JsonParseException jpe) {
            throw jpe;
        }
        catch (IOException e) {
            throw e;
        }
    }

    private void setNumberField(JsonParser jp, PdxListHelper pih) throws IOException {
        try {
            JsonParser.NumberType nt = jp.getNumberType();
            switch (nt) {
                case BIG_DECIMAL: {
                    pih.addBigDecimalField(jp.getDecimalValue());
                    break;
                }
                case BIG_INTEGER: {
                    BigInteger bi = jp.getBigIntegerValue();
                    pih.addBigIntegerField(bi);
                    break;
                }
                case DOUBLE: {
                    pih.addDoubleField(jp.getDoubleValue());
                    break;
                }
                case FLOAT: {
                    pih.addFloatField(jp.getFloatValue());
                    break;
                }
                case INT: {
                    int val = jp.getIntValue();
                    if (val > Short.MAX_VALUE || val < Short.MIN_VALUE) {
                        pih.addIntField(val);
                        break;
                    }
                    if (val > 127 || val < -128) {
                        pih.addShortField((short)val);
                        break;
                    }
                    pih.addByteField((byte)val);
                    break;
                }
                case LONG: {
                    pih.addLongField(jp.getLongValue());
                    break;
                }
                default: {
                    throw new IllegalStateException("setNumberField:unknow number type " + (Object)((Object)nt));
                }
            }
        }
        catch (JsonParseException jpe) {
            throw jpe;
        }
        catch (IOException e) {
            throw e;
        }
    }

    private PdxListHelper getList(JsonParser jp, states currentState, PdxListHelper currentPdxList) throws JsonParseException, IOException {
        JsonToken nt;
        String currentFieldName = null;
        currentPdxList = new PdxListHelper(currentPdxList, null);
        block15: while (true) {
            if ((nt = jp.nextToken()) == null) {
                return currentPdxList;
            }
            switch (nt) {
                case START_OBJECT: {
                    this.objectStarts(currentState);
                    currentState = states.ObJECT_START;
                    Object tmp = this.getPdxInstance(jp, currentState, null);
                    currentPdxList.addObjectField(currentFieldName, (JSONToPdxMapper)tmp);
                    currentState = states.OBJECT_ENDS;
                    continue block15;
                }
                case END_OBJECT: {
                    throw new IllegalStateException("getList got token END_OBJECT while current state is " + (Object)((Object)currentState));
                }
                case FIELD_NAME: {
                    throw new IllegalStateException("getList got token FIELD_NAME while current state is " + (Object)((Object)currentState));
                }
                case NOT_AVAILABLE: {
                    throw new IllegalStateException("NOT_AVAILABLE token found in getList current state is " + (Object)((Object)currentState));
                }
                case START_ARRAY: {
                    this.arrayStarts(currentState);
                    Object tmp = currentPdxList.addListField();
                    currentPdxList = tmp;
                    currentState = states.LIST_FOUND;
                    continue block15;
                }
                case END_ARRAY: {
                    this.arrayEnds(currentState);
                    currentState = states.LIST_ENDS;
                    if (currentPdxList.getParent() == null) {
                        return currentPdxList;
                    }
                    currentPdxList = currentPdxList.getParent();
                    continue block15;
                }
                case VALUE_EMBEDDED_OBJECT: {
                    throw new IllegalStateException("VALUE_EMBEDDED_OBJECT token found");
                }
                case VALUE_FALSE: {
                    this.boolFound(currentState);
                    currentState = states.SCALER_FOUND;
                    currentPdxList.addBooleanField(jp.getBooleanValue());
                    continue block15;
                }
                case VALUE_NULL: {
                    this.nullFound(currentState);
                    currentState = states.SCALER_FOUND;
                    currentPdxList.addNullField(null);
                    continue block15;
                }
                case VALUE_NUMBER_FLOAT: {
                    this.doubleFound(currentState);
                    currentState = states.SCALER_FOUND;
                    this.setNumberField(jp, currentPdxList);
                    continue block15;
                }
                case VALUE_NUMBER_INT: {
                    this.intFound(currentState);
                    currentState = states.SCALER_FOUND;
                    this.setNumberField(jp, currentPdxList);
                    continue block15;
                }
                case VALUE_STRING: {
                    this.stringFound(currentState);
                    currentState = states.SCALER_FOUND;
                    currentPdxList.addStringField(jp.getText());
                    currentFieldName = null;
                    continue block15;
                }
                case VALUE_TRUE: {
                    this.boolFound(currentState);
                    currentState = states.SCALER_FOUND;
                    currentPdxList.addBooleanField(jp.getBooleanValue());
                    continue block15;
                }
            }
            break;
        }
        throw new IllegalStateException("Token not handled in getlist" + (Object)((Object)nt));
    }

    private boolean objectStarts(states currentState) {
        switch (currentState) {
            case NONE: 
            case FIELD_NAME: 
            case OBJECT_ENDS: 
            case SCALER_FOUND: 
            case LIST_FOUND: 
            case LIST_ENDS: {
                return true;
            }
        }
        throw new IllegalStateException("Object start called when state is " + (Object)((Object)currentState));
    }

    private boolean objectEnds(states currentState) {
        switch (currentState) {
            case OBJECT_ENDS: 
            case SCALER_FOUND: 
            case LIST_ENDS: 
            case ObJECT_START: {
                return true;
            }
        }
        throw new IllegalStateException("Object ends called when state is " + (Object)((Object)currentState));
    }

    private boolean arrayStarts(states currentState) {
        switch (currentState) {
            case FIELD_NAME: 
            case SCALER_FOUND: 
            case LIST_FOUND: 
            case LIST_ENDS: {
                return true;
            }
        }
        throw new IllegalStateException("Array start called when state is " + (Object)((Object)currentState));
    }

    private boolean arrayEnds(states currentState) {
        switch (currentState) {
            case FIELD_NAME: 
            case OBJECT_ENDS: 
            case SCALER_FOUND: 
            case LIST_FOUND: 
            case LIST_ENDS: {
                return true;
            }
        }
        throw new IllegalStateException("Array ends called when state is " + (Object)((Object)currentState));
    }

    private boolean stringFound(states currentState) {
        switch (currentState) {
            case FIELD_NAME: 
            case OBJECT_ENDS: 
            case SCALER_FOUND: 
            case LIST_FOUND: 
            case LIST_ENDS: {
                return true;
            }
        }
        throw new IllegalStateException("stringFound called when state is " + (Object)((Object)currentState));
    }

    private boolean intFound(states currentState) {
        switch (currentState) {
            case FIELD_NAME: 
            case OBJECT_ENDS: 
            case SCALER_FOUND: 
            case LIST_FOUND: 
            case LIST_ENDS: {
                return true;
            }
        }
        throw new IllegalStateException("intFound called when state is " + (Object)((Object)currentState));
    }

    private boolean boolFound(states currentState) {
        switch (currentState) {
            case FIELD_NAME: 
            case OBJECT_ENDS: 
            case SCALER_FOUND: 
            case LIST_FOUND: 
            case LIST_ENDS: {
                return true;
            }
        }
        throw new IllegalStateException("boolFound called when state is " + (Object)((Object)currentState));
    }

    private boolean doubleFound(states currentState) {
        switch (currentState) {
            case FIELD_NAME: 
            case OBJECT_ENDS: 
            case SCALER_FOUND: 
            case LIST_FOUND: 
            case LIST_ENDS: {
                return true;
            }
        }
        throw new IllegalStateException("doubleFound called when state is " + (Object)((Object)currentState));
    }

    private boolean fieldFound(states currentState) {
        switch (currentState) {
            case OBJECT_ENDS: 
            case SCALER_FOUND: 
            case LIST_FOUND: 
            case LIST_ENDS: 
            case ObJECT_START: {
                return true;
            }
        }
        throw new IllegalStateException("fieldFound called when state is " + (Object)((Object)currentState));
    }

    private boolean nullFound(states currentState) {
        switch (currentState) {
            case FIELD_NAME: 
            case OBJECT_ENDS: 
            case SCALER_FOUND: 
            case LIST_FOUND: 
            case LIST_ENDS: {
                return true;
            }
        }
        throw new IllegalStateException("nullFound called when state is " + (Object)((Object)currentState));
    }

    static enum states {
        NONE,
        ObJECT_START,
        FIELD_NAME,
        SCALER_FOUND,
        LIST_FOUND,
        LIST_ENDS,
        OBJECT_ENDS;

    }
}

