/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.configuration.utils;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;

public class ZipUtils {
    public static void zipDirectory(Path sourceDirectory, Path targetFile) throws IOException {
        Path p = Files.createFile(targetFile, new FileAttribute[0]);
        try (ZipOutputStream zs = new ZipOutputStream(Files.newOutputStream(p, new OpenOption[0]));){
            Files.walk(sourceDirectory, new FileVisitOption[0]).filter(path -> !Files.isDirectory(path, new LinkOption[0])).forEach(path -> {
                ZipEntry zipEntry = new ZipEntry(sourceDirectory.relativize((Path)path).toString());
                try {
                    zs.putNextEntry(zipEntry);
                    zs.write(Files.readAllBytes(path));
                    zs.closeEntry();
                }
                catch (Exception e) {
                    throw new RuntimeException("Unable to write zip file", e);
                }
            });
        }
    }

    public static void zipDirectory(String sourceDirectoryPath, String targetFilePath) throws IOException {
        Path sourceDirectory = Paths.get(sourceDirectoryPath, new String[0]);
        Path targetFile = Paths.get(targetFilePath, new String[0]);
        ZipUtils.zipDirectory(sourceDirectory, targetFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unzip(String zipFilePath, String outputDirectoryPath) throws IOException {
        ZipFile zipFile = new ZipFile(zipFilePath);
        Enumeration<? extends ZipEntry> zipEntries = zipFile.entries();
        try {
            while (zipEntries.hasMoreElements()) {
                ZipEntry zipEntry = zipEntries.nextElement();
                String fileName = outputDirectoryPath + File.separator + zipEntry.getName();
                if (zipEntry.isDirectory()) {
                    FileUtils.forceMkdir(new File(fileName));
                    continue;
                }
                File entryDestination = new File(fileName);
                File parent = entryDestination.getParentFile();
                if (parent != null) {
                    FileUtils.forceMkdir(parent);
                }
                if (entryDestination.createNewFile()) {
                    InputStream in = zipFile.getInputStream(zipEntry);
                    FileOutputStream out = new FileOutputStream(entryDestination);
                    try {
                        IOUtils.copy(in, (OutputStream)out);
                        continue;
                    }
                    finally {
                        IOUtils.closeQuietly(in);
                        IOUtils.closeQuietly(out);
                        continue;
                    }
                }
                throw new IOException("Cannot create file :" + entryDestination.getCanonicalPath());
            }
        }
        finally {
            zipFile.close();
        }
    }
}

