/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.configuration.messages;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.apache.geode.internal.DataSerializableFixedID;
import org.apache.geode.internal.Version;
import org.apache.geode.internal.lang.StringUtils;

public class ConfigurationRequest
implements DataSerializableFixedID {
    private static int DEFAULT_NUM_ATTEMPTS = 5;
    private Set<String> groups = new HashSet<String>();
    private boolean isRequestForEntireConfiguration = false;
    private int numAttempts = DEFAULT_NUM_ATTEMPTS;

    public ConfigurationRequest() {
    }

    public ConfigurationRequest(Set<String> groups) {
        this.groups = groups;
        this.isRequestForEntireConfiguration = false;
    }

    public ConfigurationRequest(boolean getEntireConfiguration) {
        this.isRequestForEntireConfiguration = true;
    }

    public void addGroups(String group) {
        if (!StringUtils.isBlank(group)) {
            this.groups.add(group);
        }
    }

    @Override
    public int getDSFID() {
        return 2159;
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        out.writeBoolean(this.isRequestForEntireConfiguration);
        int size = this.groups.size();
        out.writeInt(size);
        if (size > 0) {
            for (String group : this.groups) {
                out.writeUTF(group);
            }
        }
        out.writeInt(this.numAttempts);
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        this.isRequestForEntireConfiguration = in.readBoolean();
        int size = in.readInt();
        HashSet<String> groups = new HashSet<String>();
        if (size > 0) {
            for (int i = 0; i < size; ++i) {
                groups.add(in.readUTF());
            }
        }
        this.groups = groups;
        this.numAttempts = in.readInt();
    }

    public Set<String> getGroups() {
        return this.groups;
    }

    public void setGroups(Set<String> groups) {
        this.groups = groups;
    }

    public boolean isRequestForEntireConfiguration() {
        return this.isRequestForEntireConfiguration;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("ConfigurationRequest for groups : ");
        sb.append("\n cluster");
        sb.append(this.groups);
        return sb.toString();
    }

    @Override
    public Version[] getSerializationVersions() {
        return null;
    }

    public int getNumAttempts() {
        return this.numAttempts;
    }

    public void setNumAttempts(int numAttempts) {
        this.numAttempts = numAttempts;
    }
}

