/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.configuration.handlers;

import java.io.IOException;
import org.apache.geode.cache.GemFireCache;
import org.apache.geode.distributed.DistributedSystem;
import org.apache.geode.distributed.internal.ClusterConfigurationService;
import org.apache.geode.distributed.internal.tcpserver.TcpHandler;
import org.apache.geode.distributed.internal.tcpserver.TcpServer;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.management.internal.configuration.messages.ConfigurationRequest;
import org.apache.logging.log4j.Logger;

public class ConfigurationRequestHandler
implements TcpHandler {
    private static final Logger logger = LogService.getLogger();
    ClusterConfigurationService sharedConfig;

    public ConfigurationRequestHandler(ClusterConfigurationService sharedConfig) {
        this.sharedConfig = sharedConfig;
    }

    @Override
    public Object processRequest(Object request) throws IOException {
        assert (request instanceof ConfigurationRequest);
        try {
            logger.info("Received request for configuration  : {}", request);
            ConfigurationRequest configRequest = (ConfigurationRequest)request;
            return this.sharedConfig.createConfigurationReponse(configRequest);
        }
        catch (Exception e) {
            logger.info(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    @Override
    public void endRequest(Object request, long startTime) {
    }

    @Override
    public void endResponse(Object request, long startTime) {
    }

    @Override
    public void shutDown() {
    }

    @Override
    public void init(TcpServer tcpServer) {
    }

    @Override
    public void restarting(DistributedSystem system, GemFireCache cache, ClusterConfigurationService sharedConfig) {
        if (sharedConfig != null) {
            this.sharedConfig = sharedConfig;
        }
    }
}

