/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.remote;

import java.lang.reflect.Method;
import org.apache.geode.internal.ClassPathLoader;
import org.apache.geode.management.ManagementService;
import org.apache.geode.management.cli.CliMetaData;
import org.apache.geode.management.cli.Result;
import org.apache.geode.management.internal.cli.CliAroundInterceptor;
import org.apache.geode.management.internal.cli.GfshParseResult;
import org.apache.geode.management.internal.cli.LogWrapper;
import org.apache.geode.management.internal.cli.remote.CommandExecutionContext;
import org.apache.geode.management.internal.cli.result.FileResult;
import org.apache.geode.management.internal.cli.result.ResultBuilder;
import org.springframework.shell.event.ParseResult;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;

public class RemoteExecutionStrategy {
    private LogWrapper logWrapper = LogWrapper.getInstance();

    public Object execute(ParseResult parseResult) throws RuntimeException {
        Result result;
        block19: {
            result = null;
            Assert.notNull((Object)parseResult, (String)"Parse result required");
            if (!GfshParseResult.class.isInstance(parseResult)) {
                throw new IllegalArgumentException("Command Configuration/Definition error.");
            }
            GfshParseResult gfshParseResult = (GfshParseResult)parseResult;
            Method method = gfshParseResult.getMethod();
            if (!this.isShellOnly(method)) {
                Boolean fromShell = CommandExecutionContext.isShellRequest();
                boolean sentFromShell = fromShell != null && fromShell != false;
                String interceptorClass = this.getInterceptor(gfshParseResult.getMethod());
                CliAroundInterceptor interceptor = null;
                if (!sentFromShell && !"__NULL__".equals(interceptorClass)) {
                    try {
                        interceptor = (CliAroundInterceptor)ClassPathLoader.getLatest().forName(interceptorClass).newInstance();
                    }
                    catch (InstantiationException e) {
                        this.logWrapper.info(e.getMessage());
                    }
                    catch (IllegalAccessException e) {
                        this.logWrapper.info(e.getMessage());
                    }
                    catch (ClassNotFoundException e) {
                        this.logWrapper.info(e.getMessage());
                    }
                    if (interceptor != null) {
                        Result preExecResult = interceptor.preExecution(gfshParseResult);
                        if (Result.Status.ERROR.equals((Object)preExecResult.getStatus())) {
                            return preExecResult;
                        }
                        if (preExecResult instanceof FileResult) {
                            FileResult fileResult = (FileResult)preExecResult;
                            byte[][] fileData = fileResult.toBytes();
                            CommandExecutionContext.setBytesFromShell(fileData);
                        }
                    } else {
                        return ResultBuilder.createBadConfigurationErrorResult("Interceptor Configuration Error");
                    }
                }
                this.logWrapper.info("Executing " + gfshParseResult.getUserInput());
                result = (Result)ReflectionUtils.invokeMethod((Method)gfshParseResult.getMethod(), (Object)gfshParseResult.getInstance(), (Object[])gfshParseResult.getArguments());
                if (result != null && Result.Status.ERROR.equals((Object)result.getStatus())) {
                    this.logWrapper.info("Error occurred while executing \"" + gfshParseResult.getUserInput() + "\".");
                }
                if (interceptor != null) {
                    Result postExecResult = interceptor.postExecution(gfshParseResult, result);
                    if (postExecResult != null) {
                        if (Result.Status.ERROR.equals((Object)postExecResult.getStatus())) {
                            this.logWrapper.warning(postExecResult.toString(), null);
                        } else if (this.logWrapper.fineEnabled()) {
                            this.logWrapper.fine(String.valueOf(postExecResult));
                        }
                        result = postExecResult;
                    }
                    CommandExecutionContext.setBytesFromShell(null);
                }
                break block19;
            }
            throw new IllegalArgumentException("Only Remote command can be executed through " + ManagementService.class.getSimpleName() + ".processCommand() or ManagementMBean's processCommand operation. Please refer documentation for the list of commands.");
        }
        return result;
    }

    private boolean isShellOnly(Method method) {
        CliMetaData cliMetadata = method.getAnnotation(CliMetaData.class);
        return cliMetadata != null && cliMetadata.shellOnly();
    }

    private String getInterceptor(Method method) {
        CliMetaData cliMetadata = method.getAnnotation(CliMetaData.class);
        return cliMetadata != null ? cliMetadata.interceptor() : "__NULL__";
    }

    public void terminate() {
    }
}

