/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.remote;

import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Properties;
import org.apache.geode.internal.security.IntegratedSecurityService;
import org.apache.geode.internal.security.SecurityService;
import org.apache.geode.management.cli.CommandProcessingException;
import org.apache.geode.management.cli.CommandStatement;
import org.apache.geode.management.cli.Result;
import org.apache.geode.management.internal.cli.CommandManager;
import org.apache.geode.management.internal.cli.GfshParser;
import org.apache.geode.management.internal.cli.LogWrapper;
import org.apache.geode.management.internal.cli.remote.CommandExecutionContext;
import org.apache.geode.management.internal.cli.remote.CommandStatementImpl;
import org.apache.geode.management.internal.cli.remote.RemoteExecutionStrategy;
import org.apache.geode.management.internal.cli.result.ResultBuilder;
import org.apache.geode.management.internal.cli.util.CommentSkipHelper;
import org.apache.geode.management.internal.security.ResourceOperation;
import org.apache.geode.security.NotAuthorizedException;
import org.springframework.shell.core.Parser;
import org.springframework.shell.event.ParseResult;

public class CommandProcessor {
    protected RemoteExecutionStrategy executionStrategy;
    protected Parser parser;
    private CommandManager commandManager;
    private int lastExecutionStatus;
    private LogWrapper logWrapper;
    private final Object LOCK = new Object();
    private volatile boolean isStopped = false;
    private SecurityService securityService = IntegratedSecurityService.getSecurityService();

    public CommandProcessor() throws ClassNotFoundException, IOException {
        this(null);
    }

    public CommandProcessor(Properties cacheProperties) throws ClassNotFoundException, IOException {
        this.commandManager = CommandManager.getInstance(cacheProperties);
        this.executionStrategy = new RemoteExecutionStrategy();
        this.parser = new GfshParser(this.commandManager);
        this.logWrapper = LogWrapper.getInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected RemoteExecutionStrategy getExecutionStrategy() {
        Object object = this.LOCK;
        synchronized (object) {
            return this.executionStrategy;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Parser getParser() {
        Object object = this.LOCK;
        synchronized (object) {
            return this.parser;
        }
    }

    public ParseResult parseCommand(String commentLessLine) throws CommandProcessingException, IllegalStateException {
        if (commentLessLine != null) {
            return this.getParser().parse(commentLessLine);
        }
        throw new IllegalStateException("Command String should not be null.");
    }

    public Result executeCommand(CommandStatement cmdStmt) {
        Object result = null;
        Result commandResult = null;
        CommentSkipHelper commentSkipper = new CommentSkipHelper();
        String commentLessLine = commentSkipper.skipComments(cmdStmt.getCommandString());
        if (commentLessLine != null && !commentLessLine.isEmpty()) {
            CommandExecutionContext.setShellEnv(cmdStmt.getEnv());
            RemoteExecutionStrategy executionStrategy = this.getExecutionStrategy();
            try {
                ParseResult parseResult = ((CommandStatementImpl)cmdStmt).getParseResult();
                if (parseResult == null) {
                    parseResult = this.parseCommand(commentLessLine);
                    if (parseResult == null) {
                        this.setLastExecutionStatus(1);
                        return ResultBuilder.createParsingErrorResult(cmdStmt.getCommandString());
                    }
                    ((CommandStatementImpl)cmdStmt).setParseResult(parseResult);
                }
                Method method = parseResult.getMethod();
                ResourceOperation resourceOperation = method.getAnnotation(ResourceOperation.class);
                this.securityService.authorize(resourceOperation);
                result = executionStrategy.execute(parseResult);
                if (result instanceof Result) {
                    commandResult = (Result)result;
                } else {
                    if (this.logWrapper.fineEnabled()) {
                        this.logWrapper.fine("Unknown result type, using toString : " + String.valueOf(result));
                    }
                    commandResult = ResultBuilder.createInfoResult(String.valueOf(result));
                }
            }
            catch (CommandProcessingException e) {
                this.setLastExecutionStatus(1);
                if (this.logWrapper.infoEnabled()) {
                    this.logWrapper.info("Could not parse \"" + cmdStmt.getCommandString() + "\".", e);
                }
                return ResultBuilder.createParsingErrorResult(e.getMessage());
            }
            catch (NotAuthorizedException e) {
                this.setLastExecutionStatus(1);
                if (this.logWrapper.infoEnabled()) {
                    this.logWrapper.info("Could not execute \"" + cmdStmt.getCommandString() + "\".", e);
                }
                throw e;
            }
            catch (RuntimeException e) {
                this.setLastExecutionStatus(1);
                if (this.logWrapper.infoEnabled()) {
                    this.logWrapper.info("Could not execute \"" + cmdStmt.getCommandString() + "\".", e);
                }
                return ResultBuilder.createGemFireErrorResult("Error while processing command <" + cmdStmt.getCommandString() + "> Reason : " + e.getMessage());
            }
            catch (Exception e) {
                this.setLastExecutionStatus(1);
                if (this.logWrapper.warningEnabled()) {
                    this.logWrapper.warning("Could not execute \"" + cmdStmt.getCommandString() + "\".", e);
                }
                return ResultBuilder.createGemFireErrorResult("Unexpected error while processing command <" + cmdStmt.getCommandString() + "> Reason : " + e.getMessage());
            }
            if (this.logWrapper.fineEnabled()) {
                this.logWrapper.fine("Executed " + commentLessLine);
            }
            this.setLastExecutionStatus(0);
        }
        return commandResult;
    }

    public CommandStatement createCommandStatement(String commandString, Map<String, String> env) {
        return new CommandStatementImpl(commandString, env, this);
    }

    public int getLastExecutionStatus() {
        return this.lastExecutionStatus;
    }

    public void setLastExecutionStatus(int lastExecutionStatus) {
        this.lastExecutionStatus = lastExecutionStatus;
    }

    public boolean isStopped() {
        return this.isStopped;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.LOCK;
        synchronized (object) {
            this.commandManager = null;
            this.executionStrategy = null;
            this.parser = null;
            this.isStopped = true;
        }
    }
}

