/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.parser;

import java.lang.reflect.Method;
import org.apache.commons.lang.StringUtils;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

public class GfshMethodTarget {
    private final Method method;
    private final Object target;
    private final String remainingBuffer;
    private final String key;

    public GfshMethodTarget(Method method, Object target) {
        this(method, target, null, null);
    }

    public GfshMethodTarget(Method method, Object target, String remainingBuffer, String key) {
        Assert.notNull((Object)method, (String)"Method is required");
        Assert.notNull((Object)target, (String)"Target is required");
        this.key = StringUtils.trimToEmpty(key);
        this.method = method;
        this.remainingBuffer = remainingBuffer;
        this.target = target;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (this.getClass() != other.getClass()) {
            return false;
        }
        GfshMethodTarget gfshMethodTarget = (GfshMethodTarget)other;
        if (this.method == null ? gfshMethodTarget.getMethod() != null : !this.method.equals(gfshMethodTarget.getMethod())) {
            return false;
        }
        return !(this.target == null ? gfshMethodTarget.getTarget() != null : !this.target.equals(gfshMethodTarget.getTarget()));
    }

    public int hashCode() {
        return ObjectUtils.nullSafeHashCode((Object[])new Object[]{this.method, this.target});
    }

    public final String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(GfshMethodTarget.class.getSimpleName()).append("[key=" + this.key).append(",remainingBuffer=" + this.remainingBuffer + ",target=" + this.target + ",method=" + this.method + "]");
        return builder.toString();
    }

    public String getKey() {
        return this.key;
    }

    public Method getMethod() {
        return this.method;
    }

    public String getRemainingBuffer() {
        return this.remainingBuffer;
    }

    public Object getTarget() {
        return this.target;
    }
}

