/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.functions;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.geode.cache.execute.Function;
import org.apache.geode.cache.execute.FunctionContext;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.InternalEntity;
import org.apache.geode.management.internal.cli.CliUtil;
import org.apache.geode.management.internal.cli.GfshParser;
import org.apache.geode.management.internal.cli.i18n.CliStrings;

public class NetstatFunction
implements Function,
InternalEntity {
    private static final long serialVersionUID = 1L;
    private static final String OS_NAME_LINUX = "Linux";
    private static final String OS_NAME_MACOS = "darwin";
    private static final String OS_NAME_SOLARIS = "SunOS";
    private static final String OS_NAME_PROP = "os.name";
    private static final String OS_ARCH_PROP = "os.arch";
    private static final String OS_VERSION_PROP = "os.version";
    public static final NetstatFunction INSTANCE = new NetstatFunction();
    private static final String ID = NetstatFunction.class.getName();
    private static final String NETSTAT_COMMAND = "netstat";
    private static final String LSOF_COMMAND = "lsof";

    @Override
    public boolean hasResult() {
        return true;
    }

    @Override
    public void execute(FunctionContext context) {
        InternalDistributedSystem ds = InternalDistributedSystem.getConnectedInstance();
        if (ds.isConnected()) {
            InternalDistributedMember distributedMember = ds.getDistributedMember();
            String host = distributedMember.getHost();
            NetstatFunctionArgument args = (NetstatFunctionArgument)context.getArguments();
            boolean withlsof = args.isWithlsof();
            String lineSeparator = args.getLineSeparator();
            String netstatOutput = NetstatFunction.executeCommand(lineSeparator, withlsof);
            StringBuilder netstatInfo = new StringBuilder();
            NetstatFunction.addMemberHostHeader(netstatInfo, "{0}", host, lineSeparator);
            context.getResultSender().lastResult(new NetstatFunctionResult(host, netstatInfo.toString(), CliUtil.compressBytes(netstatOutput.getBytes())));
        }
    }

    private static void addMemberHostHeader(StringBuilder netstatInfo, String id, String host, String lineSeparator) {
        StringBuilder memberPlatFormInfo = new StringBuilder();
        String osInfo = System.getProperty(OS_NAME_PROP) + " " + System.getProperty(OS_VERSION_PROP) + " " + System.getProperty(OS_ARCH_PROP);
        memberPlatFormInfo.append(CliStrings.format("Host: {1}{3}OS: {2}{3}Member(s):{3} {0}", id, host, osInfo, lineSeparator));
        int nameIdLength = Math.max(Math.max(id.length(), host.length()), osInfo.length()) * 2;
        StringBuilder netstatInfoBottom = new StringBuilder();
        for (int i = 0; i < nameIdLength; ++i) {
            netstatInfo.append("#");
            netstatInfoBottom.append("#");
        }
        netstatInfo.append(lineSeparator).append(memberPlatFormInfo.toString()).append(lineSeparator).append(netstatInfoBottom.toString()).append(lineSeparator);
    }

    private static void addNetstatDefaultOptions(List<String> cmdOptionsList) {
        String osName = System.getProperty(OS_NAME_PROP);
        if (OS_NAME_LINUX.equalsIgnoreCase(osName)) {
            cmdOptionsList.add("-v");
            cmdOptionsList.add("-a");
            cmdOptionsList.add("-e");
        } else if (OS_NAME_MACOS.equalsIgnoreCase(osName)) {
            cmdOptionsList.add("-v");
            cmdOptionsList.add("-a");
            cmdOptionsList.add("-e");
        } else if (OS_NAME_SOLARIS.equalsIgnoreCase(osName)) {
            cmdOptionsList.add("-v");
            cmdOptionsList.add("-a");
        } else {
            cmdOptionsList.add("-v");
            cmdOptionsList.add("-a");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void executeNetstat(StringBuilder netstatInfo, String lineSeparator) {
        ArrayList<String> cmdOptionsList = new ArrayList<String>();
        cmdOptionsList.add(NETSTAT_COMMAND);
        NetstatFunction.addNetstatDefaultOptions(cmdOptionsList);
        ProcessBuilder procBuilder = new ProcessBuilder(cmdOptionsList);
        try {
            Process netstat = procBuilder.start();
            InputStreamReader reader = new InputStreamReader(netstat.getInputStream());
            BufferedReader breader = new BufferedReader(reader);
            String line = "";
            while ((line = breader.readLine()) != null) {
                netstatInfo.append(line).append(lineSeparator);
            }
            netstat.destroy();
        }
        catch (IOException e) {
            netstatInfo.append(CliStrings.format("Could not execute \"{0}\". Reason: {1}", NETSTAT_COMMAND, e.getMessage()));
        }
        finally {
            netstatInfo.append(lineSeparator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void executeLsof(StringBuilder existingNetstatInfo, String lineSeparator) {
        String osName = System.getProperty(OS_NAME_PROP);
        existingNetstatInfo.append("################ lsof output ###################").append(lineSeparator);
        if (OS_NAME_LINUX.equalsIgnoreCase(osName) || OS_NAME_MACOS.equalsIgnoreCase(osName) || OS_NAME_SOLARIS.equalsIgnoreCase(osName)) {
            ProcessBuilder procBuilder = new ProcessBuilder(LSOF_COMMAND);
            try {
                Process lsof = procBuilder.start();
                InputStreamReader reader = new InputStreamReader(lsof.getInputStream());
                BufferedReader breader = new BufferedReader(reader);
                String line = "";
                while ((line = breader.readLine()) != null) {
                    existingNetstatInfo.append(line).append(lineSeparator);
                }
                lsof.destroy();
            }
            catch (IOException e) {
                String message = e.getMessage();
                if (message.contains("error=2, No such file or directory")) {
                    existingNetstatInfo.append(CliStrings.format("Could not execute \"{0}\". Reason: {1}", LSOF_COMMAND, "lsof command not in current path"));
                }
                existingNetstatInfo.append(CliStrings.format("Could not execute \"{0}\". Reason: {1}", LSOF_COMMAND, e.getMessage()));
            }
            finally {
                existingNetstatInfo.append(lineSeparator);
            }
        } else {
            existingNetstatInfo.append("Not available for Windows.").append(lineSeparator);
        }
    }

    public static String executeCommand(String lineSeparator, boolean withlsof) {
        StringBuilder netstatInfo = new StringBuilder();
        NetstatFunction.executeNetstat(netstatInfo, lineSeparator);
        if (withlsof) {
            NetstatFunction.executeLsof(netstatInfo, lineSeparator);
        }
        return netstatInfo.toString();
    }

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public boolean optimizeForWrite() {
        return false;
    }

    @Override
    public boolean isHA() {
        return false;
    }

    public static void main(String[] args) {
        String netstat = NetstatFunction.executeCommand(GfshParser.LINE_SEPARATOR, true);
        System.out.println(netstat);
    }

    public static class NetstatFunctionResult
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final String host;
        private final String headerInfo;
        private final CliUtil.DeflaterInflaterData compressedBytes;

        public NetstatFunctionResult(String host, String headerInfo, CliUtil.DeflaterInflaterData compressedBytes) {
            this.host = host;
            this.headerInfo = headerInfo;
            this.compressedBytes = compressedBytes;
        }

        public String getHost() {
            return this.host;
        }

        public String getHeaderInfo() {
            return this.headerInfo;
        }

        public CliUtil.DeflaterInflaterData getCompressedBytes() {
            return this.compressedBytes;
        }
    }

    public static class NetstatFunctionArgument
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final String lineSeparator;
        private final boolean withlsof;

        public NetstatFunctionArgument(String lineSeparator, boolean withlsof) {
            this.lineSeparator = lineSeparator;
            this.withlsof = withlsof;
        }

        public String getLineSeparator() {
            return this.lineSeparator;
        }

        public boolean isWithlsof() {
            return this.withlsof;
        }
    }
}

