/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.functions;

import java.util.HashMap;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.CacheFactory;
import org.apache.geode.cache.execute.Function;
import org.apache.geode.cache.execute.FunctionContext;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.internal.InternalEntity;
import org.apache.geode.management.internal.cli.CliUtil;

public class GarbageCollectionFunction
implements Function,
InternalEntity {
    public static final String ID = GarbageCollectionFunction.class.getName();
    private static final long serialVersionUID = 1L;

    @Override
    public void execute(FunctionContext context) {
        StringBuilder str1 = new StringBuilder();
        HashMap<String, String> resultMap = null;
        try {
            Cache cache = CacheFactory.getAnyInstance();
            DistributedMember member = cache.getDistributedSystem().getDistributedMember();
            long freeMemoeryBeforeGC = Runtime.getRuntime().freeMemory();
            long totalMemoryBeforeGC = Runtime.getRuntime().totalMemory();
            long timeBeforeGC = System.currentTimeMillis();
            Runtime.getRuntime().gc();
            long freeMemoeryAfterGC = Runtime.getRuntime().freeMemory();
            long totalMemoryAfterGC = Runtime.getRuntime().totalMemory();
            long timeAfterGC = System.currentTimeMillis();
            long megaBytes = 131072L;
            resultMap = new HashMap<String, String>();
            resultMap.put("MemberId", member.getId());
            resultMap.put("HeapSizeBeforeGC", String.valueOf((totalMemoryBeforeGC - freeMemoeryBeforeGC) / megaBytes));
            resultMap.put("HeapSizeAfterGC", String.valueOf((totalMemoryAfterGC - freeMemoeryAfterGC) / megaBytes));
            resultMap.put("TimeSpentInGC", String.valueOf(timeAfterGC - timeBeforeGC));
        }
        catch (Exception ex) {
            str1.append("Exception in GC:" + ex.getMessage() + CliUtil.stackTraceAsString(ex));
            context.getResultSender().lastResult(str1.toString());
        }
        context.getResultSender().lastResult(resultMap);
    }

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public boolean hasResult() {
        return true;
    }

    @Override
    public boolean optimizeForWrite() {
        return false;
    }

    @Override
    public boolean isHA() {
        return false;
    }
}

