/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.functions;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.CacheFactory;
import org.apache.geode.cache.execute.FunctionAdapter;
import org.apache.geode.cache.execute.FunctionContext;
import org.apache.geode.cache.query.Index;
import org.apache.geode.cache.query.MultiIndexCreationException;
import org.apache.geode.cache.query.QueryService;
import org.apache.geode.internal.InternalEntity;
import org.apache.geode.management.internal.cli.domain.IndexInfo;
import org.apache.geode.management.internal.cli.functions.CliFunctionResult;
import org.apache.geode.management.internal.cli.i18n.CliStrings;

public class CreateDefinedIndexesFunction
extends FunctionAdapter
implements InternalEntity {
    private static final long serialVersionUID = 1L;

    @Override
    public void execute(FunctionContext context) {
        String memberId = null;
        List<Index> indexes = null;
        Cache cache = null;
        try {
            cache = CacheFactory.getAnyInstance();
            memberId = cache.getDistributedSystem().getDistributedMember().getId();
            QueryService queryService = cache.getQueryService();
            Set indexDefinitions = (Set)context.getArguments();
            for (IndexInfo indexDefinition : indexDefinitions) {
                String indexName = indexDefinition.getIndexName();
                String indexedExpression = indexDefinition.getIndexedExpression();
                String regionPath = indexDefinition.getRegionPath();
                if (indexDefinition.getIndexType() == 2) {
                    queryService.defineKeyIndex(indexName, indexedExpression, regionPath);
                    continue;
                }
                if (indexDefinition.getIndexType() == 3) {
                    queryService.defineHashIndex(indexName, indexedExpression, regionPath);
                    continue;
                }
                queryService.defineIndex(indexName, indexedExpression, regionPath);
            }
            indexes = queryService.createDefinedIndexes();
            context.getResultSender().lastResult(new CliFunctionResult(memberId));
        }
        catch (MultiIndexCreationException e) {
            StringBuffer sb = new StringBuffer();
            sb.append("Index creation failed for indexes: ").append("\n");
            for (Map.Entry<String, Exception> failedIndex : e.getExceptionsMap().entrySet()) {
                sb.append(failedIndex.getKey()).append(" : ").append(failedIndex.getValue().getMessage()).append("\n");
            }
            context.getResultSender().lastResult(new CliFunctionResult(memberId, e, sb.toString()));
        }
        catch (Exception e) {
            String exceptionMessage = CliStrings.format("Exception : {0} , Message : {1}", e.getClass().getName(), e.getMessage());
            context.getResultSender().lastResult(new CliFunctionResult(memberId, e, exceptionMessage));
        }
    }

    public void createCommandObject(IndexInfo info) {
        Cache cache = CacheFactory.getAnyInstance();
        QueryService queryService = cache.getQueryService();
    }

    @Override
    public String getId() {
        return CreateDefinedIndexesFunction.class.getName();
    }
}

